import Vue from 'vue'
import Router from 'vue-router'
import Home from './views/Home.vue'

Vue.use(Router);

export default new Router({
	//mode: 'history',
	base: process.env.BASE_URL,
	routes: [
		{
			path: '/',
			name: 'home',
			component: Home
		},
		{
			path: '/editor/:projectID',
			name: 'editor',
			component: () => import('./views/Editor.vue')
		},
		{
			path: '/preview/:projectID',
			name: 'preview',
			component: () => import('./views/Preview.vue')
		},
		{
			path: '/diff',
			name: 'diff',
			component: () => import('./views/ProjectDiff.vue')
		},
	]
})
