
/**
 * 获取customElement下的所有组件
 */
export const getComposedComponents = () => {
  // 去中心化;
  const context = require.context(
    '../components/customElement',
    true,
    /index\.js$/
  );

  const composedComponents = {};
  context.keys().forEach((key) => {
    const componentName = key.slice(2, -9);
    const component = context(key);

    composedComponents[componentName] = component.default;
  });

  console.log('composedComponents', composedComponents);
  
  return composedComponents;
}
