/**
 * Created by rockyl on 2019-09-19.
 *
 * 包相关api
 */

import {fetchApi} from "./common";

export async function fetchPackageInfos(type = 0) {
	return await fetchApi('/package/query-info/' + type, {
		errMessage: 'Failed to fetch package infos',
	})
}

export async function fetchPackages(schema) {
	return await fetchApi('/package/query', {
		params: {
			schema,
		},
		method: 'post',
		errMessage: 'Failed to fetch packages',
	})
}
