/**
 * Created by rockyl on 2020-02-07.
 */

import {fetchApi} from "./common";

let devPersons;

export async function getDevPersons() {
	if (!devPersons) {
		devPersons = await fetchApi('/api/editor/devPersons');
	}
	return devPersons
}

export async function importView(file) {
	const response = await fetchApi('/api/parsePSD', {
		params: {
			file,
		},
		method: 'post',
		contentType: 'form-data',
		errMessage: 'Failed to import view',
	});
	response.__originFile = file;
	return response
}

export async function uploadView(file) {
	const response = await fetchApi('/api/uploadView', {
		params: {
			file,
		},
		method: 'post',
		contentType: 'form-data',
		errMessage: 'Failed to upload view',
	});
	response.__originFile = file;
	return response
}

export async function uploadFile(file, compress = false, uuid) {
	let params = {file};
	if (compress) {
		params.compress = true
	}
	if (uuid) {
		params.uuid = uuid
	}
	const response = await fetchApi('/api/uploadFile', {
		params,
		method: 'post',
		contentType: 'form-data',
		errMessage: 'Failed to upload file',
	});
	response.__originFile = file;
	return response
}
