const data = {
	"data": {
		"components": [], "name": "Zeroing Editor", "processes": [{
			"behavior_id": "duiba-api",
			"id": 11,
			"data": "{\n  \"name\": \"兑吧接口\",\n  \"desc\": \"通用兑吧接口\",\n  \"props\": {\n    \"url\": {\n      \"type\": \"string\",\n      \"alias\": \"链接\"\n    },\n    \"method\": {\n      \"type\": \"enum\",\n      \"enum\": [\n        \"get\",\n        \"post\"\n      ],\n      \"alias\": \"方法\",\n      \"default\": \"get\"\n    },\n    \"name\": {\n      \"type\": \"string\",\n      \"alias\": \"数据名\"\n    }\n  },\n  \"output\": [\n    \"success\",\n    \"failed\"\n  ],\n  \"sub\": {\n    \"5fc7ba4d-6afa-4eab-82d8-f25cbcb79d56\": {\n      \"uuid\": \"5fc7ba4d-6afa-4eab-82d8-f25cbcb79d56\",\n      \"meta\": \"entry\",\n      \"design\": {\n        \"x\": 10,\n        \"y\": 10,\n        \"input\": {},\n        \"output\": {\n          \"success\": [\n            {\n              \"x\": 124.5,\n              \"y\": 31\n            }\n          ]\n        }\n      },\n      \"props\": {},\n      \"output\": {\n        \"success\": [\n          \"69e28053-dfb3-459e-a9e5-4964c6e35193\"\n        ]\n      }\n    },\n    \"69e28053-dfb3-459e-a9e5-4964c6e35193\": {\n      \"uuid\": \"69e28053-dfb3-459e-a9e5-4964c6e35193\",\n      \"meta\": \"http-request\",\n      \"design\": {\n        \"x\": 67,\n        \"y\": 139,\n        \"input\": {\n          \"default\": [\n            {\n              \"x\": 5.5,\n              \"y\": 47.5\n            }\n          ]\n        },\n        \"output\": {\n          \"success\": [\n            {\n              \"x\": 124.5,\n              \"y\": 33.5\n            }\n          ],\n          \"failed\": [\n            {\n              \"x\": 124.5,\n              \"y\": 47.5\n            }\n          ],\n          \"exception\": [\n            {\n              \"x\": 124.5,\n              \"y\": 61.5\n            }\n          ]\n        }\n      },\n      \"props\": {\n        \"url\": {\n          \"type\": \"link\"\n        },\n        \"method\": {\n          \"type\": \"link\"\n        }\n      },\n      \"output\": {\n        \"success\": [\n          \"39dce565-539b-44b6-901c-0344467795a8\"\n        ]\n      }\n    },\n    \"39dce565-539b-44b6-901c-0344467795a8\": {\n      \"uuid\": \"39dce565-539b-44b6-901c-0344467795a8\",\n      \"meta\": \"duiba-api-transform\",\n      \"design\": {\n        \"x\": 184,\n        \"y\": 275,\n        \"input\": {\n          \"default\": [\n            {\n              \"x\": 5.5,\n              \"y\": 30.5\n            }\n          ]\n        },\n        \"output\": {\n          \"success\": [\n            {\n              \"x\": 124.5,\n              \"y\": 23.5\n            }\n          ],\n          \"failed\": [\n            {\n              \"x\": 124.5,\n              \"y\": 37.5\n            }\n          ]\n        }\n      },\n      \"props\": {},\n      \"output\": {\n        \"success\": [\n          \"e95e7bbc-b592-4f87-b433-77fd03a9ef51\"\n        ]\n      }\n    },\n    \"e95e7bbc-b592-4f87-b433-77fd03a9ef51\": {\n      \"uuid\": \"e95e7bbc-b592-4f87-b433-77fd03a9ef51\",\n      \"meta\": \"put-data\",\n      \"design\": {\n        \"x\": 280,\n        \"y\": 367,\n        \"input\": {\n          \"default\": [\n            {\n              \"x\": 5.5,\n              \"y\": 47.5\n            }\n          ]\n        },\n        \"output\": {\n          \"success\": [\n            {\n              \"x\": 124.5,\n              \"y\": 47.5\n            }\n          ]\n        }\n      },\n      \"props\": {\n        \"name\": {\n          \"type\": \"link\"\n        }\n      },\n      \"output\": {}\n    }\n  },\n  \"subEntry\": \"5fc7ba4d-6afa-4eab-82d8-f25cbcb79d56\",\n  \"metas\": [\n    {\n      \"id\": \"duiba-api-transform\",\n      \"script\": \"if (args.success) {\\n    next('success', args.data);\\n}\\nelse {\\n    next('failed');\\n}\\n\",\n      \"props\": {},\n      \"isInline\": true,\n      \"name\": \"兑吧接口转换\",\n      \"output\": [\n        \"success\",\n        \"failed\"\n      ],\n      \"desc\": \"将http请求返回成兑吧接口的解析\"\n    }\n  ],\n  \"id\": \"duiba-api\",\n  \"script\": \"next('success');\\n\",\n  \"group\": \"duiba\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-19T06:24:44.000Z"
		}, {
			"behavior_id": "get-data",
			"id": 15,
			"data": "{\n  \"name\": \"获取数据\",\n  \"desc\": \"从数据中心获取数据，优先判断名称\",\n  \"props\": {\n    \"name\": {\n      \"type\": \"string\",\n      \"alias\": \"名称\"\n    },\n    \"path\": {\n      \"type\": \"string\",\n      \"alias\": \"路径\"\n    }\n  },\n  \"output\": [\n    \"success\"\n  ],\n  \"id\": \"get-data\",\n  \"script\": \"var data;\\nif (props.path) {\\n    data = engine.gameStage.dataCenter.getDataByPath(props.path);\\n}\\nelse {\\n    data = engine.gameStage.dataCenter.getGroup(props.name);\\n}\\nnext('success', data);\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T07:43:01.000Z"
		}, {
			"behavior_id": "log",
			"id": 4,
			"data": "{\n  \"name\": \"日志\",\n  \"desc\": \"打印日志\",\n  \"props\": {\n    \"content\": {\n      \"alias\": \"内容\",\n      \"type\": \"string\",\n      \"default\": \"\"\n    },\n    \"error\": {\n      \"alias\": \"是否错误模式\",\n      \"type\": \"boolean\",\n      \"default\": false\n    }\n  },\n  \"output\": [\n    \"success\"\n  ],\n  \"id\": \"log\",\n  \"script\": \"console.log(props ? props.content : (args ? args.content : ''));\\nnext('success');\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:35:22.000Z"
		}, {
			"behavior_id": "goto-record",
			"id": 8,
			"data": "{\n  \"name\": \"跳转到中奖记录\",\n  \"desc\": \"跳转到中奖记录页面\",\n  \"props\": {},\n  \"output\": [\n    \"success\"\n  ],\n  \"id\": \"goto-record\",\n  \"script\": \"location.href = '/record';\\nnext('success');\\n\",\n  \"group\": \"duiba\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:31:33.000Z"
		}, {
			"behavior_id": "compare",
			"id": 3,
			"data": "{\n  \"name\": \"比较\",\n  \"desc\": \"比较两个值\",\n  \"props\": {\n    \"left\": {\n      \"alias\": \"左值\",\n      \"type\": \"any\",\n      \"default\": \"\"\n    },\n    \"right\": {\n      \"alias\": \"右值\",\n      \"type\": \"any\",\n      \"default\": \"\"\n    },\n    \"strict\": {\n      \"alias\": \"严格模式\",\n      \"type\": \"any\",\n      \"default\": \"\"\n    },\n    \"operator\": {\n      \"alias\": \"操作符\",\n      \"type\": \"enum\",\n      \"enum\": [\n        \"==\",\n        \">\",\n        \">=\",\n        \"<\",\n        \"<=\",\n        \"!=\"\n      ],\n      \"default\": \"==\"\n    }\n  },\n  \"output\": [\n    \"equal\",\n    \"unequal\"\n  ],\n  \"id\": \"compare\",\n  \"script\": \"setTimeout(function () {\\n    next('complete');\\n}, args ? args.duration : (props.duration || 0));\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:30:52.000Z"
		}, {
			"behavior_id": "entry",
			"id": 1,
			"data": "{\n  \"name\": \"入口\",\n  \"desc\": \"入口节点，每个行为的入口\",\n  \"props\": {},\n  \"output\": [\n    \"success\"\n  ],\n  \"id\": \"entry\",\n  \"script\": \"next('success');\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:30:44.000Z"
		}, {
			"behavior_id": "push-dialog",
			"id": 6,
			"data": "{\n  \"name\": \"弹出弹窗\",\n  \"desc\": \"根据视图名弹出弹窗\",\n  \"props\": {\n    \"viewName\": {\n      \"alias\": \"目标视图名\",\n      \"type\": \"string\"\n    },\n    \"center\": {\n      \"alias\": \"是否居中展示\",\n      \"type\": \"boolean\",\n      \"default\": true\n    }\n  },\n  \"output\": [\n    \"complete\"\n  ],\n  \"id\": \"push-dialog\",\n  \"script\": \"if (!props.viewName) {\\n    console.log('没有设置视图名');\\n    next('exception', '没有设置视图名');\\n}\\nelse {\\n    var gameStage = engine.gameStage;\\n    var viewConfig = gameStage.getViewConfigByName(props.viewName);\\n    if (viewConfig) {\\n        var view = engine.instantiate(viewConfig);\\n        gameStage.popupContainer.push(view, { center: props.center || true });\\n    }\\n    else {\\n        console.error('view config not exists');\\n    }\\n}\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:30:35.000Z"
		}, {
			"behavior_id": "pop-dialog",
			"id": 7,
			"data": "{\n  \"name\": \"关闭弹窗\",\n  \"desc\": \"关闭弹窗\",\n  \"props\": {\n    \"closeAll\": {\n      \"alias\": \"是否关闭全部弹窗\",\n      \"type\": \"boolean\",\n      \"default\": false\n    }\n  },\n  \"output\": [\n    \"complete\"\n  ],\n  \"id\": \"pop-dialog\",\n  \"script\": \"if (props.closeAll) {\\n    engine.gameStage.popupContainer.popAll();\\n}\\nelse {\\n    engine.gameStage.popupContainer.pop();\\n}\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:30:27.000Z"
		}, {
			"behavior_id": "put-data",
			"id": 10,
			"data": "{\n  \"name\": \"放置数据\",\n  \"desc\": \"在数据中心放置数据\",\n  \"props\": {\n    \"name\": {\n      \"type\": \"string\",\n      \"alias\": \"名称\"\n    },\n    \"path\": {\n      \"type\": \"string\",\n      \"alias\": \"路径\"\n    }\n  },\n  \"output\": [\n    \"success\"\n  ],\n  \"id\": \"put-data\",\n  \"script\": \"engine.gameStage.dataCenter.mutate(props.name, args, props.path);\\nnext('success', args);\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:23:56.000Z"
		}, {
			"behavior_id": "wait",
			"id": 2,
			"data": "{\n  \"name\": \"等待\",\n  \"desc\": \"等待一段时间后继续\",\n  \"props\": {\n    \"duration\": {\n      \"alias\": \"时间(毫秒)\",\n      \"type\": \"number\",\n      \"default\": 1000\n    }\n  },\n  \"output\": [\n    \"complete\"\n  ],\n  \"id\": \"wait\",\n  \"script\": \"setTimeout(function () {\\n    next('complete');\\n}, args ? args.duration : (props.duration || 0));\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:23:47.000Z"
		}, {
			"behavior_id": "set-mouse-enabled",
			"id": 14,
			"data": "{\n  \"name\": \"设置可否交互\",\n  \"desc\": \"设置可否交互\",\n  \"props\": {\n    \"target\": {\n      \"type\": \"node\",\n      \"alias\": \"目标节点\"\n    },\n    \"enabled\": {\n      \"type\": \"boolean\",\n      \"alias\": \"可否交互\",\n      \"default\": false\n    }\n  },\n  \"output\": [\n    \"success\"\n  ],\n  \"id\": \"set-mouse-enabled\",\n  \"script\": \"var targetNode = target || props.target;\\nif (targetNode) {\\n    targetNode.mouseEnabled = props.enabled;\\n    next('success');\\n}\\n\",\n  \"group\": \"base\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:23:34.000Z"
		}, {
			"behavior_id": "http-request",
			"id": 5,
			"data": "{\n  \"name\": \"HttpRequest\",\n  \"desc\": \"http请求\",\n  \"props\": {\n    \"url\": {\n      \"type\": \"string\",\n      \"alias\": \"地址\"\n    },\n    \"method\": {\n      \"type\": \"enum\",\n      \"enum\": [\n        \"get\",\n        \"post\"\n      ],\n      \"alias\": \"方法\",\n      \"default\": \"get\"\n    }\n  },\n  \"output\": [\n    \"success\",\n    \"failed\",\n    \"exception\"\n  ],\n  \"id\": \"http-request\",\n  \"script\": \"if (!props.url) {\\n    console.log('url is empty');\\n    next('exception', '\\\\'url is empty\\\\'');\\n}\\nelse {\\n    engine.globalLoader.httpRequest(function (s, payload) {\\n        if (s) {\\n            next('success', payload);\\n        }\\n        else {\\n            next('failed', payload);\\n        }\\n    }, props.url, props.method || 'get', 'json');\\n}\\n\",\n  \"group\": \"net\",\n  \"type\": \"builtin\"\n}\n",
			"update_time": "2019-11-18T06:21:30.000Z"
		}], "scripts": [{
			"script_id": "zoom-button",
			"id": 2,
			"data": "{\"id\":\"zoom-button\",\"name\":\"ZoomButton\",\"props\":{\"zoomTo\":{\"type\":\"number\",\"default\":1.1}},\"code\":\"\\\"use strict\\\";\\nexports.__esModule = true;\\nvar ZoomButton = (function () {\\n    function ZoomButton() {\\n        this.zoomTo = 1.1;\\n    }\\n    ZoomButton.prototype.mounted = function () {\\n        this.host.anchorX = this.host.width / 2;\\n        this.host.anchorY = this.host.height / 2;\\n        this.host.addEventListener(engine.MouseEvent.MOUSE_DOWN, this._onMouseDown, this);\\n        this.host.addEventListener(engine.MouseEvent.MOUSE_UP, this._onMouseUp, this);\\n    };\\n    ZoomButton.prototype._onMouseDown = function (e) {\\n        this.host.scaleX = this.host.scaleY = this.zoomTo;\\n    };\\n    ZoomButton.prototype._onMouseUp = function (e) {\\n        this.host.scaleX = this.host.scaleY = 1;\\n    };\\n    ZoomButton.id = 'zoom-button';\\n    return ZoomButton;\\n}());\\nexports[\\\"default\\\"] = ZoomButton;\"}",
			"update_time": "2019-11-14T10:32:12.000Z"
		}, {
			"script_id": "wave",
			"id": 1,
			"data": "{\"id\":\"wave\",\"name\":\"Wave\",\"props\":{\"duration\":{\"type\":\"number\",\"default\":1000},\"name\":{\"type\":\"string\",\"default\":\"hello\"},\"color\":{\"type\":\"color\",\"default\":\"#123456\"},\"type\":{\"type\":[\"rotate\",\"jump\",\"breath\"],\"default\":\"rotate\"},\"ease\":{\"type\":[\"linear\",\"cubic\",\"back\"],\"default\":\"linear\"},\"autoPlay\":{\"type\":\"boolean\",\"default\":false}},\"code\":\"\\\"use strict\\\";\\nexports.__esModule = true;\\nvar Wave = (function () {\\n    function Wave() {\\n    }\\n    Wave.prototype.mounted = function () {\\n        console.log('mounted', this.duration);\\n        this.host.anchorX = this.host.width / 2;\\n        this.host.anchorY = this.host.height / 2;\\n    };\\n    Wave.prototype.destroy = function () {\\n        console.log('destroy');\\n    };\\n    Wave.prototype.update = function (t) {\\n        this.host.rotation = t * 0.1;\\n    };\\n    Wave.prototype.awake = function () {\\n        console.log('awake');\\n    };\\n    Wave.prototype.sleep = function () {\\n        console.log('sleep');\\n    };\\n    Wave.id = 'wave';\\n    return Wave;\\n}());\\nexports[\\\"default\\\"] = Wave;\"}",
			"update_time": "2019-11-14T10:31:55.000Z"
		}], "templates": {"builtin": ["blank"], "custom": []}, "version": "1.0.0"
	}, "success": true
};

module.exports = function () {
	return data;
};

//console.log(JSON.stringify(data));
//console.log(data.data.scripts[1]);
