/**
 * Created by rockyl on 2019-11-25.
 */

var curDocument = app.activeDocument;

//alert(ShowObjProperty2(curDocument.activeLayer).attributes);
//alert(ShowObjProperty2(oldDocument.activeLayer).methods);

for (var i = 0; i < curDocument.layers.length; i++) {
	var layer = curDocument.layers[i];
	if (!layer.name.match(/__e$/)) {
		duplicateToNewDocument(layer);
	}
}

function createDocument(width, height, docName) {

//定义一个变量[resolution]，表示新文档的分辨率。
	var resolution = 72;

//定义一个变量[mode]，表示新文档的颜色模式。
	var mode = NewDocumentMode.RGB;

//定义一个变量[initialFill]，表示新文档的默认背景填充颜色。
	var initialFill = DocumentFill.TRANSPARENT;

//定义一个变量[pixelAspectRatio]，用来设置新文档的像素比率。
	var pixelAspectRatio = 1;

//使用[Documents.add]命令创建一个新文档，将设置好的参数放在[add]方法里面。
	var document = app.documents.add(width, height, resolution, docName, mode, initialFill, pixelAspectRatio);
	return document;
}

function duplicateToNewDocument(layer) {
	var document = createDocument(curDocument.width, curDocument.height, layer.name);
	app.activeDocument = curDocument;
	layer.duplicate(document, ElementPlacement.PLACEATBEGINNING);
}

function ShowObjProperty2(obj) {
	// 用来保存所有的属性名称和值
	var attributes = '';
	var methods = '';
	// 开始遍历
	for (var p in obj) {
		// 方法
		if (typeof (obj[p]) === "function") {
			methods += '属性：' + p + '\r\n'
			// obj[p]();
		} else {
			// p 为属性名称，obj[p]为对应属性的值
			attributes += '方法：' + p + " = " + obj[p] + "\r\n";
		}
	}
	// 最后显示所有的属性
	return {
		attributes: attributes,
		methods: methods
	}
}
