/**
 * Created by rockyl on 2020-02-13.
 */

const FormData = require('form-data');
const fs = require('fs-extra');
const isPng = require("is-png");
const isJpg = require("is-jpg");

const tinifyUrl = 'https://tinify.duiba.com.cn/tinify';

/**
 * 压缩图片
 * @param {Buffer|string} bufferOrFile
 * @return Promise<Buffer>
 */
export async function compress(bufferOrFile: Buffer | string) {
	let buffer = bufferOrFile;
	if (typeof bufferOrFile === 'string') {
		buffer = await fs.readFile(bufferOrFile);
	}
	return new Promise((resolve, reject) => {
		if (buffer && buffer.length > 0) {
			let extname = isPng(buffer as Buffer) ? 'png' : 'jpeg';
			let form = new FormData();
			form.append('file', buffer, {
				filename: 'image.' + extname,
				contentType: 'image/' + extname,
			});

			form.submit(tinifyUrl, function (err, res) {
				if (err) {
					reject(err);
				} else {
					res.resume();
					let resBuffer = Buffer.alloc(0);
					res.on('data', (d) => {
						resBuffer = Buffer.concat([resBuffer, d], resBuffer.length + d.length);
					});
					res.on('end', () => {
						if (resBuffer.length > 256 || isPng(resBuffer) || isJpg(resBuffer)) {
							resolve(resBuffer);
						} else {
							let str = resBuffer.toString();
							let json;
							try {
								json = JSON.parse(str);
							} catch (e) {
								console.log(str)
								console.log(e);
							}
							reject(json?.msg);
						}
					});
					res.on('abort', () => {
						reject('abort')
					});
				}
			});
		} else {
			reject('empty buffer')
		}
	})
}
