/**
 * Created by rockyl on 2019-05-15.
 */
import {engine} from "scilla";

export function renderRunCredits(v) {
	const unitName = engine.dataCenter.get('CFG', 'unitName');

	return Math.floor(v) + unitName;
}

export function htmlSimplify(html: string): string {
	let content = html
		.replace(/<\/\w+><\w+>/ig, '\n')
		.replace(/<\w+>/ig, '\n')
		.replace(/<\/\w+>/ig, '\n')
		.replace(/<\w+\/>/ig, '\n')
		.replace('&nbsp;', '')

	content = content.trim();

	return content;
}

export function isWeiXin() {
	const ua = window.navigator.userAgent.toLowerCase();
	return ua.includes('micromessenger');
}

export function stringFixed(str, limit = 6, mask = '…'){
	if(str.length > limit){
		return str.substr(0, limit) + mask;
	}
	return str;
}
