/**
 * Created by rockyl on 2019-04-09.
 */

import {createTween, ease, Entity} from "scilla";

export async function playAnimation(config, context){
	for(let partName in config){
		let partConfig = config[partName];
		let part:Entity = context[partName];

		for(let componentName in partConfig){
			let component = part.getComponentByName(componentName);
			let {params, duration, ease: easeName} = partConfig[componentName];

			createTween(context, component)
				.to(params, duration, ease[easeName]);
		}
	}
}