/**
 * Created by rockyl on 2019-05-07.
 *
 * 物品
 */

import ScillaComponent from "components/base/ScillaComponent";
import {Entity} from "scilla";
import FloatMissing from "../common/FloatMissing";
import TextRenderer from "components/renderer/TextRenderer";

export default class Item extends ScillaComponent {
	creditsEntity: Entity;
	Label: Entity;
	exclude = false;

	private _floatMissing: FloatMissing;
	private _label: TextRenderer;
	private _playing = false;

	onAwake() {
		super.onAwake();

		this._floatMissing = this.creditsEntity.getComponent(FloatMissing);
		this._label = this.Label.getComponent(TextRenderer);
	}

	reset(pos) {
		this.transform.position.copyFrom(pos);
		this.entity.enabled = true;
		this.exclude = false;
		this._playing = false;
	}

	async playCredits(cost) {
		this._label.text = cost.toString();
		this.creditsEntity.enabled = true;
		this._floatMissing.delay = Math.random() * 500;

		this._playing = true;
		await this._floatMissing.play();
		this._playing = false;
	}

	stopCredits() {
		this.creditsEntity.enabled = false;
	}

	get playing() {
		return this._playing;
	}

	hit(x, y, hitWidth, hitHeight) {
		const {x: px, y: py} = this.transform.position;

		return x > px - hitWidth / 2 && x < px + hitWidth / 2 && py && y > py - hitHeight / 2 && y < py + hitHeight / 2;
	}
}
