/**
 * Created by rockyl on 2019-05-10.
 *
 * 波动画控制器
 */

import InteractComponent from "components/base/InteractComponent";
import Wave from "components/animation/Wave";

export default class WaveController extends InteractComponent {
	/**
	 * 可交互时是否播放
	 */
	playWhenInteractable = true;
	/**
	 * 不可交互时是否停止
	 */
	stopWhenUninteractable = true;
	/**
	 * 按下时是否停止
	 */
	stopWhenTouchBegin = true;
	/**
	 * 松开时是否停止
	 */
	playWhenTouchEnd = true;

	private _wave: Wave;

	touchBeginFlag = false;

	onAwake() {
		super.onAwake();

		this._wave = this.getComponent(Wave);
	}

	onTouchBegin(e) {
		super.onTouchBegin(e);

		this.touchBeginFlag = true;
		if(this.stopWhenTouchBegin){
			if(this._wave) this._wave.stop(true);
		}
	}

	onGlobalTouchEnd(e) {
		if(this.touchBeginFlag){
			this.touchBeginFlag = false;
			if(this.playWhenTouchEnd){
				if(this._wave) this._wave.play();
			}
		}
	}

	onInteractableChanged(interactable) {
		super.onInteractableChanged(interactable);

		if(interactable && this.playWhenInteractable){
			if(this._wave) this._wave.play();
		}
		if(!interactable && this.stopWhenUninteractable){
			if(this._wave) this._wave.stop();
		}
	}
}
