/**
 * Created by rockyl on 2019-05-16.
 *
 * 点等待
 */

import ScillaComponent from "components/base/ScillaComponent";
import {color} from "scilla";
import GraphicRenderer from "components/renderer/GraphicRenderer";

export default class DotWaiting extends ScillaComponent {
	activeColor: color;
	inativeColor: color;
	interval = 300;

	private _index;
	private _startTime;
	private _reset;
	private _dots: GraphicRenderer[] = [];

	onAwake() {
		super.onAwake();

		this._reset = true;

		this._dots.splice(0);
		for(let child of this.entity.children){
			this._dots.push(child.getComponent(GraphicRenderer));
		}
	}

	onUpdate(t) {
		super.onUpdate(t);

		if(this._reset){
			this._reset = false;
			this._startTime = t;
		}

		let index = Math.floor((t - this._startTime) / this.interval) % this._dots.length;
		if(this._index !== index){
			for (let i = 0, li = this._dots.length; i < li; i++) {
				const dot = this._dots[i];
				dot.fillColor = index === i ? this.activeColor : this.inativeColor;
			}
		}
	}
}
