import { createTween, ease, engine } from "scilla";
function bearingsToOutPos(bearings) {
    var _a = engine.renderContext.stageSize, width = _a.width, height = _a.height;
    var x, y;
    switch (bearings) {
        case 'south':
            x = 0;
            y = height / 2;
            break;
        case 'west':
            x = -width / 2;
            y = 0;
            break;
        case 'east':
            x = width / 2;
            y = 0;
            break;
        case 'north':
        default:
            x = 0;
            y = -height / 2;
    }
    return {
        x: x, y: y,
    };
}
export var none = {
    show: function (transform, options) {
        transform.position.setXY(0, 0);
        return Promise.resolve();
    },
    hide: function (transform, options) {
        transform.position.setXY(engine.renderContext.stageSize.width, 0);
        return Promise.resolve();
    }
};
export var fade = {
    show: function (transform, options) {
        options = options || {};
        transform.alpha = 0;
        var toProps = {
            alpha: 1,
        };
        return new Promise(function (resolve) {
            createTween(transform, transform)
                .to(toProps, options.duration || 300, options.easeFunc)
                .call(resolve);
        });
    },
    hide: function (transform, options) {
        options = options || {};
        var toProps = {
            alpha: 0,
        };
        return new Promise(function (resolve) {
            createTween(transform, transform)
                .to(toProps, options.duration || 200, options.easeFunc)
                .call(resolve);
        });
    }
};
export var flew = {
    show: function (transform, options) {
        options = options || {};
        var outPos = bearingsToOutPos(options.bearings);
        transform.position.copyFrom(outPos);
        var toProps = {
            position: { x: 0, y: 0, },
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            transform.alpha = 0;
            toProps.alpha = 1;
        }
        return new Promise(function (resolve) {
            createTween(transform, transform)
                .to(toProps, options.duration || 300, options.easeFunc || ease.backOut)
                .call(resolve);
        });
    },
    hide: function (transform, options) {
        options = options || {};
        var outPos = bearingsToOutPos(options.bearings);
        var toProps = {
            position: outPos,
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            toProps.alpha = 0;
        }
        return new Promise(function (resolve) {
            createTween(transform, transform)
                .to(toProps, options.duration || 200, options.easeFunc || ease.backIn)
                .call(resolve);
        });
    }
};
export var zoom = {
    show: function (transform, options) {
        options = options || {};
        transform.scale.setXY(0, 0);
        var toProps = {
            scale: { x: 1, y: 1, },
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            transform.alpha = 0;
            toProps.alpha = 1;
        }
        return new Promise(function (resolve) {
            createTween(transform, transform)
                .to(toProps, options.duration || 300, options.easeFunc || ease.backOut)
                .call(resolve);
        });
    },
    hide: function (transform, options) {
        options = options || {};
        var toProps = {
            scale: { x: 0, y: 0 },
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            toProps.alpha = 0;
        }
        return new Promise(function (resolve) {
            createTween(transform, transform)
                .to(toProps, options.duration || 200, options.easeFunc || ease.backIn)
                .call(resolve);
        });
    }
};
//# sourceMappingURL=module.js.map