import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { fade, flew, none, zoom } from "./PopupEffect";
import { decorators } from "scilla";
import CustomButton from "../game/CustomButton";
var dirtyFieldTrigger = decorators.dirtyFieldTrigger;
var DialogContent = (function (_super) {
    tslib_1.__extends(DialogContent, _super);
    function DialogContent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.effect = PopupEffect.none;
        _this.effectImpl = none;
        _this.show = function (data, callback) {
            _this.bubbling('showDialog', _this.entity.name, data, callback);
        };
        _this.hide = function (action) {
            _this.bubbling('hideDialog', _this.entity.name, action || 'close');
        };
        return _this;
    }
    DialogContent.prototype.onModify = function (value, key, oldValue) {
        _super.prototype.onModify.call(this, value, key, oldValue);
        if (key === 'effect') {
            this.effectImpl = effects[value];
        }
    };
    DialogContent.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        var buttons = this.entity.getChildrenByName('CloseButton');
        if (buttons.length > 0) {
            this._closeButton = buttons[0].getComponent(CustomButton);
            this._closeButton.onClick.addListener(this.onTapCloseButton, this);
        }
    };
    DialogContent.prototype.onTapCloseButton = function () {
        this.hide();
    };
    DialogContent.prototype.setup = function (data) {
    };
    tslib_1.__decorate([
        dirtyFieldTrigger
    ], DialogContent.prototype, "effect", void 0);
    return DialogContent;
}(ScillaComponent));
export default DialogContent;
var effects = {
    none: none,
    fade: fade,
    flew: flew,
    zoom: zoom,
};
export var PopupEffect;
(function (PopupEffect) {
    PopupEffect["none"] = "none";
    PopupEffect["fade"] = "fade";
    PopupEffect["flew"] = "flew";
    PopupEffect["zoom"] = "zoom";
})(PopupEffect || (PopupEffect = {}));
//# sourceMappingURL=module.js.map