export var NavigatorAction;
(function (NavigatorAction) {
    NavigatorAction[NavigatorAction["Push"] = 0] = "Push";
    NavigatorAction[NavigatorAction["Pop"] = 1] = "Pop";
    NavigatorAction[NavigatorAction["Replace"] = 2] = "Replace";
    NavigatorAction[NavigatorAction["Jump"] = 3] = "Jump";
})(NavigatorAction || (NavigatorAction = {}));
var StackNavigator = (function () {
    function StackNavigator(delegate) {
        this._stack = [];
        this._delegate = delegate;
    }
    StackNavigator.prototype.catchPromise = function (p) {
        var _this = this;
        if (p) {
            p.catch((function (e) {
                _this._delegate.onError(e);
            }));
        }
    };
    StackNavigator.prototype.push = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        var last = this.getTopSceneName();
        if (last) {
            if (last == name) {
                return;
            }
            this.catchPromise(this._delegate.onLeave(last, name, NavigatorAction.Push, parameters));
        }
        this._stack.push(name);
        this.catchPromise(this._delegate.onEnter(name, last, NavigatorAction.Push, parameters));
    };
    StackNavigator.prototype.popTo = function (index, name, parameters) {
        if (parameters === void 0) { parameters = null; }
        if (this._stack.length > 0 && this._stack.length < (index + 1)) {
            return;
        }
        var last = this.getTopSceneName();
        this._stack.splice(Math.max(index + 1, 0));
        var next = this._stack[index];
        if (!next) {
            this._stack.push(next = name);
        }
        if (last) {
            this.catchPromise(this._delegate.onLeave(last, next, NavigatorAction.Pop, parameters));
        }
        this.catchPromise(this._delegate.onEnter(next, last, NavigatorAction.Pop, parameters));
    };
    StackNavigator.prototype.pop = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this.popTo(this._stack.length - 2, null, parameters);
    };
    StackNavigator.prototype.popAll = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.popTo(-1, name, parameters);
    };
    StackNavigator.prototype.replace = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        var last = this._stack.pop();
        this._stack.push(name);
        this.catchPromise(this._delegate.onLeave(last, name, NavigatorAction.Replace, parameters));
        this.catchPromise(this._delegate.onEnter(name, last, NavigatorAction.Replace, parameters));
    };
    StackNavigator.prototype.jump = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        if (this._stack.length < 2) {
            this.push(name, parameters);
            return;
        }
        var last = this._stack.pop();
        this._stack.splice(1);
        var next = name;
        this._stack.push(next);
        this._delegate.onLeave(last, next, NavigatorAction.Pop, parameters);
        this._delegate.onEnter(next, last, NavigatorAction.Pop, parameters);
    };
    StackNavigator.prototype.getTopSceneName = function () {
        return this._stack.length > 0 ? this._stack[this._stack.length - 1] : null;
    };
    StackNavigator.prototype.getBottomSceneName = function () {
        return this._stack.length > 0 ? this._stack[0] : null;
    };
    return StackNavigator;
}());
export { StackNavigator };
//# sourceMappingURL=module.js.map