import * as tslib_1 from "tslib";
import { decorators } from "scilla";
import TextRenderer from "components/renderer/TextRenderer";
import CustomButton from "./CustomButton";
var dirtyFieldDetector = decorators.dirtyFieldDetector;
var TwoLinesButton = (function (_super) {
    tslib_1.__extends(TwoLinesButton, _super);
    function TwoLinesButton() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TwoLinesButton.prototype.onCreate = function () {
        this.label0TextRenderer = this.label0Entity.getComponent(TextRenderer);
        this.label1TextRenderer = this.label1Entity.getComponent(TextRenderer);
        _super.prototype.onCreate.call(this);
    };
    TwoLinesButton.prototype.onUpdate = function (t) {
        if (this['dirty']) {
            this.label0TextRenderer.text = this.label0;
            this.label1TextRenderer.text = this.label1;
        }
        _super.prototype.onUpdate.call(this, t);
    };
    TwoLinesButton.prototype.changeTexture = function (status) {
        _super.prototype.changeTexture.call(this, status);
        if (this.label0TextRenderer) {
            this.label0TextRenderer.fillColor = this.interactable ? this.upLabelColor : this.disabledLabelColor;
            this.label1TextRenderer.fillColor = this.interactable ? this.upLabelColor : this.disabledLabelColor;
        }
    };
    tslib_1.__decorate([
        dirtyFieldDetector
    ], TwoLinesButton.prototype, "label0", void 0);
    tslib_1.__decorate([
        dirtyFieldDetector
    ], TwoLinesButton.prototype, "label1", void 0);
    return TwoLinesButton;
}(CustomButton));
export default TwoLinesButton;
//# sourceMappingURL=module.js.map