import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { instantiate, math, Size } from "scilla";
import Item from "./Item";
import Transform from "components/base/Transform";
var ItemLayer = (function (_super) {
    tslib_1.__extends(ItemLayer, _super);
    function ItemLayer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.itemCount = 13;
        _this.itemPosPadding = 50;
        _this.itemPosRange = new Size(750, 500);
        _this.itemCellPadding = 20;
        _this.itemPosOffsetY = 50;
        _this.playCreditsCount = 4;
        _this._items = [];
        _this._excludeItemQueue = [];
        _this.playACredits = function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
            var _a, _excludeItemQueue, _items, targetItem, index, cost;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(this._freePlayCreditsCount > 0)) return [3, 2];
                        _a = this, _excludeItemQueue = _a._excludeItemQueue, _items = _a._items;
                        targetItem = void 0, index = void 0;
                        while (true) {
                            index = Math.floor(Math.random() * _items.length);
                            if (_excludeItemQueue.indexOf(index) < 0) {
                                targetItem = _items[index];
                                if (!targetItem.playing) {
                                    break;
                                }
                            }
                        }
                        this._freePlayCreditsCount--;
                        _excludeItemQueue.push(index);
                        if (_excludeItemQueue.length > this._playCreditsCount * 2) {
                            _excludeItemQueue.shift();
                        }
                        cost = math.makeRandomInt(this.activityBaseInfo.miningExpend * 2, 1);
                        return [4, targetItem.playCredits(cost)];
                    case 1:
                        _b.sent();
                        this._freePlayCreditsCount++;
                        _b.label = 2;
                    case 2: return [2];
                }
            });
        }); };
        _this.digDelegate = function (x, y) {
            var e_1, _a;
            var items = [];
            var hitWidth = _this.holeRes.width + _this.itemRes.width - 40;
            try {
                for (var _b = tslib_1.__values(_this._items), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    if (!item.exclude && item.hit(x, y, hitWidth, 5)) {
                        items.push(item);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return items;
        };
        return _this;
    }
    ItemLayer.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._playCreditsCount = Math.floor(this.itemCount / 3);
        this._itemGap = {
            x: (this.itemPosRange.width - this.itemPosPadding * 2) / 3,
            y: (this.itemPosRange.height - this.itemCellPadding * 2) / 3,
        };
        this._itemPosOffset = {
            x: -this.itemPosRange.width / 2,
            y: this.itemPosOffsetY,
        };
        for (var i = 0; i < this.itemCount; i++) {
            var itemEntity = instantiate(this.itemPrefab);
            this.entity.addChild(itemEntity);
            itemEntity.enabled = false;
            this._items.push(itemEntity.getComponent(Item));
        }
    };
    ItemLayer.prototype.prepareItems = function () {
        this._freePlayCreditsCount = this.playCreditsCount;
        this._excludeItemQueue.splice(0);
        var _a = this, _itemGap = _a._itemGap, _itemPosOffset = _a._itemPosOffset, itemPosPadding = _a.itemPosPadding, itemCellPadding = _a.itemCellPadding, itemPosRange = _a.itemPosRange;
        var i, j;
        for (i = 0; i < 4; i++) {
            this.addItem(i, {
                x: i * _itemGap.x + _itemPosOffset.x + itemPosPadding,
                y: _itemPosOffset.y + Math.random() * itemPosRange.height + itemPosPadding,
            });
        }
        for (j = 0; j < this.itemCount - 4; j++) {
            var gx = j % 3;
            var gy = Math.floor(j / 3);
            this.addItem(i + j, {
                x: gx * _itemGap.x + _itemPosOffset.x + itemPosPadding + Math.random() * (_itemGap.x - itemCellPadding * 2) + itemCellPadding,
                y: gy * _itemGap.y + _itemPosOffset.y + itemPosPadding + Math.random() * (_itemGap.y - itemCellPadding * 2) + itemCellPadding,
            });
        }
        this.entity.children.sort(function (a, b) {
            return a.getComponent(Transform).position.y - b.getComponent(Transform).position.y;
        });
        this.stopCreditsAnimation();
        this.playCreditsAnimation();
    };
    ItemLayer.prototype.addItem = function (i, pos) {
        var item = this._items[i];
        item.reset(pos);
    };
    ItemLayer.prototype.playCreditsAnimation = function () {
        this._timerCreditsAnimation = setInterval(this.playACredits, 200);
    };
    ItemLayer.prototype.stopCreditsAnimation = function () {
        var e_2, _a;
        if (this._timerCreditsAnimation) {
            clearInterval(this._timerCreditsAnimation);
            this._timerCreditsAnimation = null;
        }
        try {
            for (var _b = tslib_1.__values(this._items), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                item.stopCredits();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return ItemLayer;
}(ScillaComponent));
export default ItemLayer;
//# sourceMappingURL=module.js.map