import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import FloatMissing from "../common/FloatMissing";
import TextRenderer from "components/renderer/TextRenderer";
var Item = (function (_super) {
    tslib_1.__extends(Item, _super);
    function Item() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exclude = false;
        _this._playing = false;
        return _this;
    }
    Item.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._floatMissing = this.creditsEntity.getComponent(FloatMissing);
        this._label = this.Label.getComponent(TextRenderer);
    };
    Item.prototype.reset = function (pos) {
        this.transform.position.copyFrom(pos);
        this.entity.enabled = true;
        this.exclude = false;
        this._playing = false;
    };
    Item.prototype.playCredits = function (cost) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this._label.text = cost.toString();
                        this.creditsEntity.enabled = true;
                        this._floatMissing.delay = Math.random() * 500;
                        this._playing = true;
                        return [4, this._floatMissing.play()];
                    case 1:
                        _a.sent();
                        this._playing = false;
                        return [2];
                }
            });
        });
    };
    Item.prototype.stopCredits = function () {
        this.creditsEntity.enabled = false;
    };
    Object.defineProperty(Item.prototype, "playing", {
        get: function () {
            return this._playing;
        },
        enumerable: true,
        configurable: true
    });
    Item.prototype.hit = function (x, y, hitWidth, hitHeight) {
        var _a = this.transform.position, px = _a.x, py = _a.y;
        return x > px - hitWidth / 2 && x < px + hitWidth / 2 && py && y > py - hitHeight / 2 && y < py + hitHeight / 2;
    };
    return Item;
}(ScillaComponent));
export default Item;
//# sourceMappingURL=module.js.map