import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import Transform from "components/base/Transform";
var Hole = (function (_super) {
    tslib_1.__extends(Hole, _super);
    function Hole() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.heightOffset = 50;
        _this.bottomOffset = 50;
        return _this;
    }
    Hole.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this.bgMask = this.Bg.getComponent(Transform);
        this.bottomTransform = this.Bottom.getComponent(Transform);
    };
    Hole.prototype.show = function () {
        this.entity.enabled = true;
        this.setDeep(0);
    };
    Hole.prototype.hide = function () {
        this.entity.enabled = false;
    };
    Hole.prototype.setDeep = function (v) {
        this.bgMask.height = v + this.heightOffset;
        this.bottomTransform.position.y = v + this.bottomOffset;
    };
    return Hole;
}(ScillaComponent));
export default Hole;
//# sourceMappingURL=module.js.map