import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import TwoLinesButton from "../game/TwoLinesButton";
import Wave from "components/animation/Wave";
import WaveController from "../common/WaveController";
import { renderRunCredits } from "./utils";
import CustomButton from "./CustomButton";
function getWaveAlgorithm() {
    return function bounce(t) {
        var s = 1 + Math.abs(Math.sin(t)) * 0.1;
        return {
            sx: s,
            sy: s,
        };
    };
}
var BottomButtonController = (function (_super) {
    tslib_1.__extends(BottomButtonController, _super);
    function BottomButtonController() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._buttons = [];
        _this._counting = 0;
        return _this;
    }
    BottomButtonController.prototype.onCreate = function () {
        var _this = this;
        _super.prototype.onCreate.call(this);
        this._buttonSLDig = this.buttonDigSLEntity.getComponent(CustomButton);
        this._buttonPK = this.buttonPKEntity.getComponent(TwoLinesButton);
        var wavePK = this.buttonPKEntity.getComponent(Wave);
        var wcPK = this.buttonPKEntity.getComponent(WaveController);
        wavePK.waveAlgorithm = getWaveAlgorithm();
        this._buttonDig = this.buttonDigEntity.getComponent(TwoLinesButton);
        var waveDig = this.buttonDigEntity.getComponent(Wave);
        var wcDig = this.buttonDigEntity.getComponent(WaveController);
        waveDig.waveAlgorithm = getWaveAlgorithm();
        this.switchState(false);
        this._buttons.push({
            button: this._buttonPK,
            wave: wavePK,
            wc: wcPK,
        }, {
            button: this._buttonDig,
            wave: waveDig,
            wc: wcDig,
        });
        setInterval(function () {
            var _a = _this._buttons[(_this._counting++) % _this._buttons.length], button = _a.button, wave = _a.wave, wc = _a.wc;
            if (button.interactable && !wc.touchBeginFlag) {
                wave.play();
            }
        }, 600);
        this.updateButtonLabel();
        this.disableAll();
    };
    BottomButtonController.prototype.initGameStage = function () {
        var _a = this.activityBaseInfo, pkExpend = _a.pkExpend, miningExpend = _a.miningExpend;
        this.updateButtonLabel(pkExpend, miningExpend);
        this.switchState(false);
    };
    BottomButtonController.prototype.updateButtonLabel = function (pkExpend, miningExpend) {
        if (pkExpend === void 0) { pkExpend = 0; }
        if (miningExpend === void 0) { miningExpend = 0; }
        this._buttonPK.label1 = renderRunCredits(pkExpend) + '/次';
        this._buttonDig.label1 = renderRunCredits(miningExpend) + '/次';
    };
    BottomButtonController.prototype.enableAll = function () {
        var e_1, _a;
        try {
            for (var _b = tslib_1.__values(this._buttons), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = _c.value, button = _d.button, wc = _d.wc;
                button.interactable = true;
                wc.touchBeginFlag = false;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    BottomButtonController.prototype.disableAll = function () {
        var e_2, _a;
        try {
            for (var _b = tslib_1.__values(this._buttons), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = _c.value, button = _d.button, wc = _d.wc;
                button.interactable = false;
                wc.touchBeginFlag = false;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    BottomButtonController.prototype.enablePkDigButton = function () {
        this._buttonSLDig.interactable = true;
    };
    BottomButtonController.prototype.disablePkDigButton = function () {
        this._buttonSLDig.interactable = false;
    };
    BottomButtonController.prototype.switchState = function (isPK) {
        this.buttonPKEntity.enabled = !isPK;
        this.buttonDigEntity.enabled = !isPK;
        this.buttonDigSLEntity.enabled = isPK;
        if (isPK) {
            this.enablePkDigButton();
        }
    };
    return BottomButtonController;
}(ScillaComponent));
export default BottomButtonController;
//# sourceMappingURL=module.js.map