import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import GameStage from "./GameStage";
var ApiProcess = (function (_super) {
    tslib_1.__extends(ApiProcess, _super);
    function ApiProcess() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ApiProcess.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._gameStage = this.entity.getComponent(GameStage);
    };
    ApiProcess.prototype.onSingleDigSuccess = function (response) {
        console.log(response);
        this._gameStage.readyDig(1, 0);
        this.getOrderStatus(response);
    };
    ApiProcess.prototype.onPkDigSuccess = function (response, channel) {
        console.log(response);
        this._gameStage.readyDig(2, channel);
        this.getOrderStatus(response);
    };
    ApiProcess.prototype.getOrderStatus = function (response) {
        var actOrderNum = response.actOrderNum, operationType = response.operationType;
        this.broadcast('callApi', 1, 'getOrderStatus', { actOrderNum: actOrderNum, operationType: operationType, });
    };
    ApiProcess.prototype.onDigError = function (e) {
        console.log(e);
        if (typeof e === 'string') {
            switch (e) {
                case '0100000':
                    this.bubbling('showLoginAlert');
                    this._gameStage.resetBottomButton();
                    break;
                case '0201150':
                    this.bubbling('showCreditsAlert');
                    this._gameStage.resetBottomButton();
                    break;
                case '0100016':
                case '0100014':
                case '0100017':
                    this.bubbling('showErrorToast', e);
                    break;
                default:
                    this.bubbling('showNetError');
            }
        }
        else {
            this.bubbling('showNetError');
        }
    };
    ApiProcess.prototype.onOrderStatusResponse = function (response) {
        console.log('onOrderStatusResponse', response);
        this._gameStage.changeOrderStatus(response);
    };
    ApiProcess.prototype.onOrderStatusError = function (e) {
        console.log('onOrderStatusError', e);
        this._gameStage.changeOrderStatus(1);
    };
    return ApiProcess;
}(ScillaComponent));
export default ApiProcess;
//# sourceMappingURL=module.js.map