import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease } from "scilla";
import PKResultAnimSide from "../../game/PKResultAnimSide";
import Transform from "components/base/Transform";
var AnimLayer = (function (_super) {
    tslib_1.__extends(AnimLayer, _super);
    function AnimLayer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimLayer.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._leftSide = this.LeftSide.getComponent(PKResultAnimSide);
        this._rightSide = this.RightSide.getComponent(PKResultAnimSide);
        this._lineTransform = this.Line.getComponent(Transform);
    };
    AnimLayer.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    AnimLayer.prototype.play = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        createTween(this, this._lineTransform)
                            .set({ scale: { x: 0, y: 0 }, alpha: 0 }, true)
                            .wait(200)
                            .to({ scale: { x: 1, y: 1 }, alpha: 1 }, 500, ease.backOut);
                        return [4, Promise.all([this._leftSide.play({
                                    nickname: this.userNickname,
                                    receiveCredits: this.pkData.userReceiveCredits,
                                    finalCredits: this.pkData.userFinalCredits,
                                    multipleCard: this.pkData.userMultipleCard,
                                }),
                                this._rightSide.play({
                                    nickname: this.pkData.machineNickname,
                                    receiveCredits: this.pkData.machineReceiveCredits,
                                    finalCredits: this.pkData.machineFinalCredits,
                                    multipleCard: this.pkData.machineMultipleCard,
                                }),])];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    return AnimLayer;
}(ScillaComponent));
export default AnimLayer;
//# sourceMappingURL=module.js.map