import * as tslib_1 from "tslib";
import { createTween, utils } from "scilla";
import DialogContent from "../popup/DialogContent";
import RunNumber from "../common/RunNumber";
import Transform from "components/base/Transform";
import FlySequence from "../common/FlySequence";
import globalEvent from "globalEvent";
import TimesCard from "../game/TimesCard";
import { renderRunCredits } from "../game/utils";
var SingleResult = (function (_super) {
    tslib_1.__extends(SingleResult, _super);
    function SingleResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SingleResult.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._timesCard = this.TimesCard.getComponent(TimesCard);
        this._colorTapeTransform = this.ColorTape.getComponent(Transform);
        this._wrapperTransform = this.Wrapper.getComponent(Transform);
        this._lightTransform = this.Light.getComponent(Transform);
        this._flySequence = this.Coins.getComponent(FlySequence);
        this._runCredits = this.Credits.getComponent(RunNumber);
        this._runCredits.$renderFunc = renderRunCredits;
    };
    SingleResult.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    SingleResult.prototype.setup = function (data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.setup.call(this, data);
                        this.Wrapper.enabled = true;
                        this.Light.enabled = false;
                        createTween(this, this._wrapperTransform)
                            .set({ scale: { x: 0.8, y: 0.8 }, alpha: 1 })
                            .to({ scale: { x: 1.0, y: 1.0 } }, 2000);
                        createTween(this, this._colorTapeTransform)
                            .set({ scale: { x: 0, y: 0 }, alpha: 1 })
                            .wait(100)
                            .to({ scale: { x: 0.8, y: 0.8 } }, 800)
                            .to({ scale: { x: 1.1, y: 1.1 }, alpha: 0 }, 1200);
                        return [4, this.playCredits()];
                    case 1:
                        _a.sent();
                        this.playLight();
                        return [2];
                }
            });
        });
    };
    SingleResult.prototype.playCredits = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _a, receiveCredits, finalCredits, multipleCard, showTimesCard;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.singleDigData, receiveCredits = _a.receiveCredits, finalCredits = _a.finalCredits, multipleCard = _a.multipleCard;
                        showTimesCard = multipleCard > 0;
                        this.TimesCard.enabled = false;
                        return [4, this._runCredits.play(receiveCredits, 0)];
                    case 1:
                        _b.sent();
                        return [4, utils.waitPromise(500)];
                    case 2:
                        _b.sent();
                        if (!showTimesCard) return [3, 5];
                        this.TimesCard.enabled = true;
                        return [4, this._timesCard.playShow(multipleCard)];
                    case 3:
                        _b.sent();
                        createTween(this, this._wrapperTransform)
                            .to({ scale: { x: 1.2, y: 1.2 } }, 2000);
                        return [4, this._runCredits.play(finalCredits, receiveCredits)];
                    case 4:
                        _b.sent();
                        _b.label = 5;
                    case 5: return [2];
                }
            });
        });
    };
    SingleResult.prototype.playLight = function () {
        var _this = this;
        createTween(this, this._wrapperTransform)
            .to({ alpha: 0 }, 500)
            .call(function () {
            _this.Wrapper.enabled = false;
        });
        this.Light.enabled = true;
        this._lightTransform.alpha = 0;
        createTween(this, this._lightTransform)
            .set({ scale: { x: 0, y: 0 } })
            .to({ alpha: 1, scale: { x: 1, y: 1 } }, 300)
            .call(function () {
            _this.playCoins();
        })
            .to({ alpha: 0, scale: { x: 0, y: 0 } }, 300)
            .call(function () {
            _this.Light.enabled = false;
        });
    };
    SingleResult.prototype.playCoins = function () {
        this.bubbling('setBgVisible', false);
        this._flySequence.play();
        globalEvent.emit('runCredits');
    };
    SingleResult.prototype.onFlyCoinEnd = function () {
        this.hide('complete');
    };
    return SingleResult;
}(DialogContent));
export default SingleResult;
//# sourceMappingURL=module.js.map