import * as tslib_1 from "tslib";
import DialogContent from "../popup/DialogContent";
import TextRenderer from "components/renderer/TextRenderer";
import { stringFixed } from "../game/utils";
var PKMatching = (function (_super) {
    tslib_1.__extends(PKMatching, _super);
    function PKMatching() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onMatched = function () {
            _this._titleRenderer.text = '匹配成功';
            _this.AvatarOther.enabled = true;
            _this.AvatarWaiting.enabled = false;
            setTimeout(_this.hide, 1000, 'success');
        };
        return _this;
    }
    PKMatching.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._titleRenderer = this.Title.getComponent(TextRenderer);
        this._selfNameRenderer = this.SelfName.getComponent(TextRenderer);
        this._otherNameRenderer = this.OtherName.getComponent(TextRenderer);
    };
    PKMatching.prototype.setup = function (data) {
        var channel = data.channel;
        this._titleRenderer.text = '正在匹配对手…';
        this._selfNameRenderer.text = stringFixed(this.userNickname);
        this._otherNameRenderer.text = stringFixed(this.otherName);
        this.AvatarOther.enabled = false;
        this.AvatarWaiting.enabled = true;
        this.CloseButton.enabled = false;
        this.stop();
        if (channel === 1) {
            this.onMatched();
        }
        else {
            this._timer = setTimeout(this.onMatched, Math.random() * 2000 + 2000);
        }
    };
    PKMatching.prototype.stop = function () {
        if (this._timer) {
            clearTimeout(this._timer);
            this._timer = null;
        }
    };
    PKMatching.prototype.onTapCloseButton = function () {
        _super.prototype.onTapCloseButton.call(this);
        this.stop();
    };
    return PKMatching;
}(DialogContent));
export default PKMatching;
//# sourceMappingURL=module.js.map