import * as tslib_1 from "tslib";
import InteractComponent from "components/base/InteractComponent";
import Wave from "components/animation/Wave";
var WaveController = (function (_super) {
    tslib_1.__extends(WaveController, _super);
    function WaveController() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.playWhenInteractable = true;
        _this.stopWhenUninteractable = true;
        _this.stopWhenTouchBegin = true;
        _this.playWhenTouchEnd = true;
        _this.touchBeginFlag = false;
        return _this;
    }
    WaveController.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._wave = this.getComponent(Wave);
    };
    WaveController.prototype.onTouchBegin = function (e) {
        _super.prototype.onTouchBegin.call(this, e);
        this.touchBeginFlag = true;
        if (this.stopWhenTouchBegin) {
            if (this._wave)
                this._wave.stop(true);
        }
    };
    WaveController.prototype.onGlobalTouchEnd = function (e) {
        if (this.touchBeginFlag) {
            this.touchBeginFlag = false;
            if (this.playWhenTouchEnd) {
                if (this._wave)
                    this._wave.play();
            }
        }
    };
    WaveController.prototype.onInteractableChanged = function (interactable) {
        _super.prototype.onInteractableChanged.call(this, interactable);
        if (interactable && this.playWhenInteractable) {
            if (this._wave)
                this._wave.play();
        }
        if (!interactable && this.stopWhenUninteractable) {
            if (this._wave)
                this._wave.stop();
        }
    };
    return WaveController;
}(InteractComponent));
export default WaveController;
//# sourceMappingURL=module.js.map