import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import TextRenderer from "components/renderer/TextRenderer";
import { createTween, ScillaEvent } from "scilla";
function renderSimple(v) {
    return Math.floor(v).toString();
}
var RunNumber = (function (_super) {
    tslib_1.__extends(RunNumber, _super);
    function RunNumber() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.duration = 3000;
        _this.onComplete = new ScillaEvent();
        _this.$renderFunc = renderSimple;
        return _this;
    }
    RunNumber.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._textRenderer = this.getComponent(TextRenderer);
    };
    RunNumber.prototype.play = function (to, from) {
        var _this = this;
        if (!this._textRenderer) {
            return Promise.resolve();
        }
        from = from === undefined ? parseFloat(this._textRenderer.text) : from;
        return new Promise(function (resolve) {
            createTween(_this, _this, true)
                .set({ t: from })
                .to({ t: to }, _this.duration)
                .call(function () {
                resolve();
                _this.onComplete.invoke();
            });
        });
    };
    Object.defineProperty(RunNumber.prototype, "t", {
        get: function () {
            return this._t;
        },
        set: function (v) {
            this._t = v;
            this._textRenderer.text = this.$renderFunc(v);
        },
        enumerable: true,
        configurable: true
    });
    return RunNumber;
}(ScillaComponent));
export default RunNumber;
//# sourceMappingURL=module.js.map