import * as tslib_1 from "tslib";
import ScillaComponent from "components/base/ScillaComponent";
import { createTween, ease, instantiate, ScillaEvent, Vector2D } from "scilla";
import Transform from "components/base/Transform";
var FlySequence = (function (_super) {
    tslib_1.__extends(FlySequence, _super);
    function FlySequence() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.count = 10;
        _this.fromPos = new Vector2D();
        _this.toPos = new Vector2D();
        _this.toScale = new Vector2D(0.3, 0.3);
        _this.duration = 3000;
        _this.delay = 500;
        _this.itemInterval = 100;
        _this.hideWhenComplete = true;
        _this.offset = 1;
        _this.onComplete = new ScillaEvent();
        _this._items = [];
        _this.onDelay = function () {
            _this._timer = setInterval(function () {
                if (_this._counting > _this.count - 1) {
                    _this.stop(false);
                    _this._flyItem(_this._items[0], _this.onEnd);
                    return;
                }
                _this._playItem(_this._counting);
                _this._counting++;
            }, _this.itemInterval);
        };
        _this.onEnd = function () {
            _this.onComplete.invoke();
        };
        return _this;
    }
    FlySequence.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._itemDuration = this.duration - this.count * this.itemInterval - this.delay;
        for (var i = 0; i < this.count; i++) {
            var itemEntity = instantiate(this.itemPrefab);
            itemEntity.enabled = false;
            this.entity.addChild(itemEntity);
            var transform = itemEntity.getComponent(Transform);
            this._items.push(transform);
        }
    };
    FlySequence.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    FlySequence.prototype.play = function () {
        this.stop();
        if (this.ToEntity) {
            this.toPos = this.transform.globalPositionToLocal(this.ToEntity.getComponent(Transform).globalPosition);
        }
        var first = this._items[0];
        first.entity.enabled = true;
        first.position.copyFrom(this.fromPos);
        first.scale.setXY(1, 1);
        this._counting = 1;
        this._timerDelay = setTimeout(this.onDelay, this.delay);
    };
    FlySequence.prototype.stop = function (hidden) {
        var e_1, _a;
        if (hidden === void 0) { hidden = true; }
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
        }
        if (this._timerDelay) {
            clearTimeout(this._timerDelay);
            this._timerDelay = null;
        }
        if (hidden) {
            try {
                for (var _b = tslib_1.__values(this._items), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    item.entity.enabled = false;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    };
    FlySequence.prototype._playItem = function (index) {
        var item = this._items[index];
        item.entity.enabled = true;
        item.position.copyFrom(this.fromPos);
        item.scale.setXY(0, 0);
        this._flyItem(item);
    };
    FlySequence.prototype._flyItem = function (item, callback) {
        var _this = this;
        var itemDuration = this._itemDuration;
        createTween(this, item.scale, false)
            .to({ x: 1, y: 1 }, itemDuration * 0.1)
            .wait(itemDuration * 0.4)
            .to(this.toScale.toObj(), itemDuration * 0.5);
        createTween(this, item.position)
            .to({ x: this.toPos.x }, itemDuration);
        var easeFuncCreator = Math.random() > 0.5 ? ease.getPowOut : ease.getPowIn;
        var easeFunc = easeFuncCreator(Math.random() + this.offset);
        createTween(this, item.position)
            .to({ y: this.toPos.y }, itemDuration, easeFunc)
            .call(function () {
            if (_this.hideWhenComplete) {
                item.entity.enabled = false;
            }
            callback && callback();
        });
    };
    return FlySequence;
}(ScillaComponent));
export default FlySequence;
//# sourceMappingURL=module.js.map