import * as tslib_1 from "tslib";
import InteractComponent from "components/base/InteractComponent";
import { callApi } from "../net/webService";
import { engine } from "scilla";
var BuriedPoint = (function (_super) {
    tslib_1.__extends(BuriedPoint, _super);
    function BuriedPoint() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BuriedPoint.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        if (this.dpm && this.dcm && !this._exposured) {
            this.setConfig(this.dpm, this.dcm, true);
        }
    };
    BuriedPoint.prototype.onTouchTap = function (e) {
        _super.prototype.onTouchTap.call(this, e);
        if (this._buriedPointName) {
            logClick(this._buriedPointName);
        }
    };
    BuriedPoint.prototype.setConfig = function (dpm, dcm, needLogExposure) {
        if (needLogExposure === void 0) { needLogExposure = false; }
        this._buriedPointName = 'buried-point-' + Date.now() + Math.floor(Math.random() * 999999);
        addBuriedPointConfig(this._buriedPointName, { dpm: dpm, dcm: dcm });
        if (needLogExposure) {
            logExposure(this._buriedPointName);
            this._exposured = true;
        }
    };
    return BuriedPoint;
}(InteractComponent));
export default BuriedPoint;
var _buriedPoints = {};
var env;
export function initEnv() {
    var cfg = engine.dataCenter.get('CFG');
    env = {
        app_id: cfg.appId,
        oaid: cfg.opActivityId,
        page_id: 3,
        comp_id: 4,
    };
}
export function addBuriedPoints(buriedPoints) {
    for (var name in buriedPoints) {
        _buriedPoints[name] = buriedPoints[name];
    }
}
export function addBuriedPointConfig(name, config) {
    var dpm = config.dpm, dcm = config.dcm;
    _buriedPoints[name] = new BuriedPointData(dpm, dcm);
}
export function addBuriedPointConfigs(configs) {
    for (var name in configs) {
        addBuriedPointConfig(name, configs[name]);
    }
}
export function logExposure(name) {
    return log(name, 'exposure');
}
export function logClick(name) {
    return log(name, 'click');
}
function log(name, type) {
    if (DEBUG) {
    }
    var logPoint = _buriedPoints[name];
    var appId = engine.dataCenter.get('CFG', 'appId');
    var dpm = logPoint.dpm, dcm = logPoint.dcm;
    return callApi(type == 'exposure' ? '//embedlog.duiba.com.cn/exposure/standard' : '/log/click', {
        dpm: dpm, dcm: dcm, appId: appId
    }, 'get', type == 'exposure' ? 'jsonp' : 'json').catch(function (e) {
    });
}
function fillData(src) {
    var result = src;
    for (var key in env) {
        result = result.replace(key, env[key]);
    }
    return result;
}
var BuriedPointData = (function () {
    function BuriedPointData(dpm, dcm) {
        this.dpm = fillData(dpm);
        this.dcm = fillData(dcm);
    }
    return BuriedPointData;
}());
//# sourceMappingURL=module.js.map