import * as tslib_1 from "tslib";
import { utils, } from 'scilla';
import ApiComponent from "./ApiComponent";
import { polling } from "../net/webService";
var SamplePollingApi = (function (_super) {
    tslib_1.__extends(SamplePollingApi, _super);
    function SamplePollingApi() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.maxTimes = 5;
        _this.delay = 500;
        _this._abortFlag = false;
        _this.abortFunc = function () {
            return _this._abortFlag;
        };
        _this.successFunc = function (response) {
            var _a = _this, successField = _a.successField, successValues = _a.successValues;
            var v = successField ? response.data[successField] : response.data;
            return successValues ? successValues.indexOf(v) >= 0 : false;
        };
        return _this;
    }
    SamplePollingApi.prototype.callApi = function (name, paramsInput) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(this.name == name)) return [3, 2];
                        return [4, this.execute.apply(this, tslib_1.__spread([paramsInput], args))];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2];
                }
            });
        });
    };
    SamplePollingApi.prototype.abortCallApi = function (name) {
        if (this.name == name) {
            this._abort();
        }
    };
    SamplePollingApi.prototype.execute = function (paramsInput) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var params, _a, uri, method, response, e_1;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, _super.prototype.execute.apply(this, tslib_1.__spread([paramsInput], args))];
                    case 1:
                        _b.sent();
                        this._abortFlag = false;
                        params = {};
                        if (this.params) {
                            utils.injectProp(params, this.params);
                        }
                        if (paramsInput) {
                            utils.injectProp(params, paramsInput);
                        }
                        _a = this, uri = _a.uri, method = _a.method;
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 4, , 5]);
                        return [4, polling(this.successFunc, uri, params, this.maxTimes, this.delay, this.abortFunc, method)];
                    case 3:
                        response = _b.sent();
                        this.onGotResponse(response);
                        return [2, response.data];
                    case 4:
                        e_1 = _b.sent();
                        this.onGotError(e_1);
                        return [3, 5];
                    case 5: return [2];
                }
            });
        });
    };
    SamplePollingApi.prototype._abort = function () {
        this._abortFlag = true;
    };
    return SamplePollingApi;
}(ApiComponent));
export default SamplePollingApi;
//# sourceMappingURL=module.js.map