/**
 * Created by rockyl on 2018-12-12.
 *
 * 对话框内容组件
 */

import ScillaComponent from "components/base/ScillaComponent";
import {fade, flew, none, zoom} from "./PopupEffect";
import {raw} from "scilla";
import {decorators} from "scilla";
import CustomButton from "../game/CustomButton";

const {dirtyFieldTrigger} = decorators;

export default class DialogContent extends ScillaComponent {
	@dirtyFieldTrigger
	effect: PopupEffect = PopupEffect.none;
	showEffectOptions: raw;
	hideEffectOptions: raw;

	protected _closeButton: CustomButton;

	effectImpl = none;

	protected onModify(value, key, oldValue) {
		super.onModify(value, key, oldValue);

		if (key === 'effect') {
			this.effectImpl = effects[value];
		}
	}

	onCreate() {
		super.onCreate();

		const buttons = this.entity.getChildrenByName('CloseButton');
		if (buttons.length > 0) {
			this._closeButton = buttons[0].getComponent(CustomButton);
			this._closeButton.onClick.addListener(this.onTapCloseButton, this);
		}
	}

	protected onTapCloseButton() {
		this.hide();
	}

	setup(data) {

	}

	show = (data?, callback?) => {
		this.bubbling('showDialog', this.entity.name, data, callback);
	}

	hide = (action?) => {
		this.bubbling('hideDialog', this.entity.name, action || 'close');
	}
}

const effects = {
	none,
	fade,
	flew,
	zoom,
};

export enum PopupEffect {
	none = 'none',
	fade = 'fade',
	flew = 'flew',
	zoom = 'zoom',
}
