/**
 * Created by rockyl on 2019-05-06.
 *
 * 双行文本按钮
 */

import {Entity} from "scilla";
import {decorators} from "scilla";
import TextRenderer from "components/renderer/TextRenderer";
import CustomButton from "./CustomButton";

const {dirtyFieldDetector} = decorators;

export default class TwoLinesButton extends CustomButton {
	@dirtyFieldDetector
	label0: string;
	@dirtyFieldDetector
	label1: string;

	label0Entity: Entity;
	label1Entity: Entity;

	protected label0TextRenderer: TextRenderer;
	protected label1TextRenderer: TextRenderer;

	onCreate() {
		this.label0TextRenderer = this.label0Entity.getComponent(TextRenderer);
		this.label1TextRenderer = this.label1Entity.getComponent(TextRenderer);

		super.onCreate();
	}

	onUpdate(t) {
		if(this['dirty']){
			this.label0TextRenderer.text = this.label0;
			this.label1TextRenderer.text = this.label1;
		}

		super.onUpdate(t);
	}

	changeTexture(status) {
		super.changeTexture(status);

		if(this.label0TextRenderer){
			this.label0TextRenderer.fillColor = this.interactable ? this.upLabelColor : this.disabledLabelColor;
			this.label1TextRenderer.fillColor = this.interactable ? this.upLabelColor : this.disabledLabelColor;
		}
	}
}
