/**
 * Created by rockyl on 2019-05-10.
 *
 * 公告栏
 */

import ScillaComponent from "components/base/ScillaComponent";
import LabelCarousel from '../common/LabelCarousel'
import {dynamic} from "scilla";
import RectRenderer from "components/renderer/RectRenderer";

export default class NoticeBar extends ScillaComponent {
	opActivityId: dynamic;

	private _labelCarousel: LabelCarousel;
	private _pool:string[] = [];
	private _bgRenderer: RectRenderer;

	onCreate() {
		super.onCreate();

		this._bgRenderer = this.getComponent(RectRenderer);
		this._bgRenderer.enabled = false;

		this._labelCarousel = this.getComponent(LabelCarousel);
		this._labelCarousel.getTextFunc = this.getTextFunc;
	}

	initGameStage(){
		this.broadcast('callApi', 1, 'noticeContent', {opActivityId: this.opActivityId})
	}

	onGotNoticeContent(response){
		this._pool = this._pool.concat(response);
		if(!this._labelCarousel._playing){
			this._labelCarousel.play();
		}
	}

	getTextFunc=()=>{
		if(this._pool.length < 5){
			this.initGameStage();
		}

		if(this._pool.length > 0){
			if(this._pool.length > 0){
				this._bgRenderer.enabled = true;
			}
			return this._pool.shift();
		}
	}
}
