/**
 * Created by rockyl on 2019-05-09.
 *
 * 积分栏
 */

import ScillaComponent from "components/base/ScillaComponent";
import TextRenderer from "components/renderer/TextRenderer";
import {dynamic, Entity,} from "scilla";
import RunNumber from "../common/RunNumber";
import globalEvent from "globalEvent";
import RectRenderer from "components/renderer/RectRenderer";

export default class CreditsBar extends ScillaComponent {
	CreditsUnitName: Entity;
	LabelCreditsCurrent: Entity;
	Line: Entity;
	Label: Entity;
	LabelCreditsTotal: Entity;
	showCredits: dynamic;
	activityBaseInfo: dynamic;
	unitName: dynamic;
	runDuration = 2000;

	private _bgRenderer: RectRenderer;
	private _creditsUnitName: TextRenderer;
	private _labelCreditsCurrent: TextRenderer;
	private _labelCreditsTotal: TextRenderer;

	private _runCreditsTotal: RunNumber;
	private _runCreditsCurrent: RunNumber;

	onCreate() {
		super.onCreate();

		globalEvent.on('runCredits', this.runCredits, this);

		this._bgRenderer = this.getComponent(RectRenderer);

		this._creditsUnitName = this.CreditsUnitName.getComponent(TextRenderer);
		this._labelCreditsCurrent = this.LabelCreditsCurrent.getComponent(TextRenderer);
		this._labelCreditsTotal = this.LabelCreditsTotal.getComponent(TextRenderer);

		this._runCreditsCurrent = this.LabelCreditsCurrent.getComponent(RunNumber);
		this._runCreditsTotal = this.LabelCreditsTotal.getComponent(RunNumber);

		this._creditsUnitName.text = this.unitName;

		if(this.showCredits !== 1){
			this.LabelCreditsCurrent.enabled = false;
			this.Line.enabled = false;
			this.Label.enabled = false;
		}
		this._bgRenderer.width = this.showCredits === 1 ? 480 : 320;
	}

	initGameStage(){
		const {curCredits, heapCredits} = this.activityBaseInfo;

		if(this.showCredits === 1){
			this._labelCreditsCurrent.text = curCredits.toString();
		}
		this._labelCreditsTotal.text = heapCredits.toString();
	}

	runCredits(duration?){
		const {curCredits, heapCredits} = this.activityBaseInfo;


		if(this.showCredits === 1){
			this._runCreditsCurrent.duration = duration || this.runDuration;
			this._runCreditsCurrent.play(curCredits);
		}

		this._runCreditsTotal.duration = duration || this.runDuration;
		this._runCreditsTotal.play(heapCredits);
	}
}
