/**
 * Created by rockyl on 2019-05-20.
 *
 * 结果层
 */

import ScillaComponent from "components/base/ScillaComponent";
import {createTween, dynamic, ease, Entity} from "scilla";
import PKResultSide from "../../game/PKResultSide";
import Transform from "components/base/Transform";
import RelativeLayout from "components/other/RelativeLayout";

export default class ResultLayer extends ScillaComponent {
	LeftSide: Entity;
	RightSide: Entity;
	Line: Entity;
	BottomBar: Entity;

	userNickname: dynamic;
	pkData: dynamic;

	private _leftSide: PKResultSide;
	private _rightSide: PKResultSide;
	private _lineTransform: Transform;
	private _bottomBarLayout: RelativeLayout;
	private _bottomBarHeight;

	onCreate() {
		super.onCreate();

		this._leftSide = this.LeftSide.getComponent(PKResultSide);
		this._rightSide = this.RightSide.getComponent(PKResultSide);
		this._lineTransform = this.Line.getComponent(Transform);

		this._bottomBarLayout = this.BottomBar.getComponent(RelativeLayout);
		this._bottomBarHeight = this.BottomBar.getComponent(Transform).height;

		this.hide();
	}

	onUpdate(t) {
		super.onUpdate(t);
	}

	async play(data) {
		const {userFinalCredits, machineFinalCredits, machineNickname, resultState} = this.pkData;

		createTween(this, this._lineTransform)
			.set({scale: {x: 0, y: 0}, alpha: 0}, true)
			.wait(200)
			.to({scale: {x: 1, y: 1}, alpha: 1}, 500, ease.backOut);

		await Promise.all([this._leftSide.play({
			nickname: this.userNickname,
			finalCredits: userFinalCredits,
			otherFinalCredits: machineFinalCredits,
			resultState
		}),
		this._rightSide.play({
			nickname: machineNickname,
			finalCredits: machineFinalCredits,
			otherFinalCredits: userFinalCredits,
			resultState
		}),]).then(
			()=>{
				createTween(this, this._bottomBarLayout)
					.to({bottom: 0}, 500, ease.cubicOut);
			}
		);
	}

	hide(){
		this._bottomBarLayout.bottom = -this._bottomBarHeight;
	}
}
