/**
 * Created by rockyl on 2019-05-10.
 *
 * api处理过程
 */

import ScillaComponent from "components/base/ScillaComponent";
import GameStage from "./GameStage";

export default class ApiProcess extends ScillaComponent {
	private _gameStage: GameStage;

	onAwake() {
		super.onAwake();

		this._gameStage = this.entity.getComponent(GameStage);
	}

	onSingleDigSuccess(response) {
		console.log(response);

		this._gameStage.readyDig(1, 0);
		this.getOrderStatus(response)
	}

	onPkDigSuccess(response, channel) {
		console.log(response);

		this._gameStage.readyDig(2, channel);
		this.getOrderStatus(response)
	}

	private getOrderStatus(response){
		const {actOrderNum, operationType,} = response;

		this.broadcast('callApi', 1, 'getOrderStatus', {actOrderNum, operationType,})
	}

	onDigError(e) {
		console.log(e);

		if(typeof e === 'string'){
			switch(e){
				case '0100000':
					this.bubbling('showLoginAlert');
					this._gameStage.resetBottomButton();
					break;
				case '0201150':
					this.bubbling('showCreditsAlert');
					this._gameStage.resetBottomButton();
					break;
				case '0100016': //活动未开始
				case '0100014': //活动已结束
				case '0100017': //活动已关闭
					this.bubbling('showErrorToast', e);
					break;
				default:
					this.bubbling('showNetError');//, this._gameStage.restoreDig.bind(this._gameStage, e));
			}
		}else{
			this.bubbling('showNetError');
		}
	}

	onOrderStatusResponse(response) {
		console.log('onOrderStatusResponse', response);

		this._gameStage.changeOrderStatus(response);
	}

	onOrderStatusError(e) {
		console.log('onOrderStatusError', e);

		this._gameStage.changeOrderStatus(1);
	}
}
