/**
 * Created by rockyl on 2019-04-10.
 *
 * 警告对话框内容
 */

import DialogContent from "../popup/DialogContent";
import {Entity} from "scilla";
import TextRenderer from "components/renderer/TextRenderer";
import Transform from "components/base/Transform";

export default class AlertDialogContent extends DialogContent {
	Title: Entity;
	Content: Entity;
	ConfirmButton: Entity;

	private _confirmButtonLabel: TextRenderer;
	private _titleLabel: TextRenderer;
	private _contentLabel: TextRenderer;
	private _contentTransform: Transform;

	onAwake() {
		super.onAwake();

		this._titleLabel = this.Title.getComponent(TextRenderer);
		this._contentLabel = this.Content.getComponent(TextRenderer);
		this._contentTransform = this.Content.getComponent(Transform);

		if (this.ConfirmButton) {
			this._confirmButtonLabel = this.ConfirmButton.getChildrenByName('Label')[0].getComponent(TextRenderer);
		}
	}

	setup(data: any = {}) {
		const {title = 'Alert', content = '', button = 'Confirm', showCloseButton = true} = data;

		this._titleLabel.text = title;
		this._contentLabel.text = content;

		this._closeButton.entity.enabled = showCloseButton;

		if (button) {
			this._confirmButtonLabel.text = button;
		}

		this._contentTransform.position.y = button ? -30 : 40;
		this.ConfirmButton.enabled = !!button;
	}

	onClickConfirmButton() {
		this.hide('confirm')
	}
}
