/**
 * Created by rockyl on 2019-05-20.
 *
 * 动画层
 */

import ScillaComponent from "components/base/ScillaComponent";
import {createTween, dynamic, ease, Entity} from "scilla";
import PKResultAnimSide from "../../game/PKResultAnimSide";
import Transform from "components/base/Transform";

export default class AnimLayer extends ScillaComponent {
	LeftSide: Entity;
	RightSide: Entity;
	Line: Entity;

	userNickname: dynamic;
	pkData: dynamic;

	private _leftSide: PKResultAnimSide;
	private _rightSide: PKResultAnimSide;
	private _lineTransform: Transform;

	onAwake() {
		super.onAwake();

		this._leftSide = this.LeftSide.getComponent(PKResultAnimSide);
		this._rightSide = this.RightSide.getComponent(PKResultAnimSide);
		this._lineTransform = this.Line.getComponent(Transform);
	}

	onUpdate(t) {
		super.onUpdate(t);
	}

	async play(data) {
		createTween(this, this._lineTransform)
			.set({scale: {x: 0, y: 0}, alpha: 0}, true)
			.wait(200)
			.to({scale: {x: 1, y: 1}, alpha: 1}, 500, ease.backOut);

		await Promise.all([this._leftSide.play({
			nickname: this.userNickname,
			receiveCredits: this.pkData.userReceiveCredits,
			finalCredits: this.pkData.userFinalCredits,
			multipleCard: this.pkData.userMultipleCard,
		}),
			this._rightSide.play({
				nickname: this.pkData.machineNickname,
				receiveCredits: this.pkData.machineReceiveCredits,
				finalCredits: this.pkData.machineFinalCredits,
				multipleCard: this.pkData.machineMultipleCard,
			}),]);
	}
}
