/**
 * Created by rockyl on 2019-05-20.
 *
 * PK结果动画弹窗
 */

import {Entity, utils,} from "scilla";
import DialogContent from "../popup/DialogContent";
import AnimLayer from "./pkresult/AnimLayer";
import ResultLayer from "./pkresult/ResultLayer";
import globalEvent from "globalEvent";

export default class PKResult extends DialogContent {
	AnimLayer: Entity;
	ResultLayer: Entity;

	private _animLayer: AnimLayer;
	private _resultLayer: ResultLayer;

	onAwake() {
		super.onAwake();

		this._animLayer = this.AnimLayer.getComponent(AnimLayer);
		this._resultLayer = this.ResultLayer.getComponent(ResultLayer);
	}

	onUpdate(t) {
		super.onUpdate(t);
	}

	async setup(data) {
		super.setup(data);

		this.AnimLayer.enabled = true;
		this.ResultLayer.enabled = false;
		await this._animLayer.play(data);
		await utils.waitPromise(500);
		this.ResultLayer.enabled = true;
		await this._resultLayer.play(data);

		globalEvent.emit('runCredits');
	}

	onBottomButtonTap(action){
		this._resultLayer.hide();
		this.hide(action);
	}
}
