/**
 * Created by rockyl on 2019-05-14.
 *
 * 翻倍卡
 */

import ScillaComponent from "components/base/ScillaComponent";
import {createTween, ease, Entity} from "scilla";
import TextRenderer from "components/renderer/TextRenderer";

export default class TimesCard extends ScillaComponent {
	Label: Entity;

	private _labelRenderer: TextRenderer;

	onAwake() {
		super.onAwake();

		this._labelRenderer = this.Label.getComponent(TextRenderer);
	}

	setTimes(v){
		this._labelRenderer.text = 'X' + v;
	}

	playShow(v){
		if(v !== undefined){
			this.setTimes(v);
		}

		this.entity.enabled = true;
		return new Promise(resolve => {
			createTween(this, this.transform, true)
				.set({scale: {x: 2, y: 2}, alpha: 0}, true)
				.to({scale: {x: 1, y: 1}, alpha: 1}, 500, ease.backOut)
				.wait(500)
				.to({alpha: 0}, 500)
				.call(resolve);
		})
	}
}
