/**
 * Created by rockyl on 2019-05-09.
 *
 * 主控制器
 */

import ScillaComponent from "components/base/ScillaComponent";
import {dynamic, engine, Entity} from "scilla";
import Toast from "./common/Toast";
import Popup from "./popup/Popup";
import {initEnv} from "./common/BuriedPoint";
import {isWeiXin} from "./game/utils";

export default class MainController extends ScillaComponent {
	Popup: Entity;
	Toast: Entity;
	opActivityId: dynamic;

	private _toast: Toast;
	private _popup: Popup;

	onAwake() {
		super.onAwake();

		engine.dataCenter.set('CFG', window['CFG']);

		this._toast = this.Toast.getComponent(Toast);
		this._popup = this.Popup.getComponent(Popup);

		initEnv();

		this.broadcast('callApi', 1, 'activityBaseInfo', {opActivityId: this.opActivityId})
	}

	onGotActivityBaseInfo() {
		this.broadcast('initGameStage');
	}

	onActivityBaseInfoError(e) {
		console.log(e);

		if (typeof e === 'string') {
			switch (e) {
				case '0100016': //活动未开始
				case '0100014': //活动已结束
				case '0100017': //活动已关闭
					this.showErrorToast(e);
					break;
				default:
					this.showNetError();
			}
		} else {
			this.showNetError();
		}
	}

	showErrorToast(e) {
		switch (e) {
			case '0100016': //活动未开始
				this.showToast('活动未开始，暂时无法参与');
				break;
			case '0100014': //活动已结束
			case '0100017': //活动已关闭
				this.showToast('活动已结束，无法参与');
				break;
		}
	}

	showToast(content, duration?) {
		this._toast.show({
			content,
			duration,
		})
	}

	showDialog(name, data?, callback?) {
		this._popup.showDialog(name, data, callback);
	}

	hideDialog(name, action?: string, data?) {
		this._popup.hideDialog(name, action, data);
	}

	hideAllDialog() {
		this._popup.hideAll();
	}

	alert(data?, callback?) {
		this.showDialog('Alert', data, callback);
	}

	showLoginAlert() {
		const callUpRegistH5Code = engine.dataCenter.get('CFG', 'callUpRegistH5Code');
		const callUpLoginFunc = window['requirelogin'];
		this.alert({
			title: `啊哦，你还未登录`,
			content: `登录后即可参与活动`,
			button: (callUpLoginFunc || callUpRegistH5Code) ? '立即登录' : null,
		}, (action) => {
			if (action === 'confirm') {
				if(isWeiXin()){
					if(callUpRegistH5Code){
						location.href = callUpRegistH5Code;
					}else{
						console.log('没有登录方案');
					}
				}else{
					if(callUpLoginFunc){
						callUpLoginFunc();
					}else{
						console.log('没有登录方案');
					}
				}
			}
		});
	}

	showCreditsAlert() {
		const unitName = engine.dataCenter.get('CFG', 'unitName');
		const earnCreditsUrl = engine.dataCenter.get('CFG', 'earnCreditsUrl');

		this.alert({
			title: `啊哦，当前${unitName}不足`,
			content: `快去领取更多${unitName}吧`,
			button: earnCreditsUrl ? '去做任务' : null,
		}, (action) => {
			if (action === 'confirm') {
				location.href = earnCreditsUrl;
			}
		});
	}

	showNetError(action?) {
		this.showDialog('Alert', {title: '网络异常', content: '请检查网络后重试!', button: '重新加载', showCloseButton: false}, () => {
			if (typeof action === 'function') {
				action();
			} else {
				action = action || 'refresh';
				switch (action) {
					case 'back':
						history.back();
						break;
					case 'refresh':
						location.reload();
						break;
				}
			}
		})
	}
}
