/**
 * Created by rockyl on 2018/11/5.
 *
 * 游戏入口
 */

import {modifyEngineConfig} from 'scilla'
import ScillaLauncher from 'launcher'
import './generated/MustCompile'

let launcher: ScillaLauncher;

modifyEngineConfig({
	lineHeightRatio: 1.0,
	entityEnabled: false,
	awakeComponentWhenAdded: false,
	sleepComponentWhenRemoved: false,
	drawRenderRect: false,
});

export async function startup(containerElement, options: any = {}, onProgress: Function) {
	launcher = new ScillaLauncher();

	const config = window['configJson'] = JSON.parse(window['CFG'].configJson);
	options.resReplaceConfigs = {
		'scenes/main.scene': {
			'singles/bg.jpg': config['background'],
			'singles/btn-start-dig-disabled.png': config['dig_button_disabled'],
			'singles/btn-start-dig.png': config['dig_button_normal'],
			'singles/btn-start-pk-disabled.png': config['pk_button_disabled'],
			'singles/btn-start-pk.png': config['pk_button_normal'],
			'singles/button-red.png': config['dialog_button'],
			'singles/dialog-bg.png': config['dialog_background'],
		}
	};

	await launcher.launch(containerElement, options, onProgress);
}
