/**
 * Created by rockyl on 2019-04-09.
 */

import {INavigatorViewBase} from "../navigator/VirtualNavigator";
import {alien} from "../navigator/StackNavigator";
import {Entity, engine} from "scilla";
import {playAnimation} from "../animation-utils";
import Puzzle from "../game/Puzzle";
import ScillaComponent from "components/base/ScillaComponent";

const animationConfig = {
	enter: {
		/*BackButton: {
			'components/other/RelativeLayout': {params: {top: 10,}, duration: 500, ease: 'cubicOut'},
		},
		ResetButton: {
			'components/other/RelativeLayout': {params: {bottom: 100,}, duration: 500, ease: 'cubicOut'},
		},
		Puzzle: {
			'components/base/Transform': {params: {alpha: 1,}, duration: 500, ease: 'cubicOut'},
		},*/
	},
	leave: {
		/*BackButton: {
			'components/other/RelativeLayout': {params: {top: -60,}, duration: 500, ease: 'cubicOut'},
		},
		ResetButton: {
			'components/other/RelativeLayout': {params: {bottom: -90,}, duration: 500, ease: 'cubicOut'},
		},
		Puzzle: {
			'components/base/Transform': {params: {alpha: 0,}, duration: 500, ease: 'cubicOut'},
		},*/
	},
};

export default class ScenePlay extends ScillaComponent implements INavigatorViewBase {
	BackButton: Entity;
	ResetButton: Entity;
	Puzzle: Entity;

	_puzzle: Puzzle;
	_level: number = 3;
	_img: any;

	onAwake() {
		super.onAwake();

		//this._puzzle = this.Puzzle.getComponent(Puzzle);
	}

	onDidEnter(last: string, action: alien.NavigatorAction, parameters: any): void {
		//this.reset();
	}

	onDidLeave(next: string, action: alien.NavigatorAction, parameters: any): void {
	}

	async onWillEnter(last: string, action: alien.NavigatorAction, parameters: any) {
		await playAnimation(animationConfig.enter, this);
	}

	async onWillLeave(next: string, action: alien.NavigatorAction, parameters: any) {
		await playAnimation(animationConfig.leave, this);
	}

	onWillMount(last: string, action: alien.NavigatorAction, parameters: any): Promise<any> {
		return undefined;
	}

	onWillUnMount(next: string, action: alien.NavigatorAction, parameters: any): Promise<any> {
		return undefined;
	}

	async reset() {
		let id = 1;
		let url = `singles/${id}.jpg`;
		this._img = await engine.assetsManager.loadImage(url);

		this.startLevel();
	}

	nextLevel() {
		this._level++;
		this.startLevel();
	}

	startLevel() {
		this._puzzle.start(this._img, this._level);
	}
}
