/**
 * Created by rockyl on 2019-05-10.
 *
 * 洞
 */

import ScillaComponent from "components/base/ScillaComponent";
import {Entity} from "scilla";
import Transform from "components/base/Transform";

export default class Hole extends ScillaComponent {
	Bg: Entity;
	Bottom: Entity;
	heightOffset = 50;
	bottomOffset = 50;

	private bgMask: Transform;
	private bottomTransform: Transform;

	onAwake() {
		super.onAwake();

		this.bgMask = this.Bg.getComponent(Transform);
		this.bottomTransform = this.Bottom.getComponent(Transform);
	}

	show(){
		this.entity.enabled = true;
		this.setDeep(0);
	}

	hide(){
		this.entity.enabled = false;
	}

	setDeep(v){
		this.bgMask.height = v + this.heightOffset;
		this.bottomTransform.position.y = v + this.bottomOffset;
	}
}
