/**
 * Created by rockyl on 2019-05-15.
 */
import Transform from "components/base/Transform";
import {createTween, ease, engine} from "scilla";

function bearingsToOutPos(bearings) {
	const {width, height} = engine.renderContext.stageSize;

	let x, y;
	switch (bearings) {
		case 'south':
			x = 0;
			y = height / 2;
			break;
		case 'west':
			x = -width / 2;
			y = 0;
			break;
		case 'east':
			x = width / 2;
			y = 0;
			break;
		case 'north':
		default:
			x = 0;
			y = -height / 2;
	}

	return {
		x, y,
	}
}

export const none = {
	show(transform: Transform, options?) {
		transform.position.setXY(0, 0);
		return Promise.resolve();
	},
	hide(transform: Transform, options?) {
		transform.position.setXY(engine.renderContext.stageSize.width, 0);
		return Promise.resolve();
	}
};

export const fade = {
	show(transform: Transform, options?: { bearings?: string, duration?: number, easeFunc?: Function }) {
		options = options || {};

		transform.alpha = 0;

		const toProps: any = {
			alpha: 1,
		};

		return new Promise(resolve => {
			createTween(transform, transform)
				.to(toProps, options.duration || 300, options.easeFunc)
				.call(resolve);
		})
	},
	hide(transform: Transform, options?: { bearings?: string, duration?: number, easeFunc?: Function }) {
		options = options || {};

		const toProps: any = {
			alpha: 0,
		};

		return new Promise(resolve => {
			createTween(transform, transform)
				.to(toProps, options.duration || 200, options.easeFunc)
				.call(resolve);
		});
	}
};

export const flew = {
	show(transform: Transform, options?: { bearings?: string, withFade?: boolean, duration?: number, easeFunc?: Function }) {
		options = options || {};

		let outPos = bearingsToOutPos(options.bearings);

		transform.position.copyFrom(outPos);

		const toProps: any = {
			position: {x: 0, y: 0,},
		};

		const withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
		if (withFade) {
			transform.alpha = 0;
			toProps.alpha = 1;
		}

		return new Promise(resolve => {
			createTween(transform, transform)
				.to(toProps, options.duration || 300, options.easeFunc || ease.backOut)
				.call(resolve);
		})
	},
	hide(transform: Transform, options?: { bearings?: string, withFade?: boolean, duration?: number, easeFunc?: Function }) {
		options = options || {};

		let outPos = bearingsToOutPos(options.bearings);

		const toProps: any = {
			position: outPos,
		};

		const withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
		if (withFade) {
			toProps.alpha = 0;
		}

		return new Promise(resolve => {
			createTween(transform, transform)
				.to(toProps, options.duration || 200, options.easeFunc || ease.backIn)
				.call(resolve);
		});
	}
};

export const zoom = {
	show(transform: Transform, options?: { bearings?: string, withFade?: boolean, duration?: number, easeFunc?: Function }) {
		options = options || {};

		transform.scale.setXY(0, 0);

		const toProps: any = {
			scale: {x: 1, y: 1,},
		};

		const withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
		if (withFade) {
			transform.alpha = 0;
			toProps.alpha = 1;
		}

		return new Promise(resolve => {
			createTween(transform, transform)
				.to(toProps, options.duration || 300, options.easeFunc || ease.backOut)
				.call(resolve);
		})
	},
	hide(transform: Transform, options?: { bearings?: string, withFade?: boolean, duration?: number, easeFunc?: Function }) {
		options = options || {};

		const toProps: any = {
			scale: {x: 0, y: 0},
		};

		const withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
		if (withFade) {
			toProps.alpha = 0;
		}

		return new Promise(resolve => {
			createTween(transform, transform)
				.to(toProps, options.duration || 200, options.easeFunc || ease.backIn)
				.call(resolve);
		});
	}
};
