/**
 * Created by rockyl on 2019-04-09.
 *
 * 单场景导航器
 */

import {VirtualNavigator} from "./VirtualNavigator";
import {SceneStart, ScenePlay} from "../scenes";
import ScillaComponent from "components/base/ScillaComponent";

export default class SingleSceneNavigator extends ScillaComponent {
	_navigator: VirtualNavigator;

	onCreate() {
		super.onCreate();

		this._navigator = new VirtualNavigator(this.entity);
		this._navigator.register('start', 'SceneStart', SceneStart);
		this._navigator.register('play', 'ScenePlay', ScenePlay);
	}

	onAwake() {
		super.onAwake();

		this.push('start');
	}

	onUpdate(t) {
		super.onUpdate(t);
	}

	onSleep() {
		super.onSleep();
	}

	onDestroy() {
		super.onDestroy();
	}

	push(name: string, parameters: any = null) {
		this._navigator.stack.push(name, parameters);
	}

	pop(parameters: any = null) {
		this._navigator.stack.pop(parameters);
	}

	popToBottom(parameters: any = null) {
		this._navigator.stack.popTo(0, null, parameters);
	}

	popAll(name: string, parameters: any = null) {
		this._navigator.stack.popAll(name, parameters);
	}

	replace(name: string, parameters: any = null) {
		this._navigator.stack.replace(name, parameters);
	}

	jump(name: string, parameters: any = null) {
		this._navigator.stack.jump(name, parameters);
	}
}
