/**
 * Created by rockyl on 2019-05-14.
 *
 * pk结果动画一侧
 */

import ScillaComponent from "components/base/ScillaComponent";
import {createTween, ease, engine, Entity, Tween} from "scilla";
import Transform from "components/base/Transform";
import TextRenderer from "components/renderer/TextRenderer";
import TimesCard from "./TimesCard";
import RunNumber from "../common/RunNumber";
import {renderRunCredits, stringFixed} from "./utils";

export default class PKResultAnimSide extends ScillaComponent {
	LabelName: Entity;
	LabelCredits: Entity;
	TimesCard: Entity;
	side: number;

	private _labelName: TextRenderer;
	private _labelCredits: TextRenderer;
	private _labelCreditsTransform: Transform;
	private _labelRunCredits: RunNumber;
	private _timesCard: TimesCard;

	private _pos;

	onAwake() {
		super.onAwake();

		if (!this._labelName) {
			this._labelName = this.LabelName.getComponent(TextRenderer);
			this._labelCredits = this.LabelCredits.getComponent(TextRenderer);
			this._labelCreditsTransform = this.LabelCredits.getComponent(Transform);
			this._labelRunCredits = this.LabelCredits.getComponent(RunNumber);
			this._timesCard = this.TimesCard.getComponent(TimesCard);

			this._labelRunCredits.$renderFunc = renderRunCredits;

			this._pos = this.transform.position.x;
		}
	}

	async play(data) {
		const {nickname, receiveCredits, finalCredits, multipleCard} = data;
		const showTimesCard = multipleCard > 0;

		this._labelName.text = stringFixed(nickname);
		this._labelCredits.text = '';

		this.TimesCard.enabled = false;

		this._labelCreditsTransform.scale.setXY(0.6, 0.6);
		const toScale1 = {
			x: 1, y: 1,
		};
		const toScale2 = {
			x: 1.4, y: 1.4,
		};

		const stageWidth = engine.renderContext.stageSize.width;
		await createTween(this, this.transform.position)
			.set({x: stageWidth * this.side}, true)
			.to({x: this._pos}, 500, ease.backOut)
			.getPromise();

		createTween(this, this._labelCreditsTransform)
			.to({scale: showTimesCard ? toScale1 : toScale2}, 1000);
		await this._labelRunCredits.play(receiveCredits, 0);
		if (showTimesCard) {
			await this._timesCard.playShow(multipleCard);
			createTween(this, this._labelCreditsTransform)
				.to({scale: toScale2}, 1000);
			await this._labelRunCredits.play(finalCredits, receiveCredits);
		}
	}
}
