'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var scilla = require('scilla');

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

function __values(o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

var ScillaComponent = (function (_super) {
    __extends(ScillaComponent, _super);
    function ScillaComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ScillaComponent.prototype, "transform", {
        get: function () {
            return this.entity.getComponentByName('components/base/Transform');
        },
        enumerable: true,
        configurable: true
    });
    return ScillaComponent;
}(scilla.Component));

var entry_20 = /*#__PURE__*/Object.freeze({
    'default': ScillaComponent
});

var Translation = (function (_super) {
    __extends(Translation, _super);
    function Translation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.duration = 1000;
        _this.autoPlay = false;
        _this.easeName = scilla.Ease.linear;
        _this.delay = 0;
        _this.loop = -1;
        _this.onLoopComplete = new scilla.ScillaEvent();
        _this.onComplete = new scilla.ScillaEvent();
        _this._onLoopComplete = function () {
            _this.onLoopComplete.invoke();
        };
        _this._onComplete = function () {
            _this.onComplete.invoke();
        };
        return _this;
    }
    Translation.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (this.autoPlay) {
            this.play();
        }
    };
    Translation.prototype.play = function () {
        var easeFunc = scilla.ease[this.easeName];
        this._tween = scilla.createTween(this, this.transform, false, { autoPlay: true, loop: this.loop, onLoopComplete: this._onLoopComplete, onComplete: this._onComplete })
            .set(this.getFromProp(), true)
            .wait(this.delay)
            .to(this.getToProp(), this.duration, easeFunc);
    };
    Translation.prototype.stop = function () {
        this._tween.stop();
    };
    Translation.prototype.getFromProp = function () {
        return {};
    };
    Translation.prototype.getToProp = function () {
        return {};
    };
    return Translation;
}(ScillaComponent));

var entry_1 = /*#__PURE__*/Object.freeze({
    'default': Translation
});

var Zoom = (function (_super) {
    __extends(Zoom, _super);
    function Zoom() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.fromScale = new scilla.Vector2D(0, 0);
        _this.toScale = new scilla.Vector2D(1, 1);
        return _this;
    }
    Zoom.prototype.getFromProp = function () {
        return {
            scale: this.fromScale ? this.fromScale.toObj() : null
        };
    };
    Zoom.prototype.getToProp = function () {
        return {
            scale: this.toScale ? this.toScale.toObj() : null
        };
    };
    return Zoom;
}(Translation));

var entry_0 = /*#__PURE__*/Object.freeze({
    'default': Zoom
});

var dirtyFieldDetector = scilla.decorators.dirtyFieldDetector;
var floatLayerName = 'floatLayer';
function getFloatLayer() {
    var floatLayer = scilla.engine.canvasElement.nextElementSibling;
    if (!floatLayer || floatLayer.id !== floatLayerName) {
        floatLayer = document.createElement('div');
        floatLayer.id = floatLayerName;
        floatLayer.style.position = 'absolute';
        floatLayer.style.overflowY = 'auto';
        scilla.engine.canvasElement.parentElement.append(floatLayer);
    }
    return floatLayer;
}
function showFloatLayer() {
    var floatLayer = getFloatLayer();
    floatLayer.style.display = 'inherit';
}
function hideFloatLayer() {
    var floatLayer = getFloatLayer();
    floatLayer.style.display = 'none';
}
var HtmlRenderer = (function (_super) {
    __extends(HtmlRenderer, _super);
    function HtmlRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.fontSize = 14;
        _this.color = '#000';
        return _this;
    }
    HtmlRenderer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        showFloatLayer();
    };
    HtmlRenderer.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
        hideFloatLayer();
    };
    HtmlRenderer.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        var floatLayer = getFloatLayer();
        var style = floatLayer.style;
        if (this['dirty']) {
            this['dirty'] = false;
            floatLayer.innerHTML = this.htmlText;
            style.fontSize = this.fontSize + 'px';
            style.color = this.color;
        }
        if (this.htmlText) {
            var _a = this.transform, _b = _a.globalPosition, x = _b.x, y = _b.y, width = _a.width, height = _a.height;
            var _c = scilla.engine.canvasPosToPagePos(x, y), px = _c.x, py = _c.y;
            var _d = scilla.engine.canvasPosToPagePos(width, height), pWidth = _d.x, pHeight = _d.y;
            if (style.left !== (px - pWidth / 2) + 'px') {
                style.left = (px - pWidth / 2) + 'px';
            }
            if (style.top !== (py - pHeight / 2) + 'px') {
                style.top = (py - pHeight / 2) + 'px';
            }
            if (style.width !== pWidth + 'px') {
                style.width = pWidth + 'px';
            }
            if (style.height !== pHeight + 'px') {
                style.height = pHeight + 'px';
            }
        }
    };
    __decorate([
        dirtyFieldDetector
    ], HtmlRenderer.prototype, "htmlText", void 0);
    __decorate([
        dirtyFieldDetector
    ], HtmlRenderer.prototype, "fontSize", void 0);
    __decorate([
        dirtyFieldDetector
    ], HtmlRenderer.prototype, "color", void 0);
    return HtmlRenderer;
}(ScillaComponent));

var entry_2 = /*#__PURE__*/Object.freeze({
    'default': HtmlRenderer
});

var dirtyFieldTrigger = scilla.decorators.dirtyFieldTrigger;
var Renderer = (function (_super) {
    __extends(Renderer, _super);
    function Renderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onVector2DModify = function () {
            _this.makeDirty();
        };
        _this.dirty = true;
        _this._useCacheMode = false;
        _this.alpha = 1;
        _this.anchor = new scilla.Vector2D(0.5, 0.5);
        _this.bounds = new scilla.Bounds();
        _this.cacheCanvas = null;
        _this._anchorOffset = new scilla.Vector2D();
        _this._margin = 0;
        return _this;
    }
    Object.defineProperty(Renderer.prototype, "useCacheMode", {
        get: function () {
            return this.getUseCacheMode();
        },
        set: function (value) {
            this._useCacheMode = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Renderer.prototype, "context", {
        get: function () {
            if (!this._context) {
                this._context = scilla.engine.renderContext.context;
            }
            return this._context;
        },
        enumerable: true,
        configurable: true
    });
    Renderer.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._debugDrawColor = "hsl(" + scilla.math.makeRandomInt(360) + ", " + scilla.math.makeRandomInt(100) + "%, 60%)";
    };
    Renderer.prototype.getUseCacheMode = function () {
        return this._useCacheMode;
    };
    Object.defineProperty(Renderer.prototype, "currentCanvasContext", {
        get: function () {
            return this.cacheCanvasContext || this.context;
        },
        enumerable: true,
        configurable: true
    });
    Renderer.prototype.makeDirty = function () {
        this.dirty = true;
    };
    Renderer.prototype.onModify = function (value, key, oldValue) {
        _super.prototype.onModify.call(this, value, key, oldValue);
        this.makeDirty();
        switch (key) {
            case 'anchor':
                value.onChange = this.onVector2DModify;
                break;
        }
    };
    Renderer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this.transform) {
            console.warn('renderer need a transform component');
        }
    };
    Renderer.prototype.onUpdate = function (t) {
        if (this.dirty) {
            if (this.useCacheMode) {
                this.readyCacheCanvas();
            }
            this.measureBounds();
            if (this.useCacheMode) {
                this.updateCacheCanvas();
            }
        }
        this.transformToLocal();
        this.render();
        if (scilla.EngineConfig.drawRenderRect) {
            var _a = this, context = _a.context, _debugDrawColor = _a._debugDrawColor, _b = _a.bounds, width = _b.width, height = _b.height, _c = _a._anchorOffset, x = _c.x, y = _c.y, _d = _a.transform.pivot, px = _d.x, py = _d.y;
            context.globalAlpha = 0.9;
            context.strokeStyle = _debugDrawColor;
            context.fillStyle = _debugDrawColor;
            context.beginPath();
            context.rect(0, 0, width, height);
            context.stroke();
            context.beginPath();
            context.arc(width * px, height * py, 3, 0, 2 * Math.PI);
            context.fill();
        }
    };
    Renderer.prototype.onEditorUpdate = function (t) {
        this.onUpdate(t);
    };
    Renderer.prototype.readyCacheCanvas = function () {
        var canvas = this.cacheCanvas;
        if (!canvas) {
            canvas = this.cacheCanvas = scilla.createCanvas();
            this.cacheCanvasContext = canvas.getContext('2d');
        }
    };
    Renderer.prototype.updateCacheCanvas = function () {
        var canvas = this.cacheCanvas;
        var _a = this.bounds, width = _a.width, height = _a.height;
        canvas.width = width + this._margin * 2;
        canvas.height = height + this._margin * 2;
    };
    Renderer.prototype.render = function () {
        this.beforeDraw();
        this.drawClip();
        if (this.dirty) {
            if (this.useCacheMode) {
                this.draw();
            }
            this.dirty = false;
        }
        if (this.useCacheMode) {
            this.drawCache();
        }
        else {
            this.draw();
        }
    };
    Renderer.prototype.beforeDraw = function () {
        this.applyAlpha();
    };
    Renderer.prototype.transformToLocal = function () {
        var _a = this, transform = _a.transform, _b = _a._anchorOffset, ax = _b.x, ay = _b.y;
        if (transform && transform.enabled) {
            var _c = transform.getMatrix(true, false, true), a = _c.a, b = _c.b, c = _c.c, d = _c.d, tx = _c.tx, ty = _c.ty;
            var offX = ax * a + ay * c;
            var offY = ax * b + ay * d;
            this.context.setTransform(a, b, c, d, tx - offX, ty - offY);
        }
        else {
            this.context.setTransform(1, 0, 0, 1, -ax, -ay);
        }
    };
    Renderer.prototype.applyAlpha = function () {
        this.context.globalAlpha = this.alpha * this.transform.renderAlpha;
    };
    Renderer.prototype.drawCache = function () {
        if (this.cacheCanvas.width > 0 && this.cacheCanvas.height > 0) {
            this.context.drawImage(this.cacheCanvas, -this._margin, -this._margin);
        }
    };
    Renderer.prototype.drawClip = function () {
    };
    Renderer.prototype.draw = function () {
    };
    Renderer.prototype.measureBounds = function () {
        var _a = this, _b = _a.anchor, x = _b.x, y = _b.y, bounds = _a.bounds, _c = _a.bounds, width = _c.width, height = _c.height;
        var anchorOffsetX = this._anchorOffset.x = width * x;
        var anchorOffsetY = this._anchorOffset.y = height * y;
        bounds.x = -anchorOffsetX;
        bounds.y = -anchorOffsetY;
    };
    Renderer.prototype.hitTest = function (x, y) {
        return this.bounds.contains(x, y);
    };
    __decorate([
        dirtyFieldTrigger
    ], Renderer.prototype, "anchor", void 0);
    return Renderer;
}(ScillaComponent));

var entry_21 = /*#__PURE__*/Object.freeze({
    'default': Renderer
});

var dirtyFieldTrigger$1 = scilla.decorators.dirtyFieldTrigger;
var InteractComponent = (function (_super) {
    __extends(InteractComponent, _super);
    function InteractComponent() {
        var _this = _super.call(this) || this;
        _this.interactable = true;
        _this.touchInterrupt = false;
        _this.invertMatrix = scilla.Matrix.create();
        _this.localPos = {};
        _this.isOut = true;
        return _this;
    }
    InteractComponent.prototype._dealGlobalTouchBegin = function (e) {
        var interrupt = _super.prototype._dealGlobalTouchBegin.call(this, e);
        var hitOn = this.hitTest(e);
        if (hitOn) {
            this._touchBeginFlag = true;
            this.onTouchBegin(e);
            this._dealTouchOver(e);
        }
        return hitOn && (interrupt || this.touchInterrupt);
    };
    InteractComponent.prototype._dealGlobalTouchMove = function (e) {
        var interrupt = _super.prototype._dealGlobalTouchMove.call(this, e);
        var hitOn = this.hitTest(e);
        if (hitOn) {
            this._dealTouchOver(e);
            this.onTouchMove(e);
        }
        else {
            this._dealTouchOut(e);
        }
        return hitOn && (interrupt || this.touchInterrupt);
    };
    InteractComponent.prototype._dealGlobalTouchEnd = function (e) {
        var interrupt = _super.prototype._dealGlobalTouchEnd.call(this, e);
        var hitOn = this.hitTest(e);
        if (hitOn) {
            this.onTouchEnd(e);
            if (this._touchBeginFlag) {
                this.onTouchTap(e);
                this._touchBeginFlag = false;
            }
        }
        this.isOut = true;
        return hitOn && (interrupt || this.touchInterrupt);
    };
    InteractComponent.prototype._dealTouchOver = function (e) {
        if (this.isOut) {
            this.isOut = false;
            this.onTouchOver(e);
        }
    };
    InteractComponent.prototype._dealTouchOut = function (e) {
        if (!this.isOut) {
            this.isOut = true;
            this.onTouchOut(e);
        }
    };
    InteractComponent.prototype.onTouchBegin = function (e) {
    };
    InteractComponent.prototype.onTouchMove = function (e) {
    };
    InteractComponent.prototype.onTouchOver = function (e) {
    };
    InteractComponent.prototype.onTouchOut = function (e) {
    };
    InteractComponent.prototype.onTouchEnd = function (e) {
    };
    InteractComponent.prototype.onTouchTap = function (e) {
    };
    InteractComponent.prototype.hitTest = function (e) {
        var e_1, _a;
        var matrix = this.transform.getMatrix(true, true, true);
        matrix.transformPoint(e.x, e.y, this.localPos);
        var result = false;
        var renderers = this.entity.getComponents(Renderer);
        try {
            for (var renderers_1 = __values(renderers), renderers_1_1 = renderers_1.next(); !renderers_1_1.done; renderers_1_1 = renderers_1.next()) {
                var renderer = renderers_1_1.value;
                if (renderer.hitTest(this.localPos.x, this.localPos.y)) {
                    if (!renderer['isUsedToMask']) {
                        result = true;
                        break;
                    }
                }
                else if (renderer['isUsedToMask']) {
                    return false;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (renderers_1_1 && !renderers_1_1.done && (_a = renderers_1.return)) _a.call(renderers_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    __decorate([
        dirtyFieldTrigger$1
    ], InteractComponent.prototype, "interactable", void 0);
    return InteractComponent;
}(ScillaComponent));

var entry_17 = /*#__PURE__*/Object.freeze({
    'default': InteractComponent
});

var dirtyFieldDetector$1 = scilla.decorators.dirtyFieldDetector, dirtyFieldTrigger$2 = scilla.decorators.dirtyFieldTrigger;
var MATRIX_ORDER;
(function (MATRIX_ORDER) {
    MATRIX_ORDER[MATRIX_ORDER["SCALE_ROTATE"] = 0] = "SCALE_ROTATE";
    MATRIX_ORDER[MATRIX_ORDER["ROTATE_SCALE"] = 1] = "ROTATE_SCALE";
})(MATRIX_ORDER || (MATRIX_ORDER = {}));
var Transform = (function (_super) {
    __extends(Transform, _super);
    function Transform() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onVector2DModify = function (value, key, oldValue) {
            _this.makeDirty(value, key, oldValue);
        };
        _this.position = new scilla.Vector2D(0, 0);
        _this._globalPosition = new scilla.Vector2D(0, 0);
        _this.alpha = 1;
        _this.affectChildren = true;
        _this._width = NaN;
        _this._height = NaN;
        _this.scale = new scilla.Vector2D(1, 1);
        _this.pivot = new scilla.Vector2D(0.5, 0.5);
        _this.rotation = 0;
        _this.order = MATRIX_ORDER.SCALE_ROTATE;
        _this._localMatrix = scilla.Matrix.create();
        _this._globalMatrix = scilla.Matrix.create();
        _this._globalInvertMatrix = scilla.Matrix.create();
        _this._globalPivotMatrix = scilla.Matrix.create();
        return _this;
    }
    Object.defineProperty(Transform.prototype, "renderAlpha", {
        get: function () {
            return this._renderAlpha;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Transform.prototype, "width", {
        get: function () {
            var renderer = this.entity.getComponent(Renderer);
            return renderer ? renderer.bounds.width : (isNaN(this._width) ? 0 : this._width);
        },
        set: function (value) {
            if (this._width != value) {
                this._width = value;
                this.makeDirty(value, 'width');
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Transform.prototype, "explicitWidth", {
        get: function () {
            return this._width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Transform.prototype, "height", {
        get: function () {
            var renderer = this.entity.getComponent(Renderer);
            return renderer ? renderer.bounds.height : (isNaN(this._height) ? 0 : this._height);
        },
        set: function (value) {
            if (this._height != value) {
                this._height = value;
                this.makeDirty(value, 'height');
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Transform.prototype, "explicitHeight", {
        get: function () {
            return this._height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Transform.prototype, "globalPosition", {
        get: function () {
            this._globalPosition.setXY(this._globalMatrix.tx, this._globalMatrix.ty);
            return this._globalPosition;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Transform.prototype, "globalRotation", {
        get: function () {
            return this._globalMatrix.rotation * 180 / Math.PI;
        },
        enumerable: true,
        configurable: true
    });
    Transform.prototype.makeDirty = function (value, key, oldValue) {
        var e_1, _a;
        this.dirty = true;
        switch (key) {
            case 'width':
            case 'height':
                var renderers = this.entity.getComponents(Renderer);
                try {
                    for (var renderers_1 = __values(renderers), renderers_1_1 = renderers_1.next(); !renderers_1_1.done; renderers_1_1 = renderers_1.next()) {
                        var renderer = renderers_1_1.value;
                        renderer.makeDirty();
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (renderers_1_1 && !renderers_1_1.done && (_a = renderers_1.return)) _a.call(renderers_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                break;
        }
    };
    Transform.prototype.onModify = function (value, key, oldValue) {
        _super.prototype.onModify.call(this, value, key, oldValue);
        this.makeDirty(value, key, oldValue);
        switch (key) {
            case 'position':
            case 'scale':
                value.onChange = this.onVector2DModify;
                break;
        }
    };
    Transform.prototype.updateLocalMatrix = function () {
        var _a = this, _b = _a.position, x = _b.x, y = _b.y, _c = _a.scale, sx = _c.x, sy = _c.y, rotation = _a.rotation;
        var matrix = this._localMatrix;
        matrix.identity();
        if (this.order === MATRIX_ORDER.SCALE_ROTATE) {
            matrix.scale(sx, sy);
            matrix.rotate(rotation * Math.PI / 180);
        }
        else {
            matrix.rotate(rotation * Math.PI / 180);
            matrix.scale(sx, sy);
        }
        matrix.translate(x, y);
    };
    Transform.prototype.updateGlobalMatrix = function () {
        var _a = this, entity = _a.entity, _globalMatrix = _a._globalMatrix, _localMatrix = _a._localMatrix, _globalPivotMatrix = _a._globalPivotMatrix, _b = _a.pivot, px = _b.x, py = _b.y, width = _a.width, height = _a.height;
        _globalMatrix.copyFrom(_localMatrix);
        if (entity.parent) {
            var parentTransform = entity.parent.getComponent(Transform);
            if (parentTransform) {
                this._renderAlpha = parentTransform._renderAlpha * this.alpha;
                _globalMatrix.concat(parentTransform.getMatrix(true, false));
            }
            else {
                this._renderAlpha = this.alpha;
            }
        }
        else {
            this._renderAlpha = this.alpha;
        }
        _globalPivotMatrix.copyFrom(_globalMatrix);
        var a = _globalMatrix.a, d = _globalMatrix.d;
        _globalPivotMatrix.translate(-(px - 0.5) * width * a, -(py - 0.5) * height * d);
    };
    Transform.prototype.getMatrix = function (withPivot, invert, affectChildren) {
        if (withPivot === void 0) { withPivot = false; }
        if (invert === void 0) { invert = false; }
        if (affectChildren === void 0) { affectChildren = false; }
        var matrix;
        if (this.affectChildren || affectChildren) {
            matrix = withPivot ? this._globalPivotMatrix : this._globalMatrix;
            if (invert) {
                var invertMatrix = this._globalInvertMatrix;
                invertMatrix.copyFrom(matrix);
                invertMatrix.invert();
                return invertMatrix;
            }
        }
        else {
            matrix = this.entity.parent.getComponent(Transform).getMatrix(withPivot, invert);
        }
        return matrix;
    };
    Transform.prototype.onUpdate = function (t) {
        if (this.dirty) {
            this.updateLocalMatrix();
            this.dirty = false;
        }
        this.updateGlobalMatrix();
        _super.prototype.onUpdate.call(this, t);
    };
    Transform.prototype.onEditorUpdate = function (t) {
        this.onUpdate(t);
    };
    __decorate([
        dirtyFieldTrigger$2
    ], Transform.prototype, "position", void 0);
    __decorate([
        dirtyFieldTrigger$2
    ], Transform.prototype, "alpha", void 0);
    __decorate([
        dirtyFieldTrigger$2
    ], Transform.prototype, "affectChildren", void 0);
    __decorate([
        dirtyFieldTrigger$2
    ], Transform.prototype, "scale", void 0);
    __decorate([
        dirtyFieldTrigger$2
    ], Transform.prototype, "pivot", void 0);
    __decorate([
        dirtyFieldDetector$1
    ], Transform.prototype, "rotation", void 0);
    return Transform;
}(ScillaComponent));

var entry_19 = /*#__PURE__*/Object.freeze({
    get MATRIX_ORDER () { return MATRIX_ORDER; },
    'default': Transform
});

var LockingType;
(function (LockingType) {
    LockingType[LockingType["NOSET"] = 0] = "NOSET";
    LockingType[LockingType["HORIZON"] = 1] = "HORIZON";
    LockingType[LockingType["VERTICAL"] = 2] = "VERTICAL";
})(LockingType || (LockingType = {}));
var ScrollView = (function (_super) {
    __extends(ScrollView, _super);
    function ScrollView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.lockingType = LockingType.NOSET;
        _this._lastPos = scilla.createVector2D();
        _this._speed = scilla.createVector2D();
        _this.updatePosOffset = function () {
            var _a = _this._contentTransform.position, x = _a.x, y = _a.y;
            _this._posOffset = { x: x, y: y };
        };
        _this.updatePosRange = function () {
            var _a = _this._viewportTransform, pWidth = _a.width, pHeight = _a.height;
            var _b = _this._contentTransform, width = _b.width, height = _b.height;
            _this._posRange = new scilla.Size(pWidth - width, pHeight - height);
        };
        return _this;
    }
    ScrollView.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._contentTransform = this.content.getComponent(Transform);
        this._viewportTransform = this.viewport.getComponent(Transform);
        this.callOnNextTick(this.updatePosOffset);
    };
    ScrollView.prototype.onTouchBegin = function (e) {
        _super.prototype.onTouchBegin.call(this, e);
        this.updatePosRange();
        var tx = e.x, ty = e.y;
        var _a = this._contentTransform.position, cx = _a.x, cy = _a.y;
        this._beginPos = {
            tx: tx,
            ty: ty,
            cx: cx,
            cy: cy,
        };
        this._lastPos.setXY(tx, ty);
    };
    ScrollView.prototype.onGlobalTouchMove = function (e) {
        _super.prototype.onGlobalTouchMove.call(this, e);
        if (!this._beginPos) {
            return;
        }
        var _a = this, _b = _a._beginPos, tx = _b.tx, ty = _b.ty, cx = _b.cx, cy = _b.cy, _c = _a._posOffset, offX = _c.x, offY = _c.y, position = _a._contentTransform.position, lockingType = _a.lockingType;
        var x = e.x, y = e.y;
        var px = x - tx + cx;
        var py = y - ty + cy;
        var _d = this._posRange, rWidth = _d.width, rHeight = _d.height;
        var halfWidth = Math.abs(rWidth / 2);
        var paddingX = halfWidth - Math.abs(offX - halfWidth - px);
        if (paddingX < 0) {
            px += paddingX * 0.8 * (x - tx > 0 ? 1 : -1);
        }
        var halfHeight = Math.abs(rHeight / 2);
        var paddingY = halfHeight - Math.abs(offY - halfHeight - py);
        if (paddingY < 0) {
            py += paddingY * 0.8 * (y - ty > 0 ? 1 : -1);
        }
        switch (lockingType) {
            case LockingType.HORIZON:
                position.y = py;
                break;
            case LockingType.VERTICAL:
                position.x = px;
                break;
            default:
                position.setXY(px, py);
        }
        this._speed.copyFrom(this._lastPos.subtract({ x: x, y: y }));
        this._lastPos.setXY(x, y);
    };
    ScrollView.prototype.onGlobalTouchEnd = function (e) {
        _super.prototype.onGlobalTouchEnd.call(this, e);
        if (!this._beginPos) {
            return;
        }
        this._beginPos = null;
        var _a = this._posOffset, offX = _a.x, offY = _a.y;
        var _b = this._posRange, rWidth = _b.width, rHeight = _b.height;
        var _c = this._contentTransform, position = _c.position, _d = _c.position, x = _d.x, y = _d.y;
        var tx = Math.min(Math.max(offX + rWidth, x), offX);
        var ty = Math.min(Math.max(offY + rHeight, y), offY);
        var targetPos = scilla.createVector2D(tx, ty);
        var duration = Math.min(500, Math.max(targetPos.distance(position), 200));
        scilla.createTween(this, this._contentTransform, true, { fields: ['x', 'y'] })
            .to({ position: targetPos }, duration, scilla.ease.cubicOut);
    };
    return ScrollView;
}(InteractComponent));

var entry_3 = /*#__PURE__*/Object.freeze({
    get LockingType () { return LockingType; },
    'default': ScrollView
});

var TouchZoom = (function (_super) {
    __extends(TouchZoom, _super);
    function TouchZoom() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.scaleOffset = scilla.createVector2D(0.1, 0.1);
        _this.duration = 200;
        _this.easeName = scilla.Ease.backOut;
        return _this;
    }
    TouchZoom.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._zoomIn) {
            var _a = this, scaleOffset = _a.scaleOffset, duration = _a.duration, transform = _a.transform;
            var easeFunc = scilla.ease[this.easeName];
            var scaleFrom = transform.scale.clone();
            var scaleTo = transform.scale.clone().add(scaleOffset);
            this._zoomIn = scilla.createTween(this, transform, false, { autoPlay: false, fields: ['x', 'y'] })
                .to({ scale: scaleTo }, duration, easeFunc);
            this._zoomOut = scilla.createTween(this, transform, false, { autoPlay: false, fields: ['x', 'y'] })
                .to({ scale: scaleFrom }, duration, easeFunc);
        }
    };
    TouchZoom.prototype.onTouchBegin = function (e) {
        _super.prototype.onTouchOver.call(this, e);
        if (this.interactable) {
            this._touchBegin = true;
            this._zoomIn.play(true);
        }
    };
    TouchZoom.prototype.onGlobalTouchEnd = function (e) {
        _super.prototype.onGlobalTouchEnd.call(this, e);
        if (this._touchBegin) {
            this._touchBegin = false;
            this._zoomOut.play(true);
        }
        return false;
    };
    return TouchZoom;
}(InteractComponent));

var entry_5 = /*#__PURE__*/Object.freeze({
    'default': TouchZoom
});

var dirtyFieldDetector$2 = scilla.decorators.dirtyFieldDetector;
var FillMode;
(function (FillMode) {
    FillMode[FillMode["NORMAL"] = 0] = "NORMAL";
    FillMode[FillMode["SLICED"] = 1] = "SLICED";
    FillMode[FillMode["TILED"] = 2] = "TILED";
})(FillMode || (FillMode = {}));
var TextureRenderer = (function (_super) {
    __extends(TextureRenderer, _super);
    function TextureRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.fillMode = FillMode.NORMAL;
        _this.filters = [];
        return _this;
    }
    Object.defineProperty(TextureRenderer.prototype, "hasFilters", {
        get: function () {
            return this.filters && this.filters.length > 0;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TextureRenderer.prototype, "async_texture", {
        set: function (promise) {
            var _this = this;
            if (!promise) {
                return;
            }
            promise.then(function (texture) {
                _this.texture = texture;
            });
        },
        enumerable: true,
        configurable: true
    });
    TextureRenderer.prototype.draw = function () {
        _super.prototype.draw.call(this);
        this.drawImage();
        this.applyFilters();
    };
    TextureRenderer.prototype.applyFilters = function () {
        var e_1, _a;
        if (!this.hasFilters)
            return;
        var _b = this, texture = _b.texture, filters = _b.filters, currentCanvasContext = _b.currentCanvasContext;
        var _c = texture.bounds, textureWidth = _c.width, textureHeight = _c.height;
        var imageData = currentCanvasContext.getImageData(0, 0, textureWidth, textureHeight);
        try {
            for (var filters_1 = __values(filters), filters_1_1 = filters_1.next(); !filters_1_1.done; filters_1_1 = filters_1.next()) {
                var filter = filters_1_1.value;
                filter.drawFilter(imageData);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (filters_1_1 && !filters_1_1.done && (_a = filters_1.return)) _a.call(filters_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        currentCanvasContext.putImageData(imageData, 0, 0);
    };
    TextureRenderer.prototype.drawImage = function () {
        if (!this.texture) {
            return;
        }
        var _a = this, texture = _a.texture, fillMode = _a.fillMode, currentCanvasContext = _a.currentCanvasContext, _b = _a.bounds, width = _b.width, height = _b.height;
        var _c = texture.bounds, x = _c.x, y = _c.y, textureWidth = _c.width, textureHeight = _c.height;
        switch (fillMode) {
            case FillMode.NORMAL:
                texture.drawToCanvas(currentCanvasContext);
                break;
            case FillMode.SLICED:
                break;
            case FillMode.TILED:
                var textureCanvas = texture.getCacheCanvas();
                var pattern = currentCanvasContext.createPattern(textureCanvas, 'repeat');
                currentCanvasContext.rect(0, 0, width, height);
                currentCanvasContext.fillStyle = pattern;
                currentCanvasContext.fill();
                break;
        }
    };
    TextureRenderer.prototype.measureBounds = function () {
        if (!this.dirty) {
            return;
        }
        var _a = this, bounds = _a.bounds, _b = _a.transform, tWidth = _b.explicitWidth, tHeight = _b.explicitHeight;
        if (this.texture) {
            var _c = this.texture, textureWidth = _c.width, textureHeight = _c.height;
            bounds.width = isNaN(tWidth) ? textureWidth : tWidth;
            bounds.height = isNaN(tHeight) ? textureHeight : tHeight;
        }
        else {
            bounds.width = isNaN(tWidth) ? 0 : tWidth;
            bounds.height = isNaN(tHeight) ? 0 : tHeight;
        }
        _super.prototype.measureBounds.call(this);
    };
    __decorate([
        dirtyFieldDetector$2
    ], TextureRenderer.prototype, "texture", void 0);
    __decorate([
        dirtyFieldDetector$2
    ], TextureRenderer.prototype, "fillMode", void 0);
    __decorate([
        dirtyFieldDetector$2
    ], TextureRenderer.prototype, "filters", void 0);
    return TextureRenderer;
}(Renderer));

var entry_11 = /*#__PURE__*/Object.freeze({
    get FillMode () { return FillMode; },
    'default': TextureRenderer
});

var Button = (function (_super) {
    __extends(Button, _super);
    function Button() {
        var _this = _super.call(this) || this;
        _this.touchInterrupt = true;
        return _this;
    }
    Object.defineProperty(Button.prototype, "touchZoom", {
        get: function () {
            return this.entity && this.entity.getComponent(TouchZoom);
        },
        enumerable: true,
        configurable: true
    });
    Button.prototype.onModify = function (value, key, oldValue) {
        _super.prototype.onModify.call(this, value, key, oldValue);
        if (key === 'interactable') {
            if (this.touchZoom) {
                this.touchZoom.interactable = value;
            }
            try {
                this.changeTexture();
            }
            catch (e) { }
        }
    };
    Button.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this.onClick = new scilla.ScillaEvent();
    };
    Button.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this.bgRenderer = this.entity.getComponent(TextureRenderer);
        this.changeTexture(this.upRes);
    };
    Button.prototype.onTouchBegin = function (e) {
        _super.prototype.onTouchBegin.call(this, e);
        this.touchBeginWithSelf = true;
        this.changeTexture(this.downRes);
    };
    Button.prototype.onTouchOver = function (e) {
        _super.prototype.onTouchOver.call(this, e);
        if (this.touchBeginWithSelf) {
            this.touchBeginWithSelf = true;
            this.changeTexture(this.downRes);
        }
        this.touchOut = false;
    };
    Button.prototype.onTouchOut = function (e) {
        _super.prototype.onTouchOut.call(this, e);
        if (this.touchBeginWithSelf) {
            this.changeTexture(this.upRes);
        }
        this.touchOut = true;
    };
    Button.prototype.onGlobalTouchEnd = function (e) {
        if (this.touchBeginWithSelf && !this.touchOut) {
            this.onClick.invoke();
        }
        this.touchBeginWithSelf = false;
        this.changeTexture(this.upRes);
        return _super.prototype.onGlobalTouchEnd.call(this, e);
    };
    Button.prototype.changeTexture = function (res) {
        if (!this.bgRenderer) {
            return;
        }
        this.currentRes = res || this.upRes;
        if (this.interactable) {
            this.bgRenderer.texture = this.currentRes;
        }
        else {
            this.bgRenderer.texture = this.disabledRes;
        }
    };
    return Button;
}(InteractComponent));

var entry_4 = /*#__PURE__*/Object.freeze({
    'default': Button
});

var Fade = (function (_super) {
    __extends(Fade, _super);
    function Fade() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.fromAlpha = 0;
        _this.toAlpha = 1;
        _this.duration = 1000;
        return _this;
    }
    Fade.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (this._playing) {
            if (!this._startTime) {
                this._startTime = t;
            }
            var ratio = (t - this._startTime) / this.duration;
            this.transform.alpha = scilla.math.lerp(this.fromAlpha, this.toAlpha, ratio);
            if (ratio >= 1) {
                this.stop();
            }
        }
    };
    Fade.prototype.play = function () {
        this._startTime = 0;
        this._playing = true;
    };
    Fade.prototype.stop = function () {
        this._playing = false;
    };
    return Fade;
}(ScillaComponent));

var entry_6 = /*#__PURE__*/Object.freeze({
    'default': Fade
});

var PI2 = Math.PI * 2;
var WaveMethod;
(function (WaveMethod) {
    WaveMethod["round"] = "round";
    WaveMethod["rotate"] = "rotate";
    WaveMethod["zoom"] = "zoom";
    WaveMethod["fade"] = "fade";
    WaveMethod["cosWave"] = "cosWave";
    WaveMethod["sinWave"] = "sinWave";
    WaveMethod["shake"] = "shake";
    WaveMethod["breath"] = "breath";
})(WaveMethod || (WaveMethod = {}));
var Wave = (function (_super) {
    __extends(Wave, _super);
    function Wave() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.duration = 1000;
        _this.loop = -1;
        _this.autoPlay = true;
        _this.onComplete = new scilla.ScillaEvent();
        _this.onLoopComplete = new scilla.ScillaEvent();
        _this._oldProps = {};
        return _this;
    }
    Wave.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._waveMethod = waveLibs[this.waveMethod];
        this._startTime = 0;
        var position = this.transform.position;
        this._oldProps.x = position.x;
        this._oldProps.y = position.y;
        if (this.autoPlay) {
            this.play();
        }
    };
    Wave.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (this._playing) {
            if (!this._startTime) {
                this._startTime = t;
            }
            var _a = this, duration = _a.duration, waveParams = _a.waveParams, _waveMethod = _a._waveMethod, transform = _a.transform, _b = _a.transform, position = _b.position, scale = _b.scale, _oldProps = _a._oldProps;
            var pass = (t - this._startTime) % duration;
            var r = pass / duration * PI2;
            var loopCounting = Math.floor((t - this._startTime) / duration);
            if (loopCounting != this._loopCounting) {
                this._loopCounting = loopCounting;
                if (this.onLoopEnd()) {
                    r = PI2;
                }
            }
            var params = waveParams || [];
            var props = _waveMethod.apply(void 0, __spread(params, [r]));
            if (props.hasOwnProperty('x')) {
                position.x = (props.x || 0) + _oldProps.x;
            }
            if (props.hasOwnProperty('y')) {
                position.y = (props.y || 0) + _oldProps.y;
            }
            if (props.hasOwnProperty('sx')) {
                scale.x = props.sx;
            }
            if (props.hasOwnProperty('sy')) {
                scale.y = props.sy;
            }
            if (props.hasOwnProperty('r')) {
                transform.rotation = props.r;
            }
        }
    };
    Wave.prototype.onLoopEnd = function () {
        if (this.loop < 0) {
            this.onLoopComplete.invoke();
        }
        else if (this._loopCounting < this.loop) {
            this.onLoopComplete.invoke();
        }
        else {
            this._playing = false;
            this.onComplete.invoke();
            return true;
        }
    };
    Wave.prototype.play = function () {
        this._loopCounting = 0;
        this._playing = true;
        this._startTime = 0;
    };
    Wave.prototype.stop = function () {
        this._playing = false;
    };
    return Wave;
}(ScillaComponent));
var cos = Math.cos, sin = Math.sin, PI = Math.PI;
var waveLibs = {
    round: function (h, t) {
        return { x: cos(t) * h, y: sin(t) * h };
    },
    cosWave: function (h, t) {
        return { x: cos(t) * h, y: 0 };
    },
    sinWave: function (h, t) {
        h = h || 1;
        return { x: 0, y: sin(t) * h };
    },
    rotate: function (t) {
        return { r: 360 * t / PI / 2 };
    },
    shake: function (angle, count, t) {
        return { r: sin(t * count) * angle };
    },
    breath: function (scale, t) {
        if (scale === void 0) { scale = 0.1; }
        return { sx: sin(t) * scale + 1, sy: -sin(t + PI / 4) * scale + 1 };
    },
    zoom: function (scale, t) {
        if (scale === void 0) { scale = 0.1; }
        return { sx: sin(t) * scale + 1, sy: sin(t) * scale + 1 };
    },
    fade: function (base, t) {
        if (base === void 0) { base = 1; }
        return { alpha: (sin(t) + 1) * 0.5 + base };
    },
};

var entry_7 = /*#__PURE__*/Object.freeze({
    get WaveMethod () { return WaveMethod; },
    'default': Wave
});

var RelativeLayout = (function (_super) {
    __extends(RelativeLayout, _super);
    function RelativeLayout() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.left = NaN;
        _this.right = NaN;
        _this.top = NaN;
        _this.bottom = NaN;
        _this.horizontalCenter = NaN;
        _this.verticalCenter = NaN;
        _this.once = true;
        _this.adjust = function () {
            var e_1, _a, e_2, _b, e_3, _c;
            var _d = _this, entity = _d.entity, parent = _d.entity.parent, transform = _d.transform, _e = _d.transform, position = _e.position, _f = _e.pivot, ax = _f.x, ay = _f.y, left = _d.left, right = _d.right, top = _d.top, bottom = _d.bottom, horizontalCenter = _d.horizontalCenter, verticalCenter = _d.verticalCenter;
            var hasLeft = !isNaN(left);
            var hasRight = !isNaN(right);
            var hasTop = !isNaN(top);
            var hasBottom = !isNaN(bottom);
            var hasHorizontalCenter = !isNaN(horizontalCenter);
            var hasVerticalCenter = !isNaN(verticalCenter);
            var parentRenderers = parent.getComponents(Renderer);
            try {
                for (var parentRenderers_1 = __values(parentRenderers), parentRenderers_1_1 = parentRenderers_1.next(); !parentRenderers_1_1.done; parentRenderers_1_1 = parentRenderers_1.next()) {
                    var parentRenderer = parentRenderers_1_1.value;
                    parentRenderer.measureBounds();
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (parentRenderers_1_1 && !parentRenderers_1_1.done && (_a = parentRenderers_1.return)) _a.call(parentRenderers_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            var parentTransform = parent.getComponent(Transform);
            var pWidth, pHeight;
            if (parentRenderers.length > 0) {
                var parentBounds = parentRenderers[0].bounds;
                pWidth = parentBounds.width;
                pHeight = parentBounds.height;
            }
            else {
                pWidth = parentTransform.explicitWidth;
                pHeight = parentTransform.explicitHeight;
            }
            var _g = parentTransform.pivot, pax = _g.x, pay = _g.y;
            var renderers = entity.getComponents(Renderer);
            try {
                for (var renderers_1 = __values(renderers), renderers_1_1 = renderers_1.next(); !renderers_1_1.done; renderers_1_1 = renderers_1.next()) {
                    var renderer = renderers_1_1.value;
                    renderer.measureBounds();
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (renderers_1_1 && !renderers_1_1.done && (_b = renderers_1.return)) _b.call(renderers_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
            var width = transform.width, height = transform.height;
            var x = position.x, y = position.y;
            var widthModified = false, heightModified = false;
            {
                if (hasHorizontalCenter) {
                    x = (pWidth - width) / 2 - pWidth * pax + width * ax;
                }
                else if (hasLeft) {
                    if (hasRight) {
                        widthModified = true;
                        width = pWidth - right - left;
                        x = (left - right) / 2 - (0.5 - ax) * width;
                    }
                    else {
                        x = left - pWidth * pax + width * ax;
                    }
                }
                else if (hasRight) {
                    x = -right + pWidth * (1 - pax) - width * (1 - ax);
                }
                if (hasVerticalCenter) {
                    y = (pHeight - height) / 2 - pHeight * pay + height * ay;
                }
                else if (hasTop) {
                    if (hasBottom) {
                        heightModified = true;
                        height = pHeight - bottom - top;
                        y = (top - bottom) / 2 - (0.5 - ay) * height;
                    }
                    else {
                        y = top - pHeight * pay + height * ay;
                    }
                }
                else if (hasBottom) {
                    y = -bottom + pHeight * (1 - pay) - height * (1 - ay);
                }
            }
            position.x = x;
            position.y = y;
            if (widthModified) {
                transform.width = width;
            }
            if (heightModified) {
                transform.height = height;
            }
            if (widthModified || heightModified) {
                try {
                    for (var renderers_2 = __values(renderers), renderers_2_1 = renderers_2.next(); !renderers_2_1.done; renderers_2_1 = renderers_2.next()) {
                        var renderer = renderers_2_1.value;
                        renderer.measureBounds();
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (renderers_2_1 && !renderers_2_1.done && (_c = renderers_2.return)) _c.call(renderers_2);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
        };
        return _this;
    }
    RelativeLayout.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
    };
    RelativeLayout.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this.adjust();
    };
    RelativeLayout.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (!this.once) {
            this.adjust();
        }
    };
    RelativeLayout.prototype.onEditorUpdate = function (t) {
        this.adjust();
    };
    RelativeLayout.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    RelativeLayout.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
    };
    return RelativeLayout;
}(ScillaComponent));

var entry_8 = /*#__PURE__*/Object.freeze({
    'default': RelativeLayout
});

var FullStageSize = (function (_super) {
    __extends(FullStageSize, _super);
    function FullStageSize() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.once = true;
        _this.applyWidth = true;
        _this.applyHeight = true;
        return _this;
    }
    Object.defineProperty(FullStageSize.prototype, "stageSize", {
        get: function () {
            if (!this._stageSize) {
                this._stageSize = scilla.engine.renderContext.stageSize;
            }
            return this._stageSize;
        },
        enumerable: true,
        configurable: true
    });
    FullStageSize.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
    };
    FullStageSize.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this.execute();
    };
    FullStageSize.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (!this.once) {
            this.execute();
        }
    };
    FullStageSize.prototype.onEditorUpdate = function (t) {
        _super.prototype.onEditorUpdate.call(this, t);
        this.execute();
    };
    FullStageSize.prototype.execute = function () {
        var _a = this.stageSize, width = _a.width, height = _a.height;
        if (this.applyWidth) {
            this.transform.width = width;
        }
        if (this.applyHeight) {
            this.transform.height = height;
        }
    };
    return FullStageSize;
}(ScillaComponent));

var entry_9 = /*#__PURE__*/Object.freeze({
    'default': FullStageSize
});

var CameraController = (function (_super) {
    __extends(CameraController, _super);
    function CameraController() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.viewportAnchor = scilla.createVector2D(0.5, 0.5);
        _this.maxScale = 1.2;
        _this.once = true;
        return _this;
    }
    CameraController.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        var target = this.target;
        if (target) {
            this.targetPosition = target.getComponent(Transform).position;
        }
        this.followPosition = scilla.createVector2D();
        if (this.once) {
            this.updateViewport();
        }
    };
    Object.defineProperty(CameraController.prototype, "stageSize", {
        get: function () {
            if (!this._stageSize) {
                this._stageSize = scilla.engine.renderContext.stageSize;
            }
            return this._stageSize;
        },
        enumerable: true,
        configurable: true
    });
    CameraController.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (!this.once) {
            this.updateViewport();
        }
        this.followTarget();
    };
    CameraController.prototype.onEditorUpdate = function (t) {
        this.updateViewport();
    };
    CameraController.prototype.updateViewport = function () {
        if (this.viewportAnchor) {
            var _a = this.stageSize, width = _a.width, height = _a.height;
            var _b = this.viewportAnchor, x = _b.x, y = _b.y;
            var _c = this.transform.scale, sx = _c.x, sy = _c.y;
            this.transform.position.setXY(width * x * sx, height * y * sy);
        }
    };
    CameraController.prototype.followTarget = function () {
        if (!this.targetPosition) {
            return;
        }
        var _a = this, _b = _a.transform, scale = _b.scale, position = _b.position, _c = _a.stageSize, width = _c.width, height = _c.height, _d = _a.targetPosition, x = _d.x, y = _d.y, length = _d.length, maxScale = _a.maxScale;
        var newScale = maxScale - length * maxScale / 2048;
        scale.setXY(newScale, newScale);
        this.followPosition.setXY(width / 2, height / 2).subtract(this.targetPosition);
        position.copyFrom(scilla.math.lerpObj(position, this.followPosition, 0.1, ['x', 'y']));
    };
    return CameraController;
}(ScillaComponent));

var entry_10 = /*#__PURE__*/Object.freeze({
    'default': CameraController
});

var GraphicRenderer = (function (_super) {
    __extends(GraphicRenderer, _super);
    function GraphicRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.fillColor = '#42bce4';
        _this.borderColor = '#0899d0';
        _this.borderWidth = 0;
        _this.isMask = false;
        _this.maskVisible = false;
        return _this;
    }
    GraphicRenderer.prototype.getUseCacheMode = function () {
        return this._useCacheMode && !this.isMask;
    };
    GraphicRenderer.prototype.getRenderSize = function () {
        return { width: 0, height: 0 };
    };
    GraphicRenderer.prototype.beforeDraw = function () {
        _super.prototype.beforeDraw.call(this);
        this.applyStyle();
        this.currentCanvasContext.beginPath();
    };
    GraphicRenderer.prototype.draw = function () {
        _super.prototype.draw.call(this);
        if (this.isMask) {
            this._context.clip();
            this.maskVisible && this.fillAndStoke();
        }
        else {
            this.fillAndStoke();
        }
    };
    GraphicRenderer.prototype.applyStyle = function () {
        var _a = this, currentCanvasContext = _a.currentCanvasContext, fillColor = _a.fillColor, borderColor = _a.borderColor, borderWidth = _a.borderWidth;
        currentCanvasContext.fillStyle = fillColor;
        if (borderWidth > 0) {
            currentCanvasContext.strokeStyle = borderColor;
            currentCanvasContext.lineWidth = borderWidth;
        }
    };
    GraphicRenderer.prototype.fillAndStoke = function () {
        var _a = this, currentCanvasContext = _a.currentCanvasContext, borderWidth = _a.borderWidth;
        currentCanvasContext.fill();
        if (borderWidth > 0) {
            currentCanvasContext.stroke();
        }
    };
    GraphicRenderer.prototype.drawClip = function () {
        this.isMask && this.currentCanvasContext.save();
    };
    GraphicRenderer.prototype.afterUpdate = function () {
        this.isMask && this.currentCanvasContext.restore();
    };
    GraphicRenderer.prototype.afterEditorUpdate = function () {
        this.afterUpdate();
    };
    GraphicRenderer.prototype.measureBounds = function () {
        if (this.entity.name == 'content') {
            console.log();
        }
        if (!this.dirty) {
            return;
        }
        this._margin = this.borderWidth;
        var _a = this, bounds = _a.bounds, _b = _a.transform, tWidth = _b.explicitWidth, tHeight = _b.explicitHeight;
        var _c = this.getRenderSize(), sWidth = _c.width, sHeight = _c.height;
        bounds.width = isNaN(tWidth) ? sWidth : tWidth;
        bounds.height = isNaN(tHeight) ? sHeight : tHeight;
        _super.prototype.measureBounds.call(this);
    };
    return GraphicRenderer;
}(Renderer));

var entry_18 = /*#__PURE__*/Object.freeze({
    'default': GraphicRenderer
});

var dirtyFieldDetector$3 = scilla.decorators.dirtyFieldDetector;
var RectRenderer = (function (_super) {
    __extends(RectRenderer, _super);
    function RectRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.width = 100;
        _this.height = 100;
        _this.cornerRadius = 0;
        return _this;
    }
    RectRenderer.prototype.getRenderSize = function () {
        var _a = this, width = _a.width, height = _a.height;
        return { width: width, height: height };
    };
    RectRenderer.prototype.draw = function () {
        var PI = Math.PI;
        var _a = this, currentCanvasContext = _a.currentCanvasContext, r = _a.cornerRadius, _b = _a.bounds, width = _b.width, height = _b.height, _margin = _a._margin, _useCacheMode = _a._useCacheMode;
        var offset = _useCacheMode ? _margin : 0;
        if (r) {
            currentCanvasContext.moveTo(offset + r, offset + 0);
            currentCanvasContext.lineTo(offset + width - r, offset + 0);
            currentCanvasContext.arc(offset + width - r, offset + r, r, PI * 3 / 2, PI * 2);
            currentCanvasContext.lineTo(offset + width, offset + height - r);
            currentCanvasContext.arc(offset + width - r, offset + height - r, r, 0, PI / 2);
            currentCanvasContext.lineTo(offset + r, offset + height);
            currentCanvasContext.arc(offset + r, offset + height - r, r, PI / 2, PI);
            currentCanvasContext.lineTo(offset + 0, offset + r);
            currentCanvasContext.arc(offset + r, offset + r, r, PI, PI * 3 / 2);
        }
        else {
            currentCanvasContext.rect(offset, offset, width, height);
        }
        _super.prototype.draw.call(this);
    };
    __decorate([
        dirtyFieldDetector$3
    ], RectRenderer.prototype, "width", void 0);
    __decorate([
        dirtyFieldDetector$3
    ], RectRenderer.prototype, "height", void 0);
    __decorate([
        dirtyFieldDetector$3
    ], RectRenderer.prototype, "cornerRadius", void 0);
    return RectRenderer;
}(GraphicRenderer));

var entry_12 = /*#__PURE__*/Object.freeze({
    'default': RectRenderer
});

var FrameAnimationRenderer = (function (_super) {
    __extends(FrameAnimationRenderer, _super);
    function FrameAnimationRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.autoPlay = false;
        _this.fps = NaN;
        _this.onComplete = new scilla.ScillaEvent();
        _this.onLoopComplete = new scilla.ScillaEvent();
        return _this;
    }
    FrameAnimationRenderer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (this.autoPlay) {
            this.play(0, -1);
        }
    };
    FrameAnimationRenderer.prototype.onUpdate = function (t) {
        if (this._playing) {
            var _a = this, frameAnimation = _a.frameAnimation, _startFrame = _a._startFrame, _endFrame = _a._endFrame, fps = _a.fps;
            if (this._startFlag) {
                this._startFlag = false;
                this._startTime = t;
                this._loopCounting++;
            }
            var mFPS = isNaN(fps) ? frameAnimation.fps : fps;
            var passTime = t - this._startTime;
            var passFrameCount = Math.floor(passTime / (1000 / mFPS));
            var passFrameInRegion = passFrameCount % (_endFrame - _startFrame + 1);
            this._currentFrameIndex = _startFrame + passFrameInRegion;
            if (passFrameInRegion == 0 && passFrameCount > 0) {
                this._currentFrameIndex = _endFrame;
                this.onLoopEnd();
            }
        }
        _super.prototype.onUpdate.call(this, t);
    };
    FrameAnimationRenderer.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    FrameAnimationRenderer.prototype.onLoopEnd = function () {
        if (this._loop < 0) {
            this._startFlag = true;
            this.onLoopComplete.invoke();
        }
        else if (this._loopCounting < this._loop) {
            this._startFlag = true;
            this.onLoopComplete.invoke();
        }
        else {
            this._playing = false;
            this.onComplete.invoke();
        }
    };
    FrameAnimationRenderer.prototype.play = function (frame, loop, force) {
        if (frame === void 0) { frame = 0; }
        if (loop === void 0) { loop = 0; }
        if (force === void 0) { force = true; }
        this._loop = loop;
        this._loopCounting = 0;
        if (!this.frameAnimation) {
            return;
        }
        var startFrame = 0, endFrame = this.frameAnimation.frameCount - 1;
        if (typeof frame == 'string') {
            var label = this.frameAnimation.getLabel(frame);
            if (label) {
                startFrame = label.frame - 1;
                endFrame = label.end;
            }
        }
        else {
            startFrame = frame;
        }
        this._startFrame = startFrame;
        this._endFrame = endFrame;
        this._currentFrameIndex = this._startFrame;
        this._startFlag = true;
        this._playing = true;
    };
    FrameAnimationRenderer.prototype.stop = function () {
        this._playing = false;
    };
    FrameAnimationRenderer.prototype.draw = function () {
        _super.prototype.draw.call(this);
        if (!this.frameAnimation) {
            return;
        }
        var _a = this, currentCanvasContext = _a.currentCanvasContext, frameAnimation = _a.frameAnimation, _currentFrameIndex = _a._currentFrameIndex, bounds = _a.bounds;
        var _b = frameAnimation.getFrame(_currentFrameIndex), texture = _b.texture, data = _b.data;
        if (texture) {
            var img = texture.img, _c = texture.bounds, x = _c.x, y = _c.y, textureWidth = _c.width, textureHeight = _c.height;
            bounds.setTo(data.x, data.y, textureWidth, textureHeight);
            currentCanvasContext.drawImage(img, x, y, textureWidth, textureHeight, data.x, data.y, textureWidth, textureHeight);
        }
    };
    return FrameAnimationRenderer;
}(Renderer));

var entry_13 = /*#__PURE__*/Object.freeze({
    'default': FrameAnimationRenderer
});

var dirtyFieldDetector$4 = scilla.decorators.dirtyFieldDetector, dirtyFieldTrigger$3 = scilla.decorators.dirtyFieldTrigger;
var TextAlign;
(function (TextAlign) {
    TextAlign["LEFT"] = "left";
    TextAlign["CENTER"] = "center";
    TextAlign["RIGHT"] = "right";
})(TextAlign || (TextAlign = {}));
var VerticalAlign;
(function (VerticalAlign) {
    VerticalAlign["TOP"] = "top";
    VerticalAlign["MIDDLE"] = "middle";
    VerticalAlign["BOTTOM"] = "bottom";
})(VerticalAlign || (VerticalAlign = {}));
var TextRenderer = (function (_super) {
    __extends(TextRenderer, _super);
    function TextRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.text = '';
        _this.textFlow = null;
        _this.textAlign = TextAlign.CENTER;
        _this.verticalAlign = VerticalAlign.MIDDLE;
        _this.lineSpacing = 0;
        _this.letterSpacing = 0;
        _this._lineHeight = NaN;
        _this._bmpLineHeight = 0;
        _this.textStyle = new scilla.TextStyle();
        _this.useCacheMode = true;
        _this.measureCache = {};
        return _this;
    }
    TextRenderer.prototype.onModify = function (value, key, oldValue) {
        _super.prototype.onModify.call(this, value, key, oldValue);
        switch (key) {
            case 'textFlow':
                if (value) {
                    this.updateTextFlow();
                }
                break;
            case 'textStyle':
                value.onChange = this.makeDirty.bind(this);
                this.makeDirty();
                break;
        }
    };
    TextRenderer.prototype.updateTextFlow = function () {
        var e_1, _a;
        var text = '';
        if (this.textFlow) {
            try {
                for (var _b = __values(this.textFlow), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    text += item.text;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        this._pureText = text;
        this.makeDirty();
    };
    Object.defineProperty(TextRenderer.prototype, "lineHeight", {
        get: function () {
            return isNaN(this._lineHeight) ? (this.isBmpMode ? this._bmpLineHeight : this.textStyle.fontSize * scilla.EngineConfig.lineHeightRatio) : this._lineHeight;
        },
        set: function (value) {
            if (this._lineHeight != value) {
                this._lineHeight = value;
                this.dirty = true;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TextRenderer.prototype, "pureText", {
        get: function () {
            return this.textFlow ? this._pureText : this.text;
        },
        enumerable: true,
        configurable: true
    });
    TextRenderer.prototype.getRenderSize = function () {
        return {
            width: this._textWidth,
            height: this._textHeight,
        };
    };
    TextRenderer.prototype.beforeDraw = function () {
        _super.prototype.beforeDraw.call(this);
        if (!this.isBmpMode) {
            this.applyTextStyle();
        }
    };
    TextRenderer.prototype.applyTextStyle = function () {
        var _a = this, currentCanvasContext = _a.currentCanvasContext, textStyle = _a.textStyle;
        var fontStyle = textStyle.fontStyle, fontVariant = textStyle.fontVariant, fontWeight = textStyle.fontWeight, fontSize = textStyle.fontSize, fontFamily = textStyle.fontFamily;
        currentCanvasContext.font = fontStyle + " " + fontVariant + " " + fontWeight + " " + fontSize + "px " + fontFamily;
    };
    TextRenderer.prototype.fillAndStoke = function () {
        if (!this.pureText || this.pureText.length == 0) {
            return;
        }
        var _a = this, currentCanvasContext = _a.currentCanvasContext, measureCache = _a.measureCache, lineHeight = _a.lineHeight, lineSpacing = _a.lineSpacing, letterSpacing = _a.letterSpacing, rows = _a.rows, textAlign = _a.textAlign, verticalAlign = _a.verticalAlign, isBmpMode = _a.isBmpMode, _b = _a.transform, width = _b.width, height = _b.height;
        var rowCount = rows.length;
        var x = 0;
        switch (textAlign) {
            case "left":
                x = 0;
                break;
            case "right":
                x = width;
                break;
            case "center":
            default:
                x = width / 2;
                break;
        }
        var y = 0;
        var drawHeight = rowCount * lineHeight + lineSpacing * (rowCount - 1);
        switch (verticalAlign) {
            case "top":
                y = 0;
                break;
            case "bottom":
                y = height - drawHeight;
                break;
            case "middle":
            default:
                y = (height - drawHeight) / 2;
                break;
        }
        y += lineHeight;
        currentCanvasContext.textAlign = letterSpacing == 0 && !this.textFlow ? textAlign : 'left';
        currentCanvasContext.textBaseline = 'bottom';
        var offY = 0;
        for (var i = 0; i < rowCount; i++) {
            var _c = rows[i], text = _c.text, lineWidth = _c.lineWidth;
            if (letterSpacing == 0 && !isBmpMode && !this.textFlow) {
                this.drawText(i, text, x, y + offY);
            }
            else {
                var offX = 0;
                switch (textAlign) {
                    case "left":
                        offX = 0;
                        break;
                    case "right":
                        offX = -lineWidth;
                        break;
                    case "center":
                    default:
                        offX = -lineWidth / 2;
                        break;
                }
                for (var j = 0, lj = text.length; j < lj; j++) {
                    var char = text[j];
                    this.drawText(j, char, x + offX, y + offY);
                    if (measureCache[char].width > 0) {
                        offX += measureCache[char].width + letterSpacing;
                    }
                }
            }
            offY += lineHeight + lineSpacing;
        }
    };
    TextRenderer.prototype.getStyle = function (index) {
        var e_2, _a;
        if (!this.textFlow) {
            return null;
        }
        var targetItem;
        var count = 0;
        try {
            for (var _b = __values(this.textFlow), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                count += item.text.length;
                if (index < count) {
                    targetItem = item;
                    break;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return targetItem.style;
    };
    TextRenderer.prototype.drawText = function (index, text, x, y) {
        var _a = this, currentCanvasContext = _a.currentCanvasContext, borderWidth = _a.borderWidth, isBmpMode = _a.isBmpMode, fontRes = _a.fontRes;
        if (isBmpMode) {
            var texture = fontRes.getTexture(text);
            if (!texture) {
                return;
            }
            var _b = texture.bounds, textureX = _b.x, textureY = _b.y, textureWidth = _b.width, textureHeight = _b.height;
            currentCanvasContext.drawImage(texture.img, textureX, textureY, textureWidth, textureHeight, x, y, textureWidth, textureHeight);
        }
        else {
            var style = this.getStyle(index);
            if (style) {
                if (style.hasOwnProperty('textColor')) {
                    currentCanvasContext.fillStyle = style.textColor;
                }
            }
            else {
                currentCanvasContext.fillStyle = this.fillColor;
            }
            currentCanvasContext.fillText(text, x, y + 1);
            if (borderWidth > 0) {
                currentCanvasContext.strokeText(text, x, y + 1);
            }
        }
    };
    Object.defineProperty(TextRenderer.prototype, "isBmpMode", {
        get: function () {
            return !!this.fontRes;
        },
        enumerable: true,
        configurable: true
    });
    TextRenderer.prototype.measureText = function (text) {
        var e_3, _a, e_4, _b;
        var result;
        if (this.measureCache.hasOwnProperty(text)) {
            result = this.measureCache[text];
        }
        else {
            var _c = this, currentCanvasContext = _c.currentCanvasContext, letterSpacing = _c.letterSpacing, isBmpMode = _c.isBmpMode, fontRes = _c.fontRes, lineHeight = _c.lineHeight;
            if (isBmpMode) {
                if (text.length == 1) {
                    var texture = fontRes.getTexture(text);
                    result = {
                        width: texture ? texture.width : 0,
                        height: texture ? texture.height : 0,
                    };
                }
                else {
                    var totalWidth = 0, totalHeight = 0;
                    try {
                        for (var text_1 = __values(text), text_1_1 = text_1.next(); !text_1_1.done; text_1_1 = text_1.next()) {
                            var char = text_1_1.value;
                            var measureResult = this.measureText(char);
                            totalWidth += measureResult.width;
                            if (measureResult.height > totalHeight) {
                                totalHeight = measureResult.height;
                            }
                        }
                    }
                    catch (e_3_1) { e_3 = { error: e_3_1 }; }
                    finally {
                        try {
                            if (text_1_1 && !text_1_1.done && (_a = text_1.return)) _a.call(text_1);
                        }
                        finally { if (e_3) throw e_3.error; }
                    }
                    result = {
                        width: totalWidth,
                        height: totalHeight,
                    };
                }
            }
            else {
                result = {
                    width: currentCanvasContext.measureText(text).width,
                    height: lineHeight,
                };
            }
            result.width += letterSpacing * (text.length - 1);
            if (text.length == 1) {
                this.measureCache[text] = result;
            }
            if (letterSpacing != 0 && text.length > 1 || this.textFlow) {
                try {
                    for (var text_2 = __values(text), text_2_1 = text_2.next(); !text_2_1.done; text_2_1 = text_2.next()) {
                        var char = text_2_1.value;
                        this.measureCache[char] = this.measureText(char);
                    }
                }
                catch (e_4_1) { e_4 = { error: e_4_1 }; }
                finally {
                    try {
                        if (text_2_1 && !text_2_1.done && (_b = text_2.return)) _b.call(text_2);
                    }
                    finally { if (e_4) throw e_4.error; }
                }
            }
        }
        return result;
    };
    TextRenderer.prototype.splitText = function () {
        var e_5, _a;
        var _b = this, text = _b.pureText, letterSpacing = _b.letterSpacing, lineSpacing = _b.lineSpacing, lineHeight = _b.lineHeight, isBmpMode = _b.isBmpMode, _c = _b.transform, explicitWidth = _c.explicitWidth, explicitHeight = _c.explicitHeight;
        this.measureCache = {};
        var textWidth = 0, textHeight = 0, maxHeight = 0;
        var rows = [], measureResult;
        if (text && text.length > 0) {
            if (isNaN(explicitWidth)) {
                var lines = text.split('\n');
                try {
                    for (var lines_1 = __values(lines), lines_1_1 = lines_1.next(); !lines_1_1.done; lines_1_1 = lines_1.next()) {
                        var line = lines_1_1.value;
                        measureResult = this.measureText(line);
                        var mw = measureResult.width;
                        if (mw > textWidth) {
                            textWidth = mw;
                        }
                        if (isBmpMode) {
                            var mh = measureResult.height;
                            if (mh > maxHeight) {
                                maxHeight = mh;
                            }
                        }
                        rows.push({
                            text: line,
                            lineWidth: mw,
                        });
                    }
                }
                catch (e_5_1) { e_5 = { error: e_5_1 }; }
                finally {
                    try {
                        if (lines_1_1 && !lines_1_1.done && (_a = lines_1.return)) _a.call(lines_1);
                    }
                    finally { if (e_5) throw e_5.error; }
                }
                if (!isBmpMode) {
                    maxHeight = lineHeight;
                }
                this._bmpLineHeight = maxHeight;
            }
            else {
                var chars = text.split('');
                var lineWidth = 0, charWidth = 0, index = 0;
                var line = '';
                for (var i = 0, li = chars.length; i < li; i++) {
                    var char = chars[i];
                    if (char == '\n') {
                        rows.push({
                            text: line,
                            lineWidth: lineWidth,
                        });
                        line = '';
                        lineWidth = 0;
                        index = 0;
                    }
                    else {
                        measureResult = this.measureText(char);
                        if (measureResult.width == 0) {
                            continue;
                        }
                        charWidth = measureResult.width;
                        var mh = measureResult.height;
                        if (mh > maxHeight) {
                            maxHeight = mh;
                        }
                        if (index > 0 && lineWidth + charWidth + (index == 0 ? 0 : letterSpacing) > explicitWidth) {
                            rows.push({
                                text: line,
                                lineWidth: lineWidth,
                            });
                            line = '';
                            lineWidth = 0;
                            index = 0;
                        }
                        line += char;
                        lineWidth += charWidth + (index == 0 ? 0 : letterSpacing);
                        index++;
                    }
                }
                this._bmpLineHeight = maxHeight;
                rows.push({
                    text: line,
                    lineWidth: lineWidth,
                });
                textWidth = explicitWidth;
            }
            textHeight = isNaN(explicitHeight) ? (maxHeight * rows.length + lineSpacing * (rows.length - 1)) : explicitHeight;
        }
        else {
            textWidth = isNaN(explicitWidth) ? 0 : explicitWidth;
            textHeight = isNaN(explicitHeight) ? 0 : explicitHeight;
        }
        this.rows = rows;
        this._textWidth = textWidth;
        this._textHeight = textHeight;
        return {
            rows: rows,
            textWidth: textWidth,
            textHeight: textHeight,
        };
    };
    TextRenderer.prototype.measureBounds = function () {
        if (!this.dirty) {
            return;
        }
        if (!this.isBmpMode) {
            this.applyTextStyle();
        }
        this.splitText();
        _super.prototype.measureBounds.call(this);
    };
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "text", void 0);
    __decorate([
        dirtyFieldTrigger$3
    ], TextRenderer.prototype, "textFlow", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "textAlign", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "verticalAlign", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "lineSpacing", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "letterSpacing", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "fontRes", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "textStyle", void 0);
    __decorate([
        dirtyFieldDetector$4
    ], TextRenderer.prototype, "useCacheMode", void 0);
    return TextRenderer;
}(GraphicRenderer));

var entry_14 = /*#__PURE__*/Object.freeze({
    get TextAlign () { return TextAlign; },
    get VerticalAlign () { return VerticalAlign; },
    'default': TextRenderer
});

var LineRenderer = (function (_super) {
    __extends(LineRenderer, _super);
    function LineRenderer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.x0 = 0;
        _this.y0 = 0;
        _this.x1 = 0;
        _this.y1 = 0;
        return _this;
    }
    LineRenderer.prototype.draw = function () {
        _super.prototype.draw.call(this);
        var _a = this, currentCanvasContext = _a.currentCanvasContext, x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
        currentCanvasContext.moveTo(x0, y0);
        currentCanvasContext.lineTo(x1, y1);
    };
    LineRenderer.prototype.measureBounds = function () {
        var bounds = this.bounds;
        bounds.width = 0;
        bounds.height = 0;
        _super.prototype.measureBounds.call(this);
    };
    return LineRenderer;
}(GraphicRenderer));

var entry_15 = /*#__PURE__*/Object.freeze({
    'default': LineRenderer
});

var TouchInterrupt = (function (_super) {
    __extends(TouchInterrupt, _super);
    function TouchInterrupt() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.touchInterrupt = true;
        return _this;
    }
    return TouchInterrupt;
}(InteractComponent));

var entry_16 = /*#__PURE__*/Object.freeze({
    'default': TouchInterrupt
});

var Animation = (function (_super) {
    __extends(Animation, _super);
    function Animation() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Animation.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
    };
    Animation.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        scilla.createTween(this, this.transform, true, { fields: ['x', 'y'] })
            .to({
            position: { x: 100, y: 100 },
            scale: { x: 2, y: 3 },
            rotation: 270
        }, 1000);
    };
    Animation.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    Animation.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    Animation.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
    };
    return Animation;
}(ScillaComponent));

var entry_22 = /*#__PURE__*/Object.freeze({
    'default': Animation
});

var Toast = (function (_super) {
    __extends(Toast, _super);
    function Toast() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.padding = 20;
        _this.offsetY = 0;
        _this.showDuration = 300;
        _this.hideDuration = 300;
        return _this;
    }
    Toast.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._bgTransform) {
            var _a = this, offsetY = _a.offsetY, hideDuration = _a.hideDuration, showDuration = _a.showDuration, transform = _a.transform;
            this._bgTransform = this.getComponent(Transform);
            this._labelRenderer = this.Label.getComponent(TextRenderer);
            this._labelTransform = this.Label.getComponent(Transform);
            this._tweenIn = scilla.createTween(this, transform, false, { autoPlay: false })
                .to({ position: { x: 0, y: offsetY } }, showDuration, scilla.ease.cubicOut);
            this._tweenOut = scilla.createTween(this, transform, false, { autoPlay: false })
                .to({ position: { y: 0 } }, hideDuration, scilla.ease.cubicIn)
                .call(this.onHidden);
            this.transform.position.y = this.outPos;
        }
    };
    Object.defineProperty(Toast.prototype, "outPos", {
        get: function () {
            return scilla.engine.renderContext.stageCenter.y + this._bgTransform.height;
        },
        enumerable: true,
        configurable: true
    });
    Toast.prototype.show = function (_a) {
        var _this = this;
        var content = _a.content, _b = _a.duration, duration = _b === void 0 ? 1000 : _b;
        this.entity.enabled = true;
        var _c = this, _bgTransform = _c._bgTransform, _labelRenderer = _c._labelRenderer, _labelTransform = _c._labelTransform, padding = _c.padding;
        _labelRenderer.text = content;
        _labelRenderer.measureBounds();
        _bgTransform.width = _labelTransform.width + padding * 2;
        _bgTransform.height = _labelTransform.height + padding * 2;
        this._tweenOut.queue[0].props.position.y = this.outPos;
        this._tweenIn.play(true);
        if (this._timerDuration) {
            clearTimeout(this._timerDuration);
            this._timerDuration = null;
        }
        this._timerDuration = setTimeout(function () {
            _this.hide();
        }, duration);
    };
    Toast.prototype.hide = function () {
        this._tweenOut.play(true);
    };
    Toast.prototype.onHidden = function () {
        this.entity.enabled = false;
    };
    return Toast;
}(ScillaComponent));

var entry_34 = /*#__PURE__*/Object.freeze({
    'default': Toast
});

function bearingsToOutPos(bearings) {
    var _a = scilla.engine.renderContext.stageSize, width = _a.width, height = _a.height;
    var x, y;
    switch (bearings) {
        case 'south':
            x = 0;
            y = height / 2;
            break;
        case 'west':
            x = -width / 2;
            y = 0;
            break;
        case 'east':
            x = width / 2;
            y = 0;
            break;
        case 'north':
        default:
            x = 0;
            y = -height / 2;
    }
    return {
        x: x, y: y,
    };
}
var none = {
    show: function (transform, options) {
        transform.position.setXY(0, 0);
        return Promise.resolve();
    },
    hide: function (transform, options) {
        transform.position.setXY(scilla.engine.renderContext.stageSize.width, 0);
        return Promise.resolve();
    }
};
var fade = {
    show: function (transform, options) {
        options = options || {};
        transform.alpha = 0;
        var toProps = {
            alpha: 1,
        };
        return new Promise(function (resolve) {
            scilla.createTween(transform, transform)
                .to(toProps, options.duration || 300, options.easeFunc)
                .call(resolve);
        });
    },
    hide: function (transform, options) {
        options = options || {};
        var toProps = {
            alpha: 0,
        };
        return new Promise(function (resolve) {
            scilla.createTween(transform, transform)
                .to(toProps, options.duration || 200, options.easeFunc)
                .call(resolve);
        });
    }
};
var flew = {
    show: function (transform, options) {
        options = options || {};
        var outPos = bearingsToOutPos(options.bearings);
        transform.position.copyFrom(outPos);
        var toProps = {
            position: { x: 0, y: 0, },
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            transform.alpha = 0;
            toProps.alpha = 1;
        }
        return new Promise(function (resolve) {
            scilla.createTween(transform, transform)
                .to(toProps, options.duration || 300, options.easeFunc || scilla.ease.backOut)
                .call(resolve);
        });
    },
    hide: function (transform, options) {
        options = options || {};
        var outPos = bearingsToOutPos(options.bearings);
        var toProps = {
            position: outPos,
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            toProps.alpha = 0;
        }
        return new Promise(function (resolve) {
            scilla.createTween(transform, transform)
                .to(toProps, options.duration || 200, options.easeFunc || scilla.ease.backIn)
                .call(resolve);
        });
    }
};
var zoom = {
    show: function (transform, options) {
        options = options || {};
        transform.scale.setXY(0, 0);
        var toProps = {
            scale: { x: 1, y: 1, },
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            transform.alpha = 0;
            toProps.alpha = 1;
        }
        return new Promise(function (resolve) {
            scilla.createTween(transform, transform)
                .to(toProps, options.duration || 300, options.easeFunc || scilla.ease.backOut)
                .call(resolve);
        });
    },
    hide: function (transform, options) {
        options = options || {};
        var toProps = {
            scale: { x: 0, y: 0 },
        };
        var withFade = options.hasOwnProperty('withFade') ? options.withFade : false;
        if (withFade) {
            toProps.alpha = 0;
        }
        return new Promise(function (resolve) {
            scilla.createTween(transform, transform)
                .to(toProps, options.duration || 200, options.easeFunc || scilla.ease.backIn)
                .call(resolve);
        });
    }
};

var CustomButton = (function (_super) {
    __extends(CustomButton, _super);
    function CustomButton() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CustomButton.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        var config = window['configJson'];
        if (this.upLabelColorKey) {
            this.upLabelColor = config[this.upLabelColorKey];
        }
        if (this.disabledLabelColorKey) {
            this.disabledLabelColor = config[this.disabledLabelColorKey];
        }
    };
    return CustomButton;
}(Button));

var entry_47 = /*#__PURE__*/Object.freeze({
    'default': CustomButton
});

var dirtyFieldTrigger$4 = scilla.decorators.dirtyFieldTrigger;
var DialogContent = (function (_super) {
    __extends(DialogContent, _super);
    function DialogContent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.effect = PopupEffect.none;
        _this.effectImpl = none;
        _this.show = function (data, callback) {
            _this.bubbling('showDialog', _this.entity.name, data, callback);
        };
        _this.hide = function (action) {
            _this.bubbling('hideDialog', _this.entity.name, action || 'close');
        };
        return _this;
    }
    DialogContent.prototype.onModify = function (value, key, oldValue) {
        _super.prototype.onModify.call(this, value, key, oldValue);
        if (key === 'effect') {
            this.effectImpl = effects[value];
        }
    };
    DialogContent.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._closeButton) {
            var buttons = this.entity.getChildrenByName('CloseButton');
            if (buttons.length > 0) {
                this._closeButton = buttons[0].getComponent(CustomButton);
                this._closeButton.onClick.addListener(this.onTapCloseButton, this);
            }
        }
    };
    DialogContent.prototype.onTapCloseButton = function () {
        this.hide();
    };
    DialogContent.prototype.setup = function (data) {
    };
    __decorate([
        dirtyFieldTrigger$4
    ], DialogContent.prototype, "effect", void 0);
    return DialogContent;
}(ScillaComponent));
var effects = {
    none: none,
    fade: fade,
    flew: flew,
    zoom: zoom,
};
var PopupEffect;
(function (PopupEffect) {
    PopupEffect["none"] = "none";
    PopupEffect["fade"] = "fade";
    PopupEffect["flew"] = "flew";
    PopupEffect["zoom"] = "zoom";
})(PopupEffect || (PopupEffect = {}));

var entry_63 = /*#__PURE__*/Object.freeze({
    'default': DialogContent,
    get PopupEffect () { return PopupEffect; }
});

var Popup = (function (_super) {
    __extends(Popup, _super);
    function Popup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.blackLayerDuration = 300;
        _this._dialogStack = [];
        return _this;
    }
    Popup.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._touchInterrupt = this.getComponent(TouchInterrupt);
        this._touchInterrupt.enabled = false;
        var bgRenderer = this._bgRenderer = this.getComponent(RectRenderer);
        bgRenderer.enabled = false;
    };
    Popup.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    Popup.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    Popup.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
    };
    Popup.prototype.setBgVisible = function (visible) {
        var _this = this;
        if (visible) {
            this._bgRenderer.enabled = true;
        }
        this._bgRenderer.alpha = visible ? 0 : 1;
        scilla.createTween(this, this._bgRenderer, true)
            .to({ alpha: visible ? 1 : 0 }, this.blackLayerDuration)
            .call(function () {
            if (!visible) {
                _this._bgRenderer.enabled = false;
            }
        });
    };
    Popup.prototype.getDialogInStack = function (name) {
        var e_1, _a;
        var result;
        try {
            for (var _b = __values(this._dialogStack), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dialog = _c.value;
                if (dialog.name === name) {
                    result = dialog;
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    Popup.prototype.bringToTop = function (dialogConfig) {
        var index = this._dialogStack.indexOf(dialogConfig);
        if (index >= 0) {
            this._dialogStack.splice(index, 1);
        }
        this._dialogStack.push(dialogConfig);
    };
    Popup.prototype.delete = function (dialogConfig) {
        var index = this._dialogStack.indexOf(dialogConfig);
        this._dialogStack.splice(index, 1);
    };
    Popup.prototype.showDialog = function (name, data, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var dialogConfig, dialog, parent, content, transform, effect, effectOptions;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dialogConfig = this.getDialogInStack(name);
                        dialog = this.entity.getChildrenByName(name)[0];
                        if (!dialogConfig) {
                            dialogConfig = {
                                name: name, data: data, callback: callback, dialog: dialog
                            };
                            dialog.enabled = true;
                        }
                        this.bringToTop(dialogConfig);
                        parent = dialog.parent;
                        parent.removeChild(dialog);
                        parent.addChildAt(dialog, parent.children.length);
                        this.setBgVisible(true);
                        this._touchInterrupt.enabled = true;
                        content = dialog.getComponent(DialogContent);
                        content && content.setup(data);
                        transform = dialog.getComponent(Transform);
                        effect = content ? content.effectImpl : none;
                        effectOptions = content ? content.showEffectOptions : null;
                        return [4, effect.show(transform, effectOptions)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    Popup.prototype.hideDialog = function (name, action, data) {
        return __awaiter(this, void 0, void 0, function () {
            var dialogConfig, dialog, transform, content, effect, effectOptions;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dialogConfig = this.getDialogInStack(name);
                        if (!dialogConfig) {
                            return [2];
                        }
                        dialog = this.entity.getChildrenByName(name)[0];
                        this.delete(dialogConfig);
                        if (this._dialogStack.length === 0) {
                            this.setBgVisible(false);
                            this._touchInterrupt.enabled = false;
                        }
                        transform = dialog.getComponent(Transform);
                        content = dialog.getComponent(DialogContent);
                        effect = content ? content.effectImpl : none;
                        effectOptions = content ? content.hideEffectOptions : null;
                        return [4, effect.hide(transform, effectOptions)];
                    case 1:
                        _a.sent();
                        dialog.enabled = false;
                        if (dialogConfig.callback) {
                            dialogConfig.callback(action, data);
                            dialogConfig.callback = null;
                        }
                        return [2];
                }
            });
        });
    };
    Popup.prototype.hideAll = function () {
        var e_2, _a;
        try {
            for (var _b = __values(this._dialogStack), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dialog = _c.value;
                this.hideDialog(dialog.name);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return Popup;
}(ScillaComponent));

var entry_64 = /*#__PURE__*/Object.freeze({
    'default': Popup
});

function callApi(uri, params, method, responseType, ignoreSuccessField) {
    if (params === void 0) { params = null; }
    if (method === void 0) { method = 'post'; }
    if (responseType === void 0) { responseType = 'json'; }
    if (ignoreSuccessField === void 0) { ignoreSuccessField = false; }
    var ts = Date.now() + Math.floor(Math.random() * 9999999);
    var url = uri.indexOf('//') === 0 ? uri : "" + scilla.engine.customConfig.webServiceUrl + uri + "?_=" + ts;
    params = params || {};
    var options = {
        method: method,
    };
    if (!DEBUG) {
        options.credentials = 'include';
    }
    var temp = typeof params === 'string' ? params : scilla.utils.objectStringify(params);
    switch (method.toUpperCase()) {
        case 'GET':
            if (temp && temp.length > 0) {
                url += (url.indexOf('?') < 0 ? '?' : '') + '&' + temp;
            }
            break;
        case 'POST':
            options.body = temp;
            options.headers = {
                'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8',
            };
            break;
    }
    var fetchMethod = responseType == 'jsonp' ? window['fetchJsonp'] : fetch;
    return fetchMethod(url, options)
        .then(function (response) {
        if (response.type === 'opaque') {
            return null;
        }
        return response.text();
    })
        .then(function (response) {
        if (response) {
            var data = void 0;
            switch (responseType) {
                case 'json':
                    try {
                        data = JSON.parse(response);
                    }
                    catch (e) {
                        console.log('decode json failed: ' + url);
                        return Promise.reject({});
                    }
                    if (ignoreSuccessField || data.success) {
                        return {
                            data: data.hasOwnProperty('data') ? data.data : data,
                            origin: data,
                        };
                    }
                    else {
                        return Promise.reject(data.code);
                    }
                case 'html':
                    var html = null;
                    return html;
                case 'txt':
                    return response;
            }
        }
        return Promise.reject();
    });
}
function polling(successFunc, uri, params, maxTimes, delay, abortFunc, method, responseType) {
    if (maxTimes === void 0) { maxTimes = 10; }
    if (delay === void 0) { delay = 500; }
    if (method === void 0) { method = 'POST'; }
    if (responseType === void 0) { responseType = 'json'; }
    return __awaiter(this, void 0, Promise, function () {
        function func() {
            return callApi(uri, params, method, responseType).then(function (data) {
                if (successFunc(data)) {
                    lastData = data;
                    return Promise.reject('success');
                }
            });
        }
        var lastData, needBreak, i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < maxTimes)) return [3, 5];
                    return [4, func().catch(function (e) {
                            if (e === 'success') {
                                needBreak = true;
                            }
                            else {
                                throw e;
                            }
                        })];
                case 2:
                    _a.sent();
                    if (needBreak) {
                        return [3, 5];
                    }
                    if (abortFunc()) {
                        throw new Error('abort');
                    }
                    return [4, scilla.utils.waitPromise(delay)];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    i++;
                    return [3, 1];
                case 5:
                    if (!needBreak) {
                        throw new Error('timeout');
                    }
                    return [2, lastData];
            }
        });
    });
}

var BuriedPoint = (function (_super) {
    __extends(BuriedPoint, _super);
    function BuriedPoint() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BuriedPoint.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (this.dpm && this.dcm && !this._exposured) {
            this.setConfig(this.dpm, this.dcm, true);
        }
    };
    BuriedPoint.prototype.onTouchTap = function (e) {
        _super.prototype.onTouchTap.call(this, e);
        if (this._buriedPointName) {
            logClick(this._buriedPointName);
        }
    };
    BuriedPoint.prototype.setConfig = function (dpm, dcm, needLogExposure) {
        if (needLogExposure === void 0) { needLogExposure = false; }
        this._buriedPointName = 'buried-point-' + Date.now() + Math.floor(Math.random() * 999999);
        addBuriedPointConfig(this._buriedPointName, { dpm: dpm, dcm: dcm });
        if (needLogExposure) {
            logExposure(this._buriedPointName);
            this._exposured = true;
        }
    };
    return BuriedPoint;
}(InteractComponent));
var _buriedPoints = {};
var env;
function initEnv() {
    var cfg = scilla.engine.dataCenter.get('CFG');
    env = {
        app_id: cfg.appId,
        oaid: cfg.opActivityId,
        page_id: 3,
        comp_id: 4,
    };
}
function addBuriedPoints(buriedPoints) {
    for (var name in buriedPoints) {
        _buriedPoints[name] = buriedPoints[name];
    }
}
function addBuriedPointConfig(name, config) {
    var dpm = config.dpm, dcm = config.dcm;
    _buriedPoints[name] = new BuriedPointData(dpm, dcm);
}
function addBuriedPointConfigs(configs) {
    for (var name in configs) {
        addBuriedPointConfig(name, configs[name]);
    }
}
function logExposure(name) {
    return log(name, 'exposure');
}
function logClick(name) {
    return log(name, 'click');
}
function log(name, type) {
    var logPoint = _buriedPoints[name];
    var appId = scilla.engine.dataCenter.get('CFG', 'appId');
    var dpm = logPoint.dpm, dcm = logPoint.dcm;
    return callApi(type == 'exposure' ? '//embedlog.duiba.com.cn/exposure/standard' : '/log/click', {
        dpm: dpm, dcm: dcm, appId: appId
    }, 'get', type == 'exposure' ? 'jsonp' : 'json').catch(function (e) {
    });
}
function fillData(src) {
    var result = src;
    for (var key in env) {
        result = result.replace(key, env[key]);
    }
    return result;
}
var BuriedPointData = (function () {
    function BuriedPointData(dpm, dcm) {
        this.dpm = fillData(dpm);
        this.dcm = fillData(dcm);
    }
    return BuriedPointData;
}());

var entry_27 = /*#__PURE__*/Object.freeze({
    'default': BuriedPoint,
    initEnv: initEnv,
    addBuriedPoints: addBuriedPoints,
    addBuriedPointConfig: addBuriedPointConfig,
    addBuriedPointConfigs: addBuriedPointConfigs,
    logExposure: logExposure,
    logClick: logClick
});

function renderRunCredits(v) {
    var unitName = scilla.engine.dataCenter.get('CFG', 'unitName');
    return Math.floor(v) + unitName;
}
function isWeiXin() {
    var ua = window.navigator.userAgent.toLowerCase();
    return ua.includes('micromessenger');
}
function stringFixed(str, limit, mask) {
    if (limit === void 0) { limit = 6; }
    if (mask === void 0) { mask = '…'; }
    if (str.length > limit) {
        return str.substr(0, limit) + mask;
    }
    return str;
}

var MainController = (function (_super) {
    __extends(MainController, _super);
    function MainController() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MainController.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        scilla.engine.dataCenter.set('CFG', window['CFG']);
        this._toast = this.Toast.getComponent(Toast);
        this._popup = this.Popup.getComponent(Popup);
        initEnv();
        this.broadcast('callApi', 1, 'activityBaseInfo', { opActivityId: this.opActivityId });
    };
    MainController.prototype.onGotActivityBaseInfo = function () {
        this.broadcast('initGameStage');
    };
    MainController.prototype.onActivityBaseInfoError = function (e) {
        console.log(e);
        if (typeof e === 'string') {
            switch (e) {
                case '0100016':
                case '0100014':
                case '0100017':
                    this.showErrorToast(e);
                    break;
                default:
                    this.showNetError();
            }
        }
        else {
            this.showNetError();
        }
    };
    MainController.prototype.showErrorToast = function (e) {
        switch (e) {
            case '0100016':
                this.showToast('活动未开始，暂时无法参与');
                break;
            case '0100014':
            case '0100017':
                this.showToast('活动已结束，无法参与');
                break;
        }
    };
    MainController.prototype.showToast = function (content, duration) {
        this._toast.show({
            content: content,
            duration: duration,
        });
    };
    MainController.prototype.showDialog = function (name, data, callback) {
        this._popup.showDialog(name, data, callback);
    };
    MainController.prototype.hideDialog = function (name, action, data) {
        this._popup.hideDialog(name, action, data);
    };
    MainController.prototype.hideAllDialog = function () {
        this._popup.hideAll();
    };
    MainController.prototype.alert = function (data, callback, callbackDelay) {
        if (callbackDelay === void 0) { callbackDelay = 500; }
        this.showDialog('Alert', data, function (action, data) {
            setTimeout(function () {
                callback(action, data);
            }, callbackDelay);
        });
    };
    MainController.prototype.showLoginAlert = function () {
        var callUpRegistH5Code = scilla.engine.dataCenter.get('CFG', 'callUpRegistH5Code');
        var requirelogin = window['requirelogin'];
        var inWeiXin = isWeiXin();
        this.alert({
            title: "\u554A\u54E6\uFF0C\u4F60\u8FD8\u672A\u767B\u5F55",
            content: "\u767B\u5F55\u540E\u5373\u53EF\u53C2\u4E0E\u6D3B\u52A8",
            button: (inWeiXin ? (callUpRegistH5Code || requirelogin) : requirelogin) ? '立即登录' : null,
        }, function (action) {
            if (action === 'confirm') {
                if (inWeiXin) {
                    if (callUpRegistH5Code) {
                        location.href = callUpRegistH5Code;
                    }
                    else if (requirelogin) {
                        requirelogin();
                    }
                    else {
                        console.log('没有登录方案');
                    }
                }
                else {
                    if (requirelogin) {
                        requirelogin();
                    }
                    else {
                        console.log('没有登录方案');
                    }
                }
            }
        });
    };
    MainController.prototype.showCreditsAlert = function () {
        var unitName = scilla.engine.dataCenter.get('CFG', 'unitName');
        var earnCreditsUrl = scilla.engine.dataCenter.get('CFG', 'earnCreditsUrl');
        this.alert({
            title: "\u554A\u54E6\uFF0C\u5F53\u524D" + unitName + "\u4E0D\u8DB3",
            content: "\u5FEB\u53BB\u9886\u53D6\u66F4\u591A" + unitName + "\u5427",
            button: earnCreditsUrl ? '去做任务' : null,
        }, function (action) {
            if (action === 'confirm') {
                location.href = earnCreditsUrl;
            }
        });
    };
    MainController.prototype.showNetError = function (action) {
        this.showDialog('Alert', { title: '网络异常', content: '请检查网络后重试!', button: '重新加载', showCloseButton: false }, function () {
            if (typeof action === 'function') {
                action();
            }
            else {
                action = action || 'refresh';
                switch (action) {
                    case 'back':
                        history.back();
                        break;
                    case 'refresh':
                        location.reload();
                        break;
                }
            }
        });
    };
    return MainController;
}(ScillaComponent));

var entry_23 = /*#__PURE__*/Object.freeze({
    'default': MainController
});

var RequestMethod;
(function (RequestMethod) {
    RequestMethod["GET"] = "GET";
    RequestMethod["POST"] = "POST";
    RequestMethod["PUT"] = "PUT";
    RequestMethod["DELETE"] = "DELETE";
})(RequestMethod || (RequestMethod = {}));
var ApiComponent = (function (_super) {
    __extends(ApiComponent, _super);
    function ApiComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.method = RequestMethod.POST;
        _this.onResponse = new scilla.ScillaEvent();
        _this.onError = new scilla.ScillaEvent();
        _this.onFinish = new scilla.ScillaEvent();
        _this.autoCall = false;
        return _this;
    }
    ApiComponent.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (this.autoCall) {
            this.execute();
        }
    };
    ApiComponent.prototype.execute = function (paramsInput) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this._args = args;
                return [2];
            });
        });
    };
    ApiComponent.prototype.onGotResponse = function (response) {
        var _a;
        if (this.name) {
            scilla.engine.dataCenter.set('API', this.name, response.data);
        }
        if (this._args && this._args.length > 0) {
            (_a = this.onResponse).invoke.apply(_a, __spread([response.data], this._args));
        }
        else {
            this.onResponse.invoke(response.data);
        }
        this.onCallFinish();
    };
    ApiComponent.prototype.onGotError = function (e) {
        var _a;
        if (this._args && this._args.length > 0) {
            (_a = this.onError).invoke.apply(_a, __spread([e], this._args));
        }
        else {
            this.onError.invoke(e);
        }
        this.onCallFinish();
    };
    ApiComponent.prototype.onCallFinish = function () {
        var _a;
        if (this._args && this._args.length > 0) {
            (_a = this.onFinish).invoke.apply(_a, __spread(this._args));
        }
        else {
            this.onFinish.invoke();
        }
    };
    return ApiComponent;
}(ScillaComponent));

var entry_24 = /*#__PURE__*/Object.freeze({
    get RequestMethod () { return RequestMethod; },
    'default': ApiComponent
});

var SampleApi = (function (_super) {
    __extends(SampleApi, _super);
    function SampleApi() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.ignoreSuccessField = false;
        return _this;
    }
    SampleApi.prototype.callApi = function (name, paramsInput) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(this.name == name)) return [3, 2];
                        return [4, this.execute.apply(this, __spread([paramsInput], args))];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2];
                }
            });
        });
    };
    SampleApi.prototype.execute = function (paramsInput) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            var params, _a, uri, method, response, e_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, _super.prototype.execute.apply(this, __spread([paramsInput], args))];
                    case 1:
                        _b.sent();
                        params = {};
                        if (this.params) {
                            scilla.utils.injectProp(params, this.params);
                        }
                        if (paramsInput) {
                            scilla.utils.injectProp(params, paramsInput);
                        }
                        _a = this, uri = _a.uri, method = _a.method;
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 4, , 5]);
                        return [4, callApi(uri, params, method, 'json', this.ignoreSuccessField)];
                    case 3:
                        response = _b.sent();
                        this.onGotResponse(response);
                        return [2, response.data];
                    case 4:
                        e_1 = _b.sent();
                        this.onGotError(e_1);
                        return [3, 5];
                    case 5: return [2];
                }
            });
        });
    };
    return SampleApi;
}(ApiComponent));

var entry_25 = /*#__PURE__*/Object.freeze({
    'default': SampleApi
});

var SamplePollingApi = (function (_super) {
    __extends(SamplePollingApi, _super);
    function SamplePollingApi() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.maxTimes = 5;
        _this.delay = 500;
        _this._abortFlag = false;
        _this.abortFunc = function () {
            return _this._abortFlag;
        };
        _this.successFunc = function (response) {
            var _a = _this, successField = _a.successField, successValues = _a.successValues;
            var v = successField ? response.data[successField] : response.data;
            return successValues ? successValues.indexOf(v) >= 0 : false;
        };
        return _this;
    }
    SamplePollingApi.prototype.callApi = function (name, paramsInput) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(this.name == name)) return [3, 2];
                        return [4, this.execute.apply(this, __spread([paramsInput], args))];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2: return [2];
                }
            });
        });
    };
    SamplePollingApi.prototype.abortCallApi = function (name) {
        if (this.name == name) {
            this._abort();
        }
    };
    SamplePollingApi.prototype.execute = function (paramsInput) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        return __awaiter(this, void 0, void 0, function () {
            var params, _a, uri, method, response, e_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4, _super.prototype.execute.apply(this, __spread([paramsInput], args))];
                    case 1:
                        _b.sent();
                        this._abortFlag = false;
                        params = {};
                        if (this.params) {
                            scilla.utils.injectProp(params, this.params);
                        }
                        if (paramsInput) {
                            scilla.utils.injectProp(params, paramsInput);
                        }
                        _a = this, uri = _a.uri, method = _a.method;
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 4, , 5]);
                        return [4, polling(this.successFunc, uri, params, this.maxTimes, this.delay, this.abortFunc, method)];
                    case 3:
                        response = _b.sent();
                        this.onGotResponse(response);
                        return [2, response.data];
                    case 4:
                        e_1 = _b.sent();
                        this.onGotError(e_1);
                        return [3, 5];
                    case 5: return [2];
                }
            });
        });
    };
    SamplePollingApi.prototype._abort = function () {
        this._abortFlag = true;
    };
    return SamplePollingApi;
}(ApiComponent));

var entry_26 = /*#__PURE__*/Object.freeze({
    'default': SamplePollingApi
});

function getTextureNameSample(second) {
    return second + ".png";
}
var CountDown = (function (_super) {
    __extends(CountDown, _super);
    function CountDown() {
        var _this = _super.call(this) || this;
        _this.onComplete = new scilla.ScillaEvent();
        _this.interval = 1000;
        _this.hideWhenStop = true;
        _this.onTimer = function () {
            if (_this._remainSeconds <= 0) {
                _this.onComplete.invoke();
                _this.stop();
                return;
            }
            var sheet = _this.numberSheet;
            _this._textureRenderer.texture = sheet.getTexture(_this.$getTextureName(_this._remainSeconds));
            _this._remainSeconds--;
        };
        _this.$getTextureName = getTextureNameSample;
        return _this;
    }
    CountDown.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._textureRenderer = this.getComponent(TextureRenderer);
    };
    CountDown.prototype.play = function () {
        if (this.seconds > 0) {
            this.entity.enabled = true;
            this._remainSeconds = this.seconds;
            this.stop();
            this.onTimer();
            this._timer = setInterval(this.onTimer, this.interval);
        }
    };
    CountDown.prototype.stop = function () {
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
            if (this.hideWhenStop) {
                this.entity.enabled = false;
            }
        }
    };
    return CountDown;
}(ScillaComponent));

var entry_28 = /*#__PURE__*/Object.freeze({
    'default': CountDown
});

var DotWaiting = (function (_super) {
    __extends(DotWaiting, _super);
    function DotWaiting() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.interval = 300;
        _this._dots = [];
        return _this;
    }
    DotWaiting.prototype.onAwake = function () {
        var e_1, _a;
        _super.prototype.onAwake.call(this);
        this._reset = true;
        this._dots.splice(0);
        try {
            for (var _b = __values(this.entity.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var child = _c.value;
                this._dots.push(child.getComponent(GraphicRenderer));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    DotWaiting.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
        if (this._reset) {
            this._reset = false;
            this._startTime = t;
        }
        var index = Math.floor((t - this._startTime) / this.interval) % this._dots.length;
        if (this._index !== index) {
            for (var i = 0, li = this._dots.length; i < li; i++) {
                var dot = this._dots[i];
                dot.fillColor = index === i ? this.activeColor : this.inativeColor;
            }
        }
    };
    return DotWaiting;
}(ScillaComponent));

var entry_29 = /*#__PURE__*/Object.freeze({
    'default': DotWaiting
});

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics$1 = function(d, b) {
    extendStatics$1 = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return extendStatics$1(d, b);
};

function __extends$1(d, b) {
    extendStatics$1(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

function __values$1(o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
}

function lerp(begin, end, t, allowOutOfBounds) {
    if (allowOutOfBounds === void 0) { allowOutOfBounds = false; }
    var type = typeof begin;
    if (type !== typeof end) {
        console.error('begin and end need same type');
    }
    if (!allowOutOfBounds) {
        t = Math.max(0, Math.min(1, t));
    }
    var sign = end - begin;
    sign = sign > 0 ? 1 : (sign < 0 ? -1 : 0);
    var distance = Math.abs(end - begin);
    return begin + distance * t * sign;
}
function lerpObj(begin, end, t, fields, allowOutOfBounds) {
    var e_1, _a;
    if (allowOutOfBounds === void 0) { allowOutOfBounds = false; }
    var type = typeof begin;
    if (type !== typeof end) {
        console.error('begin and end need same type');
    }
    var temp = {};
    try {
        for (var fields_1 = __values$1(fields), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
            var field = fields_1_1.value;
            temp[field] = lerp(begin[field], end[field], t, allowOutOfBounds);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (fields_1_1 && !fields_1_1.done && (_a = fields_1.return)) _a.call(fields_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return temp;
}

function injectProp(target, data, callback, ignoreMethod, ignoreNull) {
    if (ignoreMethod === void 0) { ignoreMethod = true; }
    if (ignoreNull === void 0) { ignoreNull = true; }
    if (!target || !data) {
        return false;
    }
    var result = false;
    for (var key in data) {
        var value = data[key];
        if ((!ignoreMethod || typeof value != 'function') && (!ignoreNull || value != null) && key.indexOf('_') !== 0 && key.indexOf('$') !== 0) {
            if (callback) {
                callback(target, key, value);
            }
            else {
                try {
                    target[key] = value;
                }
                catch (e) {
                }
            }
            result = true;
        }
    }
    return result;
}

var HASH_CODE_INK = 0;
function getHashCode() {
    return ++HASH_CODE_INK;
}
var HashObject = (function () {
    function HashObject() {
        this._hashCode = getHashCode();
    }
    Object.defineProperty(HashObject.prototype, "hashCode", {
        get: function () {
            return this._hashCode;
        },
        enumerable: true,
        configurable: true
    });
    return HashObject;
}());

var STATUS;
(function (STATUS) {
    STATUS[STATUS["IDLE"] = 0] = "IDLE";
    STATUS[STATUS["PENDING"] = 1] = "PENDING";
    STATUS[STATUS["DO_SET"] = 2] = "DO_SET";
    STATUS[STATUS["DO_TO"] = 3] = "DO_TO";
    STATUS[STATUS["DO_WAIT"] = 4] = "DO_WAIT";
    STATUS[STATUS["DO_CALL"] = 5] = "DO_CALL";
})(STATUS || (STATUS = {}));
function injectChildProps(target, key, value) {
    if (typeof value === 'object') {
        injectProp(target[key], value);
    }
    else {
        target[key] = value;
    }
}
function killTweens(target) {
    var e_1, _a;
    var tweens = target['tweens'];
    if (tweens) {
        try {
            for (var tweens_1 = __values$1(tweens), tweens_1_1 = tweens_1.next(); !tweens_1_1.done; tweens_1_1 = tweens_1.next()) {
                var tween = tweens_1_1.value;
                tween.stop();
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (tweens_1_1 && !tweens_1_1.done && (_a = tweens_1.return)) _a.call(tweens_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        tweens.splice(0);
    }
}
function addTween(target, tween) {
    var tweens = target['tweens'];
    if (!tweens) {
        tweens = target['tweens'] = [];
    }
    tweens.push(tween);
}
var Tween = (function (_super) {
    __extends$1(Tween, _super);
    function Tween(host, target, options, plugins) {
        if (plugins === void 0) { plugins = []; }
        var _this = _super.call(this) || this;
        _this._queue = [];
        _this.loopCounting = 0;
        _this.status = STATUS.IDLE;
        _this.onUpdate = function (t) {
            _this.t = t;
            switch (_this.status) {
                case STATUS.DO_TO:
                    var _a = _this, target = _a.target, startTime = _a.startTime, fromProps = _a.fromProps, toProps = _a.toProps, duration = _a.duration, ease = _a.ease;
                    var passTime = t - startTime;
                    var timeRatio = Math.min(1, passTime / duration);
                    var ratio = timeRatio;
                    if (ease) {
                        ratio = ease(ratio);
                    }
                    for (var key in fromProps) {
                        var toValue = toProps[key];
                        var fromValue = fromProps[key];
                        var currentValue = void 0;
                        if (timeRatio < 1) {
                            currentValue = _this.resolveLerp(fromValue, toValue, ratio);
                        }
                        else {
                            currentValue = toValue;
                        }
                        if (typeof currentValue === 'object') {
                            injectProp(target[key], currentValue);
                        }
                        else {
                            target[key] = currentValue;
                        }
                    }
                    if (timeRatio >= 1) {
                        _this._doNextAction();
                    }
                    break;
                case STATUS.DO_WAIT:
                    var _b = _this, startTime = _b.startTime, duration = _b.duration;
                    var passTime = t - startTime;
                    if (passTime > duration) {
                        _this._doNextAction();
                    }
                    break;
            }
        };
        _this._doPlay = function (resetLoopCounting) {
            addTween(_this.target, _this);
            _this._start(resetLoopCounting);
        };
        _this._readyStart = function (t) {
            _this.t = t;
            _this._doStart();
        };
        _this._doNextAction = function () {
            if (_this.step < _this._queue.length) {
                var action = _this._queue[_this.step++];
                switch (action.action) {
                    case 'set':
                        _this._set(action.props);
                        break;
                    case 'to':
                        if (action.duration > 0) {
                            _this._to(action.props, action.duration, action.ease);
                        }
                        else {
                            _this._set(action.props);
                        }
                        break;
                    case 'wait':
                        _this._wait(action.duration);
                        break;
                    case 'call':
                        _this._call(action.func, action.thisObj, action.params);
                        break;
                }
            }
            else {
                _this._onEnd();
            }
        };
        _this.host = host;
        _this.target = target;
        _this.loop = options ? options.loop : 0;
        _this.autoPlay = options ? (options.hasOwnProperty('autoPlay') ? options.autoPlay : true) : true;
        _this.fields = options ? options.fields : null;
        _this.onLoopComplete = options ? options.onLoopComplete : null;
        _this.onComplete = options ? options.onComplete : null;
        _this.plugins = plugins;
        if (options && options.initFields && options.initFields.length > 0) {
            _this.initProps = _this.getInitProps(options.initFields);
        }
        return _this;
    }
    Object.defineProperty(Tween.prototype, "queue", {
        get: function () {
            return this._queue;
        },
        enumerable: true,
        configurable: true
    });
    Tween.prototype.resolveLerp = function (fromValue, toValue, ratio) {
        var e_2, _a;
        var currentValue;
        if (this.plugins.length > 0) {
            try {
                for (var _b = __values$1(this.plugins), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var plugin = _c.value;
                    currentValue = plugin.resolveLerp(fromValue, toValue, ratio, true);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
        else {
            if (typeof toValue == 'object') {
                var fields = this.fields;
                currentValue = lerpObj(fromValue, toValue, ratio, fields || Object.keys(toValue), true);
            }
            else {
                currentValue = lerp(fromValue, toValue, ratio, true);
            }
        }
        return currentValue;
    };
    Tween.prototype.getInitProps = function (fields) {
        var e_3, _a;
        var props = {};
        try {
            for (var fields_1 = __values$1(fields), fields_1_1 = fields_1.next(); !fields_1_1.done; fields_1_1 = fields_1.next()) {
                var field = fields_1_1.value;
                if (field in this.target) {
                    var value = this.target[field];
                    if (typeof value === 'object') {
                        if (value.clone) {
                            value = value.clone();
                        }
                        else {
                            injectProp(props[field] = {}, this.target[field]);
                        }
                    }
                    props[field] = value;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (fields_1_1 && !fields_1_1.done && (_a = fields_1.return)) _a.call(fields_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return props;
    };
    Tween.prototype.set = function (props, immediately) {
        if (immediately === void 0) { immediately = false; }
        this._queue.push({ action: 'set', props: props });
        if (this.autoPlay) {
            this._start();
        }
        if (immediately) {
            this._set(props, immediately);
        }
        return this;
    };
    Tween.prototype.to = function (props, duration, ease) {
        this._queue.push({ action: 'to', props: props, duration: duration, ease: ease });
        if (this.autoPlay) {
            this._start();
        }
        return this;
    };
    Tween.prototype.wait = function (duration) {
        this._queue.push({ action: 'wait', duration: duration });
        if (this.autoPlay) {
            this._start();
        }
        return this;
    };
    Tween.prototype.call = function (func, thisObj, params) {
        this._queue.push({ action: 'call', func: func, thisObj: thisObj, params: params });
        if (this.autoPlay) {
            this._start();
        }
        return this;
    };
    Tween.prototype.play = function (override, delay, resetLoopCounting) {
        if (override === void 0) { override = false; }
        if (delay === void 0) { delay = 0; }
        if (resetLoopCounting === void 0) { resetLoopCounting = true; }
        if (override) {
            killTweens(this.target);
        }
        if (delay > 0) {
            setTimeout(this._doPlay, delay, resetLoopCounting);
        }
        else {
            this._doPlay(resetLoopCounting);
        }
    };
    Tween.prototype.stop = function () {
        this.status = STATUS.IDLE;
        this.host.cancelOnNextTick(this.onUpdate);
    };
    Tween.prototype.getPromise = function () {
        var _this = this;
        return new Promise(function (resolve) {
            _this.promise = { resolve: resolve };
        });
    };
    Tween.prototype._set = function (props, immediately) {
        if (immediately === void 0) { immediately = false; }
        injectProp(this.target, props, injectChildProps);
        if (!immediately) {
            this.status = STATUS.DO_SET;
            this._doNextAction();
        }
    };
    Tween.prototype._to = function (props, duration, ease) {
        this.status = STATUS.DO_TO;
        this.startTime = this.t;
        this.fromProps = {};
        for (var key in props) {
            var value = this.target[key];
            if (typeof value === 'object') {
                if (value.clone) {
                    value = value.clone();
                }
                else {
                    injectProp(props[key] = {}, this.target[key]);
                }
            }
            this.fromProps[key] = value;
        }
        this.toProps = {};
        injectProp(this.toProps, props);
        this.ease = ease;
        this.duration = duration;
    };
    Tween.prototype._wait = function (duration) {
        this.status = STATUS.DO_WAIT;
        this.startTime = this.t;
        this.duration = duration;
    };
    Tween.prototype._call = function (func, thisObj, params) {
        this.status = STATUS.DO_CALL;
        func.apply(thisObj || this.host, params);
        this._doNextAction();
    };
    Tween.prototype._start = function (resetLoopCounting) {
        if (resetLoopCounting === void 0) { resetLoopCounting = true; }
        this.status = STATUS.PENDING;
        if (resetLoopCounting) {
            this.loopCounting = 0;
        }
        this.host.callOnNextTick(this._readyStart);
        this.host.callOnNextTick(this.onUpdate, false);
    };
    Tween.prototype._doStart = function () {
        if (this.status == STATUS.IDLE) {
            return;
        }
        this.step = 0;
        this.loopCounting++;
        if (this.loopCounting > 1 && this.initProps) {
            injectProp(this.target, this.initProps, injectChildProps);
        }
        setTimeout(this._doNextAction);
    };
    Tween.prototype._onEnd = function () {
        this.onLoopComplete && this.onLoopComplete();
        if (this.loop < 0) {
            this._doStart();
        }
        else if (this.loopCounting < this.loop) {
            this._doStart();
        }
        else {
            this.status = STATUS.IDLE;
            this.onComplete && this.onComplete();
            this.promise && this.promise.resolve();
            this.promise = null;
        }
    };
    return Tween;
}(HashObject));

var FloatMissing = (function (_super) {
    __extends(FloatMissing, _super);
    function FloatMissing() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.wait = 500;
        _this.delay = 0;
        _this.endPos = new scilla.Vector2D(0, -100);
        _this.onTweenComplete = function () {
            if (_this._tweenResolve) {
                _this._tweenResolve();
                _this._tweenResolve = null;
            }
        };
        return _this;
    }
    FloatMissing.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._tween) {
            this.init();
            this._tween = scilla.createTween(this, this.transform, false, {
                autoPlay: false,
                initFields: ['position', 'alpha', 'scale'],
                onComplete: this.onTweenComplete
            })
                .wait(this.delay)
                .to({ scale: { x: 1, y: 1 } }, 500, scilla.ease.backOut)
                .wait(this.wait)
                .to({ alpha: 0, position: this.endPos.toObj() }, 300);
        }
    };
    FloatMissing.prototype.init = function () {
        this.transform.alpha = 1;
        this.transform.scale.setXY(0, 0);
    };
    FloatMissing.prototype.play = function () {
        var _this = this;
        return new Promise(function (resolve) {
            _this._tweenResolve = resolve;
            _this._tween.play(true, 0, false);
        });
    };
    FloatMissing.prototype.stop = function () {
        killTweens(this.transform);
    };
    return FloatMissing;
}(ScillaComponent));

var entry_30 = /*#__PURE__*/Object.freeze({
    'default': FloatMissing
});

var FlySequence = (function (_super) {
    __extends(FlySequence, _super);
    function FlySequence() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.count = 10;
        _this.fromPos = new scilla.Vector2D();
        _this.toPos = new scilla.Vector2D();
        _this.toScale = new scilla.Vector2D(0.3, 0.3);
        _this.duration = 3000;
        _this.delay = 500;
        _this.itemInterval = 100;
        _this.hideWhenComplete = true;
        _this.offset = 1;
        _this.onComplete = new scilla.ScillaEvent();
        _this._items = [];
        _this.onDelay = function () {
            _this._timer = setInterval(function () {
                if (_this._counting > _this.count - 1) {
                    _this.stop(false);
                    _this._flyItem(_this._items[0], _this.onEnd);
                    return;
                }
                _this._playItem(_this._counting);
                _this._counting++;
            }, _this.itemInterval);
        };
        _this.onEnd = function () {
            _this.onComplete.invoke();
        };
        return _this;
    }
    FlySequence.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (this._items.length === 0) {
            this._itemDuration = this.duration - this.count * this.itemInterval - this.delay;
            for (var i = 0; i < this.count; i++) {
                var itemEntity = scilla.instantiate(this.itemPrefab);
                itemEntity.enabled = false;
                this.entity.addChild(itemEntity);
                var transform = itemEntity.getComponent(Transform);
                this._items.push(transform);
            }
        }
    };
    FlySequence.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    FlySequence.prototype.play = function () {
        this.stop();
        if (this.ToEntity) {
            this.toPos = this.transform.globalPositionToLocal(this.ToEntity.getComponent(Transform).globalPosition);
        }
        var first = this._items[0];
        first.entity.enabled = true;
        first.position.copyFrom(this.fromPos);
        first.scale.setXY(1, 1);
        this._counting = 1;
        this._timerDelay = setTimeout(this.onDelay, this.delay);
    };
    FlySequence.prototype.stop = function (hidden) {
        var e_1, _a;
        if (hidden === void 0) { hidden = true; }
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
        }
        if (this._timerDelay) {
            clearTimeout(this._timerDelay);
            this._timerDelay = null;
        }
        if (hidden) {
            try {
                for (var _b = __values(this._items), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    item.entity.enabled = false;
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    };
    FlySequence.prototype._playItem = function (index) {
        var item = this._items[index];
        item.entity.enabled = true;
        item.position.copyFrom(this.fromPos);
        item.scale.setXY(0, 0);
        this._flyItem(item);
    };
    FlySequence.prototype._flyItem = function (item, callback) {
        var _this = this;
        var itemDuration = this._itemDuration;
        scilla.createTween(this, item.scale, false)
            .to({ x: 1, y: 1 }, itemDuration * 0.1)
            .wait(itemDuration * 0.4)
            .to(this.toScale.toObj(), itemDuration * 0.5);
        scilla.createTween(this, item.position)
            .to({ x: this.toPos.x }, itemDuration);
        var easeFuncCreator = Math.random() > 0.5 ? scilla.ease.getPowOut : scilla.ease.getPowIn;
        var easeFunc = easeFuncCreator(Math.random() + this.offset);
        scilla.createTween(this, item.position)
            .to({ y: this.toPos.y }, itemDuration, easeFunc)
            .call(function () {
            if (_this.hideWhenComplete) {
                item.entity.enabled = false;
            }
            callback && callback();
        });
    };
    return FlySequence;
}(ScillaComponent));

var entry_31 = /*#__PURE__*/Object.freeze({
    'default': FlySequence
});

var DIR;
(function (DIR) {
    DIR[DIR["UP"] = 0] = "UP";
    DIR[DIR["DOWN"] = 1] = "DOWN";
})(DIR || (DIR = {}));
var LabelCarousel = (function (_super) {
    __extends(LabelCarousel, _super);
    function LabelCarousel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.offset = 40;
        _this.interval = 1000;
        _this.scrollDuration = 500;
        _this.dir = DIR.UP;
        _this.autoPlay = false;
        _this._playing = false;
        _this._index = 0;
        _this._labels = [];
        return _this;
    }
    LabelCarousel.prototype.onAwake = function () {
        var e_1, _a;
        _super.prototype.onAwake.call(this);
        var _b = this, _labels = _b._labels, entity0 = _b.entity0, entity1 = _b.entity1, offset = _b.offset, dir = _b.dir;
        var entities = [entity0, entity1];
        try {
            for (var entities_1 = __values(entities), entities_1_1 = entities_1.next(); !entities_1_1.done; entities_1_1 = entities_1.next()) {
                var entity = entities_1_1.value;
                var transform = entity.getComponent(Transform);
                var textRenderer = entity.getComponent(TextRenderer);
                transform.position.y = offset * (dir === DIR.UP ? -1 : 1);
                transform.alpha = 0;
                _labels.push({
                    transform: transform,
                    textRenderer: textRenderer
                });
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (entities_1_1 && !entities_1_1.done && (_a = entities_1.return)) _a.call(entities_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (this.autoPlay) {
            this.play();
        }
    };
    LabelCarousel.prototype.play = function () {
        var _this = this;
        this.playNext();
        this.stop();
        this._timer = setInterval(function () {
            _this.playNext();
        }, this.interval);
        this._playing = true;
    };
    LabelCarousel.prototype.stop = function () {
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
        }
        this._playing = false;
    };
    LabelCarousel.prototype.updateText = function (textRenderer) {
        var text = this.getTextFunc ? this.getTextFunc() : null;
        if (text) {
            textRenderer.text = text;
        }
    };
    LabelCarousel.prototype.playNext = function () {
        var _a = this, _labels = _a._labels, _index = _a._index, scrollDuration = _a.scrollDuration, offset = _a.offset, dir = _a.dir;
        var nextLabel = _labels[_index % 2];
        var sign = dir === DIR.UP ? -1 : 1;
        this.updateText(nextLabel.textRenderer);
        scilla.createTween(this, nextLabel.transform, true)
            .set({ position: { y: offset * sign * -1 } })
            .to({ position: { y: 0 }, alpha: 1 }, scrollDuration, scilla.ease.cubicOut);
        if (_index > 0) {
            var lastLabel = _labels[(_index + 1) % 2];
            scilla.createTween(this, lastLabel.transform, true)
                .to({ position: { y: offset * sign }, alpha: 0 }, scrollDuration, scilla.ease.cubicOut);
        }
        this._index++;
    };
    return LabelCarousel;
}(ScillaComponent));

var entry_32 = /*#__PURE__*/Object.freeze({
    get DIR () { return DIR; },
    'default': LabelCarousel
});

function renderSimple(v) {
    return Math.floor(v).toString();
}
var RunNumber = (function (_super) {
    __extends(RunNumber, _super);
    function RunNumber() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.duration = 3000;
        _this.onComplete = new scilla.ScillaEvent();
        _this.$renderFunc = renderSimple;
        return _this;
    }
    RunNumber.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._textRenderer = this.getComponent(TextRenderer);
    };
    RunNumber.prototype.play = function (to, from) {
        var _this = this;
        if (!this._textRenderer) {
            return Promise.resolve();
        }
        from = from === undefined ? parseFloat(this._textRenderer.text) : from;
        return new Promise(function (resolve) {
            scilla.createTween(_this, _this, true)
                .set({ t: from })
                .to({ t: to }, _this.duration)
                .call(function () {
                resolve();
                _this.onComplete.invoke();
            });
        });
    };
    Object.defineProperty(RunNumber.prototype, "t", {
        get: function () {
            return this._t;
        },
        set: function (v) {
            this._t = v;
            this._textRenderer.text = this.$renderFunc(v);
        },
        enumerable: true,
        configurable: true
    });
    return RunNumber;
}(ScillaComponent));

var entry_33 = /*#__PURE__*/Object.freeze({
    'default': RunNumber
});

var WaveController = (function (_super) {
    __extends(WaveController, _super);
    function WaveController() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.playWhenInteractable = true;
        _this.stopWhenUninteractable = true;
        _this.stopWhenTouchBegin = true;
        _this.playWhenTouchEnd = true;
        _this.touchBeginFlag = false;
        return _this;
    }
    WaveController.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._wave = this.getComponent(Wave);
    };
    WaveController.prototype.onTouchBegin = function (e) {
        _super.prototype.onTouchBegin.call(this, e);
        this.touchBeginFlag = true;
        if (this.stopWhenTouchBegin) {
            if (this._wave)
                this._wave.stop(true);
        }
    };
    WaveController.prototype.onGlobalTouchEnd = function (e) {
        if (this.touchBeginFlag) {
            this.touchBeginFlag = false;
            if (this.playWhenTouchEnd) {
                if (this._wave)
                    this._wave.play();
            }
        }
    };
    WaveController.prototype.onInteractableChanged = function (interactable) {
        _super.prototype.onInteractableChanged.call(this, interactable);
        if (interactable && this.playWhenInteractable) {
            if (this._wave)
                this._wave.play();
        }
        if (!interactable && this.stopWhenUninteractable) {
            if (this._wave)
                this._wave.stop();
        }
    };
    return WaveController;
}(InteractComponent));

var entry_35 = /*#__PURE__*/Object.freeze({
    'default': WaveController
});

var AlertDialogContent = (function (_super) {
    __extends(AlertDialogContent, _super);
    function AlertDialogContent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AlertDialogContent.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._titleLabel = this.Title.getComponent(TextRenderer);
        this._contentLabel = this.Content.getComponent(TextRenderer);
        this._contentTransform = this.Content.getComponent(Transform);
        if (this.ConfirmButton) {
            this._confirmButtonLabel = this.ConfirmButton.getChildrenByName('Label')[0].getComponent(TextRenderer);
        }
    };
    AlertDialogContent.prototype.setup = function (data) {
        if (data === void 0) { data = {}; }
        var _a = data.title, title = _a === void 0 ? 'Alert' : _a, _b = data.content, content = _b === void 0 ? '' : _b, _c = data.button, button = _c === void 0 ? 'Confirm' : _c, _d = data.showCloseButton, showCloseButton = _d === void 0 ? true : _d;
        this._titleLabel.text = title;
        this._contentLabel.text = content;
        this._closeButton.entity.enabled = showCloseButton;
        if (button) {
            this._confirmButtonLabel.text = button;
        }
        this._contentTransform.position.y = button ? -30 : 40;
        this.ConfirmButton.enabled = !!button;
    };
    AlertDialogContent.prototype.onClickConfirmButton = function () {
        this.hide('confirm');
    };
    return AlertDialogContent;
}(DialogContent));

var entry_36 = /*#__PURE__*/Object.freeze({
    'default': AlertDialogContent
});

var dirtyFieldDetector$5 = scilla.decorators.dirtyFieldDetector;
var TwoLinesButton = (function (_super) {
    __extends(TwoLinesButton, _super);
    function TwoLinesButton() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TwoLinesButton.prototype.onAwake = function () {
        if (!this.label0TextRenderer) {
            this.label0TextRenderer = this.label0Entity.getComponent(TextRenderer);
            this.label1TextRenderer = this.label1Entity.getComponent(TextRenderer);
        }
        _super.prototype.onAwake.call(this);
    };
    TwoLinesButton.prototype.onUpdate = function (t) {
        if (this['dirty']) {
            this.label0TextRenderer.text = this.label0;
            this.label1TextRenderer.text = this.label1;
        }
        _super.prototype.onUpdate.call(this, t);
    };
    TwoLinesButton.prototype.changeTexture = function (status) {
        _super.prototype.changeTexture.call(this, status);
        if (this.label0TextRenderer) {
            this.label0TextRenderer.fillColor = this.interactable ? this.upLabelColor : this.disabledLabelColor;
            this.label1TextRenderer.fillColor = this.interactable ? this.upLabelColor : this.disabledLabelColor;
        }
    };
    __decorate([
        dirtyFieldDetector$5
    ], TwoLinesButton.prototype, "label0", void 0);
    __decorate([
        dirtyFieldDetector$5
    ], TwoLinesButton.prototype, "label1", void 0);
    return TwoLinesButton;
}(CustomButton));

var entry_58 = /*#__PURE__*/Object.freeze({
    'default': TwoLinesButton
});

var PKChallenge = (function (_super) {
    __extends(PKChallenge, _super);
    function PKChallenge() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKChallenge.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._buttonPK = this.ButtonPK.getComponent(TwoLinesButton);
    };
    PKChallenge.prototype.setup = function (data) {
        _super.prototype.setup.call(this, data);
        var _a = this.activityBaseInfo, pkExpend = _a.pkExpend, machineNickname = _a.machineNickname;
        this._buttonPK.label1 = renderRunCredits(pkExpend) + '/次';
        this.Content.getComponent(TextRenderer).text = "\u6211\u662F" + machineNickname;
    };
    PKChallenge.prototype.onClickConfirm = function () {
        this.hide('accept');
    };
    return PKChallenge;
}(DialogContent));

var entry_37 = /*#__PURE__*/Object.freeze({
    'default': PKChallenge
});

var PKMatching = (function (_super) {
    __extends(PKMatching, _super);
    function PKMatching() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onMatched = function () {
            _this._titleRenderer.text = '匹配成功';
            _this.AvatarOther.enabled = true;
            _this.AvatarWaiting.enabled = false;
            setTimeout(_this.hide, 1000, 'success');
        };
        return _this;
    }
    PKMatching.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._titleRenderer = this.Title.getComponent(TextRenderer);
        this._selfNameRenderer = this.SelfName.getComponent(TextRenderer);
        this._otherNameRenderer = this.OtherName.getComponent(TextRenderer);
    };
    PKMatching.prototype.setup = function (data) {
        var channel = data.channel;
        this._titleRenderer.text = '正在匹配对手…';
        this._selfNameRenderer.text = stringFixed(this.userNickname);
        this._otherNameRenderer.text = stringFixed(this.otherName);
        this.AvatarOther.enabled = false;
        this.AvatarWaiting.enabled = true;
        this.CloseButton.enabled = false;
        this.stop();
        if (channel === 1) {
            this.onMatched();
        }
        else {
            this._timer = setTimeout(this.onMatched, Math.random() * 2000 + 2000);
        }
    };
    PKMatching.prototype.stop = function () {
        if (this._timer) {
            clearTimeout(this._timer);
            this._timer = null;
        }
    };
    PKMatching.prototype.onTapCloseButton = function () {
        _super.prototype.onTapCloseButton.call(this);
        this.stop();
    };
    return PKMatching;
}(DialogContent));

var entry_38 = /*#__PURE__*/Object.freeze({
    'default': PKMatching
});

var TimesCard = (function (_super) {
    __extends(TimesCard, _super);
    function TimesCard() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TimesCard.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._labelRenderer = this.Label.getComponent(TextRenderer);
    };
    TimesCard.prototype.setTimes = function (v) {
        this._labelRenderer.text = 'X' + v;
    };
    TimesCard.prototype.playShow = function (v) {
        var _this = this;
        if (v !== undefined) {
            this.setTimes(v);
        }
        this.entity.enabled = true;
        return new Promise(function (resolve) {
            scilla.createTween(_this, _this.transform, true)
                .set({ scale: { x: 2, y: 2 }, alpha: 0 }, true)
                .to({ scale: { x: 1, y: 1 }, alpha: 1 }, 500, scilla.ease.backOut)
                .wait(500)
                .to({ alpha: 0 }, 500)
                .call(resolve);
        });
    };
    return TimesCard;
}(ScillaComponent));

var entry_57 = /*#__PURE__*/Object.freeze({
    'default': TimesCard
});

var PKResultAnimSide = (function (_super) {
    __extends(PKResultAnimSide, _super);
    function PKResultAnimSide() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKResultAnimSide.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._labelName) {
            this._labelName = this.LabelName.getComponent(TextRenderer);
            this._labelCredits = this.LabelCredits.getComponent(TextRenderer);
            this._labelCreditsTransform = this.LabelCredits.getComponent(Transform);
            this._labelRunCredits = this.LabelCredits.getComponent(RunNumber);
            this._timesCard = this.TimesCard.getComponent(TimesCard);
            this._labelRunCredits.$renderFunc = renderRunCredits;
            this._pos = this.transform.position.x;
        }
    };
    PKResultAnimSide.prototype.play = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var nickname, receiveCredits, finalCredits, multipleCard, showTimesCard, toScale1, toScale2, stageWidth;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        nickname = data.nickname, receiveCredits = data.receiveCredits, finalCredits = data.finalCredits, multipleCard = data.multipleCard;
                        showTimesCard = multipleCard > 0;
                        this._labelName.text = stringFixed(nickname);
                        this._labelCredits.text = '';
                        this.TimesCard.enabled = false;
                        this._labelCreditsTransform.scale.setXY(0.6, 0.6);
                        toScale1 = {
                            x: 1, y: 1,
                        };
                        toScale2 = {
                            x: 1.4, y: 1.4,
                        };
                        stageWidth = scilla.engine.renderContext.stageSize.width;
                        return [4, scilla.createTween(this, this.transform.position)
                                .set({ x: stageWidth * this.side }, true)
                                .to({ x: this._pos }, 500, scilla.ease.backOut)
                                .getPromise()];
                    case 1:
                        _a.sent();
                        scilla.createTween(this, this._labelCreditsTransform)
                            .to({ scale: showTimesCard ? toScale1 : toScale2 }, 1000);
                        return [4, this._labelRunCredits.play(receiveCredits, 0)];
                    case 2:
                        _a.sent();
                        if (!showTimesCard) return [3, 5];
                        return [4, this._timesCard.playShow(multipleCard)];
                    case 3:
                        _a.sent();
                        scilla.createTween(this, this._labelCreditsTransform)
                            .to({ scale: toScale2 }, 1000);
                        return [4, this._labelRunCredits.play(finalCredits, receiveCredits)];
                    case 4:
                        _a.sent();
                        _a.label = 5;
                    case 5: return [2];
                }
            });
        });
    };
    return PKResultAnimSide;
}(ScillaComponent));

var entry_55 = /*#__PURE__*/Object.freeze({
    'default': PKResultAnimSide
});

var AnimLayer = (function (_super) {
    __extends(AnimLayer, _super);
    function AnimLayer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AnimLayer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._leftSide = this.LeftSide.getComponent(PKResultAnimSide);
        this._rightSide = this.RightSide.getComponent(PKResultAnimSide);
        this._lineTransform = this.Line.getComponent(Transform);
    };
    AnimLayer.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    AnimLayer.prototype.play = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        scilla.createTween(this, this._lineTransform)
                            .set({ scale: { x: 0, y: 0 }, alpha: 0 }, true)
                            .wait(200)
                            .to({ scale: { x: 1, y: 1 }, alpha: 1 }, 500, scilla.ease.backOut);
                        return [4, Promise.all([this._leftSide.play({
                                    nickname: this.userNickname,
                                    receiveCredits: this.pkData.userReceiveCredits,
                                    finalCredits: this.pkData.userFinalCredits,
                                    multipleCard: this.pkData.userMultipleCard,
                                }),
                                this._rightSide.play({
                                    nickname: this.pkData.machineNickname,
                                    receiveCredits: this.pkData.machineReceiveCredits,
                                    finalCredits: this.pkData.machineFinalCredits,
                                    multipleCard: this.pkData.machineMultipleCard,
                                }),])];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    return AnimLayer;
}(ScillaComponent));

var entry_42 = /*#__PURE__*/Object.freeze({
    'default': AnimLayer
});

var PKResultSide = (function (_super) {
    __extends(PKResultSide, _super);
    function PKResultSide() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKResultSide.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._labelName) {
            this._labelName = this.LabelName.getComponent(TextRenderer);
            this._labelCredits = this.LabelCredits.getComponent(TextRenderer);
            this._labelCreditsTransform = this.LabelCredits.getComponent(Transform);
            this._resultTagRenderer = this.ResultTag.getComponent(TextureRenderer);
            this._bodyRenderer = this.Body.getComponent(TextureRenderer);
            this._resultTagZoom = this.ResultTag.getComponent(Zoom);
            this._labelRunCredits = this.LabelCredits.getComponent(RunNumber);
            this._labelRunCredits.$renderFunc = renderRunCredits;
            this._pos = this.transform.position.x;
        }
    };
    PKResultSide.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    PKResultSide.prototype.play = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var nickname, finalCredits, otherFinalCredits, resultState, win, stageWidth, toValue_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        nickname = data.nickname, finalCredits = data.finalCredits, otherFinalCredits = data.otherFinalCredits, resultState = data.resultState;
                        this._labelName.text = stringFixed(nickname);
                        this._labelCredits.text = renderRunCredits(finalCredits);
                        win = resultState === this.side;
                        this._bodyRenderer.texture = resultState === 0 || win ? this.winBodyRes : this.loseBodyRes;
                        this.ResultTag.enabled = false;
                        this.Stars.enabled = false;
                        stageWidth = scilla.engine.renderContext.stageSize.width;
                        return [4, scilla.createTween(this, this.transform.position)
                                .set({ x: stageWidth * this.side }, true)
                                .to({ x: this._pos }, 300, scilla.ease.cubicOut)
                                .getPromise()];
                    case 1:
                        _a.sent();
                        this._labelCreditsTransform.scale.setXY(1, 1);
                        this._resultTagRenderer.texture = resultState === 0 ? this.equalTagRes : (win ? this.winTagRes : this.loseTagRes);
                        setTimeout(function () {
                            _this.ResultTag.enabled = true;
                            if (win) {
                                _this.Stars.enabled = true;
                            }
                        }, 300);
                        if (!(resultState === 0)) return [3, 2];
                        return [3, 4];
                    case 2:
                        toValue_1 = win ? finalCredits + otherFinalCredits : 0;
                        return [4, scilla.createTween(this, this._labelCreditsTransform)
                                .wait(1000)
                                .call(function () {
                                _this._labelRunCredits.play(toValue_1);
                            })
                                .to({ scale: win ? { x: 1.4, y: 1.4 } : { x: 0.6, y: 0.6 } }, 1000)
                                .getPromise()];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4: return [2];
                }
            });
        });
    };
    return PKResultSide;
}(ScillaComponent));

var entry_56 = /*#__PURE__*/Object.freeze({
    'default': PKResultSide
});

var ResultLayer = (function (_super) {
    __extends(ResultLayer, _super);
    function ResultLayer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ResultLayer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._leftSide = this.LeftSide.getComponent(PKResultSide);
        this._rightSide = this.RightSide.getComponent(PKResultSide);
        this._lineTransform = this.Line.getComponent(Transform);
        this._bottomBarLayout = this.BottomBar.getComponent(RelativeLayout);
        this._bottomBarHeight = this.BottomBar.getComponent(Transform).height;
        this.hide();
    };
    ResultLayer.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    ResultLayer.prototype.play = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, userFinalCredits, machineFinalCredits, machineNickname, resultState;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.pkData, userFinalCredits = _a.userFinalCredits, machineFinalCredits = _a.machineFinalCredits, machineNickname = _a.machineNickname, resultState = _a.resultState;
                        scilla.createTween(this, this._lineTransform)
                            .set({ scale: { x: 0, y: 0 }, alpha: 0 }, true)
                            .wait(200)
                            .to({ scale: { x: 1, y: 1 }, alpha: 1 }, 500, scilla.ease.backOut);
                        return [4, Promise.all([this._leftSide.play({
                                    nickname: this.userNickname,
                                    finalCredits: userFinalCredits,
                                    otherFinalCredits: machineFinalCredits,
                                    resultState: resultState
                                }),
                                this._rightSide.play({
                                    nickname: machineNickname,
                                    finalCredits: machineFinalCredits,
                                    otherFinalCredits: userFinalCredits,
                                    resultState: resultState
                                }),]).then(function () {
                                scilla.createTween(_this, _this._bottomBarLayout)
                                    .to({ bottom: 0 }, 500, scilla.ease.cubicOut);
                            })];
                    case 1:
                        _b.sent();
                        return [2];
                }
            });
        });
    };
    ResultLayer.prototype.hide = function () {
        this._bottomBarLayout.bottom = -this._bottomBarHeight;
    };
    return ResultLayer;
}(ScillaComponent));

var entry_43 = /*#__PURE__*/Object.freeze({
    'default': ResultLayer
});

var eventEmitter = new scilla.EventEmitter();

var PKResult = (function (_super) {
    __extends(PKResult, _super);
    function PKResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PKResult.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._animLayer = this.AnimLayer.getComponent(AnimLayer);
        this._resultLayer = this.ResultLayer.getComponent(ResultLayer);
    };
    PKResult.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    PKResult.prototype.setup = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.setup.call(this, data);
                        this.AnimLayer.enabled = true;
                        this.ResultLayer.enabled = false;
                        return [4, this._animLayer.play(data)];
                    case 1:
                        _a.sent();
                        return [4, scilla.utils.waitPromise(500)];
                    case 2:
                        _a.sent();
                        this.ResultLayer.enabled = true;
                        return [4, this._resultLayer.play(data)];
                    case 3:
                        _a.sent();
                        eventEmitter.emit('runCredits');
                        return [2];
                }
            });
        });
    };
    PKResult.prototype.onBottomButtonTap = function (action) {
        this._resultLayer.hide();
        this.hide(action);
    };
    return PKResult;
}(DialogContent));

var entry_39 = /*#__PURE__*/Object.freeze({
    'default': PKResult
});

var RuleDialogContent = (function (_super) {
    __extends(RuleDialogContent, _super);
    function RuleDialogContent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    RuleDialogContent.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._contentRenderer = this.Content.getComponent(HtmlRenderer);
        this._contentRenderer.htmlText = this.ruleContent;
        var config = window['configJson'];
        this._contentRenderer.color = config.dialog_text_color;
    };
    return RuleDialogContent;
}(DialogContent));

var entry_40 = /*#__PURE__*/Object.freeze({
    'default': RuleDialogContent
});

var SingleResult = (function (_super) {
    __extends(SingleResult, _super);
    function SingleResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SingleResult.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._timesCard = this.TimesCard.getComponent(TimesCard);
        this._colorTapeTransform = this.ColorTape.getComponent(Transform);
        this._wrapperTransform = this.Wrapper.getComponent(Transform);
        this._lightTransform = this.Light.getComponent(Transform);
        this._flySequence = this.Coins.getComponent(FlySequence);
        this._runCredits = this.Credits.getComponent(RunNumber);
        this._runCredits.$renderFunc = renderRunCredits;
    };
    SingleResult.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    SingleResult.prototype.setup = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _super.prototype.setup.call(this, data);
                        this.Wrapper.enabled = true;
                        this.Light.enabled = false;
                        scilla.createTween(this, this._wrapperTransform)
                            .set({ scale: { x: 0.8, y: 0.8 }, alpha: 1 })
                            .to({ scale: { x: 1.0, y: 1.0 } }, 2000);
                        scilla.createTween(this, this._colorTapeTransform)
                            .set({ scale: { x: 0, y: 0 }, alpha: 1 })
                            .wait(100)
                            .to({ scale: { x: 0.8, y: 0.8 } }, 800)
                            .to({ scale: { x: 1.1, y: 1.1 }, alpha: 0 }, 1200);
                        return [4, this.playCredits()];
                    case 1:
                        _a.sent();
                        this.playLight();
                        return [2];
                }
            });
        });
    };
    SingleResult.prototype.playCredits = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, receiveCredits, finalCredits, multipleCard, showTimesCard;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.singleDigData, receiveCredits = _a.receiveCredits, finalCredits = _a.finalCredits, multipleCard = _a.multipleCard;
                        showTimesCard = multipleCard > 0;
                        this.TimesCard.enabled = false;
                        return [4, this._runCredits.play(receiveCredits, 0)];
                    case 1:
                        _b.sent();
                        return [4, scilla.utils.waitPromise(500)];
                    case 2:
                        _b.sent();
                        if (!showTimesCard) return [3, 5];
                        this.TimesCard.enabled = true;
                        return [4, this._timesCard.playShow(multipleCard)];
                    case 3:
                        _b.sent();
                        scilla.createTween(this, this._wrapperTransform)
                            .to({ scale: { x: 1.2, y: 1.2 } }, 2000);
                        return [4, this._runCredits.play(finalCredits, receiveCredits)];
                    case 4:
                        _b.sent();
                        _b.label = 5;
                    case 5: return [2];
                }
            });
        });
    };
    SingleResult.prototype.playLight = function () {
        var _this = this;
        scilla.createTween(this, this._wrapperTransform)
            .to({ alpha: 0 }, 500)
            .call(function () {
            _this.Wrapper.enabled = false;
        });
        this.Light.enabled = true;
        this._lightTransform.alpha = 0;
        scilla.createTween(this, this._lightTransform)
            .set({ scale: { x: 0, y: 0 } })
            .to({ alpha: 1, scale: { x: 1, y: 1 } }, 300)
            .call(function () {
            _this.playCoins();
        })
            .to({ alpha: 0, scale: { x: 0, y: 0 } }, 300)
            .call(function () {
            _this.Light.enabled = false;
        });
    };
    SingleResult.prototype.playCoins = function () {
        this.bubbling('setBgVisible', false);
        this._flySequence.play();
        eventEmitter.emit('runCredits');
    };
    SingleResult.prototype.onFlyCoinEnd = function () {
        this.hide('complete');
    };
    return SingleResult;
}(DialogContent));

var entry_41 = /*#__PURE__*/Object.freeze({
    'default': SingleResult
});

var Hole = (function (_super) {
    __extends(Hole, _super);
    function Hole() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.heightOffset = 50;
        _this.bottomOffset = 50;
        return _this;
    }
    Hole.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this.bgMask = this.Bg.getComponent(Transform);
        this.bottomTransform = this.Bottom.getComponent(Transform);
    };
    Hole.prototype.show = function () {
        this.entity.enabled = true;
        this.setDeep(0);
    };
    Hole.prototype.hide = function () {
        this.entity.enabled = false;
    };
    Hole.prototype.setDeep = function (v) {
        this.bgMask.height = v + this.heightOffset;
        this.bottomTransform.position.y = v + this.bottomOffset;
    };
    return Hole;
}(ScillaComponent));

var entry_50 = /*#__PURE__*/Object.freeze({
    'default': Hole
});

var speed = new scilla.Vector2D(2.5, 2.5);
var walkRange = 750 / 2 - 50;
var STATUS$1;
(function (STATUS) {
    STATUS[STATUS["IDLE"] = 0] = "IDLE";
    STATUS[STATUS["WALK"] = 1] = "WALK";
    STATUS[STATUS["DIG"] = 2] = "DIG";
    STATUS[STATUS["DIG_IDLE"] = 3] = "DIG_IDLE";
})(STATUS$1 || (STATUS$1 = {}));
var Miner = (function (_super) {
    __extends(Miner, _super);
    function Miner() {
        var _this = _super.call(this) || this;
        _this.itemGap = new scilla.Vector2D(5, -1);
        _this.smallItemScale = new scilla.Vector2D(0.3, 0.3);
        _this._velocity = new scilla.Vector2D();
        _this._diggingHole = false;
        _this._itemCount = 0;
        _this._status = STATUS$1.IDLE;
        return _this;
    }
    Miner.prototype.prepare = function (digDelegate, maxDepth, resName) {
        this._digDelegate = digDelegate;
        this._maxDepth = maxDepth;
        this._bodyAnim.frameAnimation = this.animations[resName];
    };
    Miner.prototype.reset = function () {
        var e_1, _a;
        try {
            for (var _b = __values(this.Items.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                item.enabled = false;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        this._itemCount = 0;
        this._avoidPosition = null;
        this._hole.hide();
        this._minerTransform.position.y = 0;
    };
    Miner.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        if (!this._minerTransform) {
            this._minerTransform = this.Miner.getComponent(Transform);
            this._bodyAnim = this.Body.getComponent(FrameAnimationRenderer);
            this._effectAnim = this.Effect.getComponent(FrameAnimationRenderer);
            this._hole = this.Hole.getComponent(Hole);
            this._hole.hide();
        }
    };
    Miner.prototype.onUpdate = function (t) {
        var e_2, _a;
        _super.prototype.onUpdate.call(this, t);
        var _b = this, minerPosition = _b._minerTransform.position, position = _b.transform.position, _velocity = _b._velocity;
        switch (this._status) {
            case STATUS$1.IDLE:
                break;
            case STATUS$1.WALK:
                position.x += _velocity.x;
                if (Math.abs(position.x) > walkRange) {
                    _velocity.x = -_velocity.x;
                    this.dir = _velocity.x >= 0 ? 1 : -1;
                }
                if (this._avoidPosition && Math.abs(position.x - this._avoidPosition.x) > this.holeRes.width) {
                    this.playDig();
                }
                break;
            case STATUS$1.DIG:
                if (this._diggingHole) {
                    minerPosition.y += _velocity.y;
                    this._hole.setDeep(minerPosition.y - 25);
                    var items = this._digDelegate(position.x, minerPosition.y - 50);
                    if (items.length > 0) {
                        this.playDigIdle();
                    }
                    try {
                        for (var items_1 = __values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                            var item = items_1_1.value;
                            this.playAddItem(item);
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (items_1_1 && !items_1_1.done && (_a = items_1.return)) _a.call(items_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                    if (minerPosition.y > this._maxDepth) {
                        this.playIdle();
                        this.bubbling('digEnd');
                    }
                }
                break;
            case STATUS$1.DIG_IDLE:
                break;
        }
    };
    Object.defineProperty(Miner.prototype, "dir", {
        get: function () {
            return this._minerTransform.scale.x;
        },
        set: function (v) {
            this._minerTransform.scale.x = v;
        },
        enumerable: true,
        configurable: true
    });
    Miner.prototype.standSide = function (dir) {
        this.transform.position.x = walkRange * -dir;
        this.dir = dir;
    };
    Miner.prototype.playIdle = function () {
        this._status = STATUS$1.IDLE;
        this._bodyAnim.play('idle', -1);
    };
    Miner.prototype.playWalk = function () {
        this._status = STATUS$1.WALK;
        this._diggingHole = false;
        this._bodyAnim.play('walk', -1);
        this._velocity.x = speed.x;
        this.dir = 1;
    };
    Miner.prototype.playDig = function () {
        this._bodyAnim.play('beginDig', 1);
        this._status = STATUS$1.DIG;
        this._velocity.setXY(0, speed.y);
    };
    Miner.prototype.playDigIdle = function () {
        this._bodyAnim.play('idle', -1);
        this._status = STATUS$1.DIG_IDLE;
        this._velocity.y = 0;
    };
    Miner.prototype.playAddItem = function (item) {
        var _this = this;
        var e_3, _a;
        var target;
        try {
            for (var _b = __values(this.Items.children), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item_1 = _c.value;
                if (!item_1.enabled) {
                    target = item_1;
                    target.enabled = true;
                    break;
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        if (!target) {
            target = scilla.instantiate(this.itemHangPrefab);
            this.Items.addChild(target);
        }
        item.exclude = true;
        item.entity.enabled = false;
        var pos = item.getComponent(Transform).globalPosition;
        var targetTransform = target.getComponent(Transform);
        var localPos = this.Items.getComponent(Transform).globalPositionToLocal(pos);
        targetTransform.position.copyFrom(localPos);
        targetTransform.scale.setXY(1, 1);
        var position = { x: this._itemCount * this.itemGap.x, y: this._itemCount * this.itemGap.y };
        this._itemCount++;
        scilla.createTween(this, targetTransform, false, { fields: ['x', 'y'] })
            .to({ position: position, scale: this.smallItemScale.toObj() }, 500, scilla.ease.cubicInOut)
            .call(function () {
            _this.playDig();
        });
    };
    Miner.prototype.onAnimationComplete = function (label) {
        switch (label) {
            case 'beginDig':
                this._bodyAnim.play('dig', -1);
                this._effectAnim.play(0, 1);
                this._hole.show();
                this._diggingHole = true;
                break;
        }
    };
    Miner.prototype.onAnimationLoopComplete = function (label) {
        switch (label) {
            case 'dig':
                this._effectAnim.play(0, 1);
                break;
        }
    };
    Miner.prototype.avoidToDig = function (position) {
        var _this = this;
        setTimeout(function () {
            _this._avoidPosition = position;
        }, Math.random() * 500 + 500);
    };
    return Miner;
}(ScillaComponent));

var entry_53 = /*#__PURE__*/Object.freeze({
    'default': Miner
});

function getWaveAlgorithm() {
    return function bounce(t) {
        var s = 1 + Math.abs(Math.sin(t)) * 0.1;
        return {
            sx: s,
            sy: s,
        };
    };
}
var BottomButtonController = (function (_super) {
    __extends(BottomButtonController, _super);
    function BottomButtonController() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._buttons = [];
        _this._counting = 0;
        return _this;
    }
    BottomButtonController.prototype.onAwake = function () {
        var _this = this;
        _super.prototype.onAwake.call(this);
        this._buttonSLDig = this.buttonDigSLEntity.getComponent(CustomButton);
        this._buttonPK = this.buttonPKEntity.getComponent(TwoLinesButton);
        var wavePK = this.buttonPKEntity.getComponent(Wave);
        var wcPK = this.buttonPKEntity.getComponent(WaveController);
        wavePK.waveAlgorithm = getWaveAlgorithm();
        this._buttonDig = this.buttonDigEntity.getComponent(TwoLinesButton);
        var waveDig = this.buttonDigEntity.getComponent(Wave);
        var wcDig = this.buttonDigEntity.getComponent(WaveController);
        waveDig.waveAlgorithm = getWaveAlgorithm();
        this.switchState(false);
        this._buttons.push({
            button: this._buttonPK,
            wave: wavePK,
            wc: wcPK,
        }, {
            button: this._buttonDig,
            wave: waveDig,
            wc: wcDig,
        });
        setInterval(function () {
            var _a = _this._buttons[(_this._counting++) % _this._buttons.length], button = _a.button, wave = _a.wave, wc = _a.wc;
            if (button.interactable && !wc.touchBeginFlag) {
                wave.play();
            }
        }, 600);
        this.updateButtonLabel();
        this.disableAll();
    };
    BottomButtonController.prototype.initGameStage = function () {
        var _a = this.activityBaseInfo, pkExpend = _a.pkExpend, miningExpend = _a.miningExpend;
        this.updateButtonLabel(pkExpend, miningExpend);
        this.switchState(false);
    };
    BottomButtonController.prototype.updateButtonLabel = function (pkExpend, miningExpend) {
        if (pkExpend === void 0) { pkExpend = 0; }
        if (miningExpend === void 0) { miningExpend = 0; }
        this._buttonPK.label1 = renderRunCredits(pkExpend) + '/次';
        this._buttonDig.label1 = renderRunCredits(miningExpend) + '/次';
    };
    BottomButtonController.prototype.enableAll = function () {
        var e_1, _a;
        try {
            for (var _b = __values(this._buttons), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = _c.value, button = _d.button, wc = _d.wc;
                button.interactable = true;
                wc.touchBeginFlag = false;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    BottomButtonController.prototype.disableAll = function () {
        var e_2, _a;
        try {
            for (var _b = __values(this._buttons), _c = _b.next(); !_c.done; _c = _b.next()) {
                var _d = _c.value, button = _d.button, wc = _d.wc;
                button.interactable = false;
                wc.touchBeginFlag = false;
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    BottomButtonController.prototype.enablePkDigButton = function () {
        this._buttonSLDig.interactable = true;
    };
    BottomButtonController.prototype.disablePkDigButton = function () {
        this._buttonSLDig.interactable = false;
    };
    BottomButtonController.prototype.switchState = function (isPK) {
        this.buttonPKEntity.enabled = !isPK;
        this.buttonDigEntity.enabled = !isPK;
        this.buttonDigSLEntity.enabled = isPK;
        if (isPK) {
            this.enablePkDigButton();
        }
    };
    return BottomButtonController;
}(ScillaComponent));

var entry_45 = /*#__PURE__*/Object.freeze({
    'default': BottomButtonController
});

var Item = (function (_super) {
    __extends(Item, _super);
    function Item() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exclude = false;
        _this._playing = false;
        return _this;
    }
    Item.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._floatMissing = this.creditsEntity.getComponent(FloatMissing);
        this._label = this.Label.getComponent(TextRenderer);
    };
    Item.prototype.reset = function (pos) {
        this.transform.position.copyFrom(pos);
        this.entity.enabled = true;
        this.exclude = false;
        this._playing = false;
    };
    Item.prototype.playCredits = function (cost) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this._label.text = cost.toString();
                        this.creditsEntity.enabled = true;
                        this._floatMissing.delay = Math.random() * 500;
                        this._playing = true;
                        return [4, this._floatMissing.play()];
                    case 1:
                        _a.sent();
                        this._playing = false;
                        return [2];
                }
            });
        });
    };
    Item.prototype.stopCredits = function () {
        this.creditsEntity.enabled = false;
    };
    Object.defineProperty(Item.prototype, "playing", {
        get: function () {
            return this._playing;
        },
        enumerable: true,
        configurable: true
    });
    Item.prototype.hit = function (x, y, hitWidth, hitHeight) {
        var _a = this.transform.position, px = _a.x, py = _a.y;
        return x > px - hitWidth / 2 && x < px + hitWidth / 2 && py && y > py - hitHeight / 2 && y < py + hitHeight / 2;
    };
    return Item;
}(ScillaComponent));

var entry_51 = /*#__PURE__*/Object.freeze({
    'default': Item
});

var ItemLayer = (function (_super) {
    __extends(ItemLayer, _super);
    function ItemLayer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.itemCount = 13;
        _this.itemPosPadding = 50;
        _this.itemPosRange = new scilla.Size(750, 500);
        _this.itemCellPadding = 20;
        _this.itemPosOffsetY = 50;
        _this.playCreditsCount = 4;
        _this._items = [];
        _this._excludeItemQueue = [];
        _this.playACredits = function () { return __awaiter(_this, void 0, void 0, function () {
            var _a, _excludeItemQueue, _items, targetItem, index, cost;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (!(this._freePlayCreditsCount > 0)) return [3, 2];
                        _a = this, _excludeItemQueue = _a._excludeItemQueue, _items = _a._items;
                        targetItem = void 0, index = void 0;
                        while (true) {
                            index = Math.floor(Math.random() * _items.length);
                            if (_excludeItemQueue.indexOf(index) < 0) {
                                targetItem = _items[index];
                                if (!targetItem.playing) {
                                    break;
                                }
                            }
                        }
                        this._freePlayCreditsCount--;
                        _excludeItemQueue.push(index);
                        if (_excludeItemQueue.length > this._playCreditsCount * 2) {
                            _excludeItemQueue.shift();
                        }
                        cost = scilla.math.makeRandomInt(this.activityBaseInfo.miningExpend * 2, 1);
                        return [4, targetItem.playCredits(cost)];
                    case 1:
                        _b.sent();
                        this._freePlayCreditsCount++;
                        _b.label = 2;
                    case 2: return [2];
                }
            });
        }); };
        _this.digDelegate = function (x, y) {
            var e_1, _a;
            var items = [];
            var hitWidth = _this.holeRes.width + _this.itemRes.width - 40;
            try {
                for (var _b = __values(_this._items), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var item = _c.value;
                    if (!item.exclude && item.hit(x, y, hitWidth, 5)) {
                        items.push(item);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return items;
        };
        return _this;
    }
    ItemLayer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._playCreditsCount = Math.floor(this.itemCount / 3);
        this._itemGap = {
            x: (this.itemPosRange.width - this.itemPosPadding * 2) / 3,
            y: (this.itemPosRange.height - this.itemCellPadding * 2) / 3,
        };
        this._itemPosOffset = {
            x: -this.itemPosRange.width / 2,
            y: this.itemPosOffsetY,
        };
        for (var i = 0; i < this.itemCount; i++) {
            var itemEntity = scilla.instantiate(this.itemPrefab);
            this.entity.addChild(itemEntity);
            itemEntity.enabled = false;
            this._items.push(itemEntity.getComponent(Item));
        }
    };
    ItemLayer.prototype.prepareItems = function () {
        this._freePlayCreditsCount = this.playCreditsCount;
        this._excludeItemQueue.splice(0);
        var _a = this, _itemGap = _a._itemGap, _itemPosOffset = _a._itemPosOffset, itemPosPadding = _a.itemPosPadding, itemCellPadding = _a.itemCellPadding, itemPosRange = _a.itemPosRange;
        var i, j;
        for (i = 0; i < 4; i++) {
            this.addItem(i, {
                x: i * _itemGap.x + _itemPosOffset.x + itemPosPadding,
                y: _itemPosOffset.y + Math.random() * itemPosRange.height + itemPosPadding,
            });
        }
        for (j = 0; j < this.itemCount - 4; j++) {
            var gx = j % 3;
            var gy = Math.floor(j / 3);
            this.addItem(i + j, {
                x: gx * _itemGap.x + _itemPosOffset.x + itemPosPadding + Math.random() * (_itemGap.x - itemCellPadding * 2) + itemCellPadding,
                y: gy * _itemGap.y + _itemPosOffset.y + itemPosPadding + Math.random() * (_itemGap.y - itemCellPadding * 2) + itemCellPadding,
            });
        }
        this.entity.children.sort(function (a, b) {
            return a.getComponent(Transform).position.y - b.getComponent(Transform).position.y;
        });
        this.stopCreditsAnimation();
        this.playCreditsAnimation();
    };
    ItemLayer.prototype.addItem = function (i, pos) {
        var item = this._items[i];
        item.reset(pos);
    };
    ItemLayer.prototype.playCreditsAnimation = function () {
        this._timerCreditsAnimation = setInterval(this.playACredits, 200);
    };
    ItemLayer.prototype.stopCreditsAnimation = function () {
        var e_2, _a;
        if (this._timerCreditsAnimation) {
            clearInterval(this._timerCreditsAnimation);
            this._timerCreditsAnimation = null;
        }
        try {
            for (var _b = __values(this._items), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                item.stopCredits();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return ItemLayer;
}(ScillaComponent));

var entry_52 = /*#__PURE__*/Object.freeze({
    'default': ItemLayer
});

var minerConfigs = [
    { res: 'blue', dir: 1, walk: true },
    { res: 'red', dir: -1, walk: false },
];
var GameStage = (function (_super) {
    __extends(GameStage, _super);
    function GameStage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._miners = [];
        _this.matchResult = function (action) {
            if (action === 'close') {
                _this._bottomButtonController.enableAll();
                _this.broadcast('abortCallApi', 1, 'getOrderStatus');
            }
            else {
                _this.startPKDig();
            }
        };
        _this.onPKResult = function (action) {
            _this.reset();
            if (action === 'retry') {
                _this.onTapPK();
            }
        };
        _this.onSingleResultComplete = function () {
            _this.reset();
        };
        _this.onPKChallengeClose = function (action) {
            if (action === 'accept') {
                _this.onTapPK(1);
            }
        };
        return _this;
    }
    GameStage.prototype.onAwake = function () {
        var e_1, _a;
        _super.prototype.onAwake.call(this);
        this._bottomButtonController = this.Bottom.getComponent(BottomButtonController);
        this._countdown = this.CountDown.getComponent(CountDown);
        this._itemLayer = this.ItemLayer.getComponent(ItemLayer);
        try {
            for (var minerConfigs_1 = __values(minerConfigs), minerConfigs_1_1 = minerConfigs_1.next(); !minerConfigs_1_1.done; minerConfigs_1_1 = minerConfigs_1.next()) {
                var config = minerConfigs_1_1.value;
                var minerEntity = scilla.instantiate(this.minerPrefab);
                this.MinerLayer.addChild(minerEntity);
                var miner = minerEntity.getComponent(Miner);
                miner.prepare(this._itemLayer.digDelegate, this.holeRes.height - 40, config.res);
                this._miners.push(miner);
                minerEntity.enabled = false;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (minerConfigs_1_1 && !minerConfigs_1_1.done && (_a = minerConfigs_1.return)) _a.call(minerConfigs_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    GameStage.prototype.initGameStage = function () {
        this.reset();
        if (this.activityBaseInfo.machineNickname) {
            this.bubbling('showDialog', 'PKChallenge', null, this.onPKChallengeClose);
        }
    };
    GameStage.prototype.reset = function () {
        var e_2, _a;
        try {
            for (var _b = __values(this._miners), _c = _b.next(); !_c.done; _c = _b.next()) {
                var miner = _c.value;
                miner.entity.enabled = false;
                miner.reset();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        this._itemLayer.prepareItems();
        this.resetBottomButton();
        var selfMiner = this._miners[0];
        selfMiner.entity.enabled = true;
        selfMiner.standSide(1);
        selfMiner.playWalk();
    };
    GameStage.prototype.resetBottomButton = function () {
        this._bottomButtonController.switchState(false);
        this._bottomButtonController.enableAll();
    };
    GameStage.prototype.loginAlert = function () {
        if (!this.isLogin) {
            this.bubbling('showLoginAlert');
        }
        return this.isLogin;
    };
    GameStage.prototype.creditsAlert = function () {
        return true;
    };
    GameStage.prototype.onTapDig = function () {
        if (!this.loginAlert() || !this.creditsAlert()) {
            return;
        }
        this._bottomButtonController.disableAll();
        this._orderStatus = 0;
        this._digFinishedCount = 0;
        this._minerCount = 1;
        var opActivityId = scilla.engine.dataCenter.get('CFG', 'opActivityId');
        this.broadcast('callApi', 1, 'singleDigData', { opActivityId: opActivityId });
    };
    GameStage.prototype.onTapPK = function (channel) {
        if (channel === void 0) { channel = 0; }
        if (!this.loginAlert() || !this.creditsAlert()) {
            return;
        }
        this._bottomButtonController.disableAll();
        this._orderStatus = 0;
        this._digFinishedCount = 0;
        this._minerCount = 2;
        var opActivityId = scilla.engine.dataCenter.get('CFG', 'opActivityId');
        this.broadcast('callApi', 1, 'pkDigData', { opActivityId: opActivityId }, channel);
    };
    GameStage.prototype.changeOrderStatus = function (v) {
        this._orderStatus = v;
        this.checkDigEnd();
    };
    GameStage.prototype.readyDig = function (minerCount, channel) {
        if (minerCount === 1) {
            this.startDig(minerCount);
        }
        else {
            if (channel === 1) {
                this.pkDigData.machineNickname = this.activityBaseInfo.machineNickname;
            }
            this.bubbling('hideAllDialog');
            this.bubbling('showDialog', 'PKMatching', { channel: channel }, this.matchResult);
        }
        this.activityBaseInfo.curCredits -= minerCount === 1 ? this.activityBaseInfo.miningExpend : this.activityBaseInfo.pkExpend;
        eventEmitter.emit('runCredits', 500);
        this._itemLayer.stopCreditsAnimation();
    };
    GameStage.prototype.startDig = function (minerCount) {
        var _a = this, _miners = _a._miners, _countdown = _a._countdown;
        _countdown.stop();
        var selfMiner = _miners[0];
        selfMiner.playDig();
        if (minerCount === 1) ;
        else {
            this._bottomButtonController.disablePkDigButton();
            var otherMiner = _miners[1];
            otherMiner.avoidToDig(selfMiner.transform.position);
        }
    };
    GameStage.prototype.startPKDig = function () {
        this._bottomButtonController.switchState(true);
        this._countdown.play();
        for (var i = 0, li = minerConfigs.length; i < li; i++) {
            var config = minerConfigs[i];
            var miner = this._miners[i];
            miner.entity.enabled = true;
            miner.standSide(config.dir);
            miner.playWalk();
        }
    };
    GameStage.prototype.restoreDig = function (e) {
        this.reset();
    };
    GameStage.prototype.checkDigEnd = function () {
        if (this._orderStatus !== 0 && this._digFinishedCount === this._minerCount) {
            switch (this._orderStatus) {
                case 2:
                case 4:
                    this.onDigEnd();
                    break;
                case 1:
                case 3:
                    this.bubbling('showNetError');
                    break;
            }
        }
    };
    GameStage.prototype.digEnd = function () {
        this._digFinishedCount++;
        this.checkDigEnd();
    };
    GameStage.prototype.onDigEnd = function () {
        switch (this._minerCount) {
            case 1:
                this.activityBaseInfo.curCredits += this.singleDigData.finalCredits;
                this.activityBaseInfo.heapCredits += this.singleDigData.finalCredits;
                this.bubbling('hideAllDialog');
                this.bubbling('showDialog', 'SingleResult', null, this.onSingleResultComplete);
                break;
            case 2:
                var _a = this.pkDigData, userFinalCredits = _a.userFinalCredits, machineFinalCredits = _a.machineFinalCredits;
                var resultState = userFinalCredits === machineFinalCredits ? 0 : (userFinalCredits > machineFinalCredits ? -1 : 1);
                this.pkDigData.resultState = resultState;
                var gotCredits = userFinalCredits;
                if (resultState < 0) {
                    gotCredits += machineFinalCredits;
                }
                else if (resultState > 0) {
                    gotCredits = 0;
                }
                this.activityBaseInfo.curCredits += gotCredits;
                this.activityBaseInfo.heapCredits += gotCredits;
                this.bubbling('hideAllDialog');
                this.bubbling('showDialog', 'PKResult', null, this.onPKResult);
                break;
        }
    };
    return GameStage;
}(ScillaComponent));

var entry_49 = /*#__PURE__*/Object.freeze({
    'default': GameStage
});

var ApiProcess = (function (_super) {
    __extends(ApiProcess, _super);
    function ApiProcess() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ApiProcess.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._gameStage = this.entity.getComponent(GameStage);
    };
    ApiProcess.prototype.onSingleDigSuccess = function (response) {
        console.log(response);
        this._gameStage.readyDig(1, 0);
        this.getOrderStatus(response);
    };
    ApiProcess.prototype.onPkDigSuccess = function (response, channel) {
        console.log(response);
        this._gameStage.readyDig(2, channel);
        this.getOrderStatus(response);
    };
    ApiProcess.prototype.getOrderStatus = function (response) {
        var actOrderNum = response.actOrderNum, operationType = response.operationType;
        this.broadcast('callApi', 1, 'getOrderStatus', { actOrderNum: actOrderNum, operationType: operationType, });
    };
    ApiProcess.prototype.onDigError = function (e) {
        console.log(e);
        if (typeof e === 'string') {
            switch (e) {
                case '0100000':
                    this.bubbling('showLoginAlert');
                    this._gameStage.resetBottomButton();
                    break;
                case '0201150':
                    this.bubbling('showCreditsAlert');
                    this._gameStage.resetBottomButton();
                    break;
                case '0100016':
                case '0100014':
                case '0100017':
                    this.bubbling('showErrorToast', e);
                    break;
                default:
                    this.bubbling('showNetError');
            }
        }
        else {
            this.bubbling('showNetError');
        }
    };
    ApiProcess.prototype.onOrderStatusResponse = function (response) {
        console.log('onOrderStatusResponse', response);
        this._gameStage.changeOrderStatus(response);
    };
    ApiProcess.prototype.onOrderStatusError = function (e) {
        console.log('onOrderStatusError', e);
        this._gameStage.changeOrderStatus(1);
    };
    return ApiProcess;
}(ScillaComponent));

var entry_44 = /*#__PURE__*/Object.freeze({
    'default': ApiProcess
});

var CreditsBar = (function (_super) {
    __extends(CreditsBar, _super);
    function CreditsBar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.runDuration = 2000;
        return _this;
    }
    CreditsBar.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        eventEmitter.on('runCredits', this.runCredits, this);
        this._bgRenderer = this.getComponent(RectRenderer);
        this._creditsUnitName = this.CreditsUnitName.getComponent(TextRenderer);
        this._labelCreditsCurrent = this.LabelCreditsCurrent.getComponent(TextRenderer);
        this._labelCreditsTotal = this.LabelCreditsTotal.getComponent(TextRenderer);
        this._runCreditsCurrent = this.LabelCreditsCurrent.getComponent(RunNumber);
        this._runCreditsTotal = this.LabelCreditsTotal.getComponent(RunNumber);
        this._creditsUnitName.text = this.unitName;
        if (this.showCredits !== 1) {
            this.LabelCreditsCurrent.enabled = false;
            this.Line.enabled = false;
            this.Label.enabled = false;
        }
        this._bgRenderer.width = this.showCredits === 1 ? 480 : 320;
    };
    CreditsBar.prototype.initGameStage = function () {
        var _a = this.activityBaseInfo, curCredits = _a.curCredits, heapCredits = _a.heapCredits;
        if (this.showCredits === 1) {
            this._labelCreditsCurrent.text = curCredits.toString();
        }
        this._labelCreditsTotal.text = heapCredits.toString();
    };
    CreditsBar.prototype.runCredits = function (duration) {
        var _a = this.activityBaseInfo, curCredits = _a.curCredits, heapCredits = _a.heapCredits;
        if (this.showCredits === 1) {
            this._runCreditsCurrent.duration = duration || this.runDuration;
            this._runCreditsCurrent.play(curCredits);
        }
        this._runCreditsTotal.duration = duration || this.runDuration;
        this._runCreditsTotal.play(heapCredits);
    };
    return CreditsBar;
}(ScillaComponent));

var entry_46 = /*#__PURE__*/Object.freeze({
    'default': CreditsBar
});

var CustomTextRenderer = (function (_super) {
    __extends(CustomTextRenderer, _super);
    function CustomTextRenderer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CustomTextRenderer.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        var config = window['configJson'];
        if (this.fillColorKey) {
            this.fillColor = config[this.fillColorKey];
        }
    };
    return CustomTextRenderer;
}(TextRenderer));

var entry_48 = /*#__PURE__*/Object.freeze({
    'default': CustomTextRenderer
});

var NoticeBar = (function (_super) {
    __extends(NoticeBar, _super);
    function NoticeBar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._pool = [];
        _this.getTextFunc = function () {
            if (_this._pool.length < 5) {
                _this.initGameStage();
            }
            if (_this._pool.length > 0) {
                if (_this._pool.length > 0) {
                    _this._bgRenderer.enabled = true;
                }
                return _this._pool.shift();
            }
        };
        return _this;
    }
    NoticeBar.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this._bgRenderer = this.getComponent(RectRenderer);
        this._bgRenderer.enabled = false;
        this._labelCarousel = this.getComponent(LabelCarousel);
        this._labelCarousel.getTextFunc = this.getTextFunc;
    };
    NoticeBar.prototype.initGameStage = function () {
        this.broadcast('callApi', 1, 'noticeContent', { opActivityId: this.opActivityId });
    };
    NoticeBar.prototype.onGotNoticeContent = function (response) {
        this._pool = this._pool.concat(response);
        if (!this._labelCarousel._playing) {
            this._labelCarousel.play();
        }
    };
    return NoticeBar;
}(ScillaComponent));

var entry_54 = /*#__PURE__*/Object.freeze({
    'default': NoticeBar
});

var NavigatorAction;
(function (NavigatorAction) {
    NavigatorAction[NavigatorAction["Push"] = 0] = "Push";
    NavigatorAction[NavigatorAction["Pop"] = 1] = "Pop";
    NavigatorAction[NavigatorAction["Replace"] = 2] = "Replace";
    NavigatorAction[NavigatorAction["Jump"] = 3] = "Jump";
})(NavigatorAction || (NavigatorAction = {}));
var StackNavigator = (function () {
    function StackNavigator(delegate) {
        this._stack = [];
        this._delegate = delegate;
    }
    StackNavigator.prototype.catchPromise = function (p) {
        var _this = this;
        if (p) {
            p.catch((function (e) {
                _this._delegate.onError(e);
            }));
        }
    };
    StackNavigator.prototype.push = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        var last = this.getTopSceneName();
        if (last) {
            if (last == name) {
                return;
            }
            this.catchPromise(this._delegate.onLeave(last, name, NavigatorAction.Push, parameters));
        }
        this._stack.push(name);
        this.catchPromise(this._delegate.onEnter(name, last, NavigatorAction.Push, parameters));
    };
    StackNavigator.prototype.popTo = function (index, name, parameters) {
        if (parameters === void 0) { parameters = null; }
        if (this._stack.length > 0 && this._stack.length < (index + 1)) {
            return;
        }
        var last = this.getTopSceneName();
        this._stack.splice(Math.max(index + 1, 0));
        var next = this._stack[index];
        if (!next) {
            this._stack.push(next = name);
        }
        if (last) {
            this.catchPromise(this._delegate.onLeave(last, next, NavigatorAction.Pop, parameters));
        }
        this.catchPromise(this._delegate.onEnter(next, last, NavigatorAction.Pop, parameters));
    };
    StackNavigator.prototype.pop = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this.popTo(this._stack.length - 2, null, parameters);
    };
    StackNavigator.prototype.popAll = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.popTo(-1, name, parameters);
    };
    StackNavigator.prototype.replace = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        var last = this._stack.pop();
        this._stack.push(name);
        this.catchPromise(this._delegate.onLeave(last, name, NavigatorAction.Replace, parameters));
        this.catchPromise(this._delegate.onEnter(name, last, NavigatorAction.Replace, parameters));
    };
    StackNavigator.prototype.jump = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        if (this._stack.length < 2) {
            this.push(name, parameters);
            return;
        }
        var last = this._stack.pop();
        this._stack.splice(1);
        var next = name;
        this._stack.push(next);
        this._delegate.onLeave(last, next, NavigatorAction.Pop, parameters);
        this._delegate.onEnter(next, last, NavigatorAction.Pop, parameters);
    };
    StackNavigator.prototype.getTopSceneName = function () {
        return this._stack.length > 0 ? this._stack[this._stack.length - 1] : null;
    };
    StackNavigator.prototype.getBottomSceneName = function () {
        return this._stack.length > 0 ? this._stack[0] : null;
    };
    return StackNavigator;
}());

var entry_61 = /*#__PURE__*/Object.freeze({
    get NavigatorAction () { return NavigatorAction; },
    StackNavigator: StackNavigator
});

var Navigator = (function (_super) {
    __extends(Navigator, _super);
    function Navigator() {
        var _this = _super.call(this) || this;
        _this._classDic = {};
        _this._instanceDic = {};
        _this.stack = new StackNavigator(_this);
        return _this;
    }
    Navigator.prototype.register = function (name, clazz) {
        this._classDic[name] = clazz;
    };
    Navigator.prototype.push = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.push(name, parameters);
    };
    Navigator.prototype.pop = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.pop(parameters);
    };
    Navigator.prototype.popToBottom = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.popTo(0, null, parameters);
    };
    Navigator.prototype.popAll = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.popAll(name, parameters);
    };
    Navigator.prototype.replace = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.replace(name, parameters);
    };
    Navigator.prototype.jump = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this.stack.jump(name, parameters);
    };
    Object.defineProperty(Navigator.prototype, "currentView", {
        get: function () {
            return this._currentView;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Navigator.prototype, "currentName", {
        get: function () {
            return this._currentName;
        },
        enumerable: true,
        configurable: true
    });
    Navigator.prototype.newView = function (name) {
        return new this._classDic[name]();
    };
    Navigator.prototype.getViewInstanceByName = function (name) {
        var view = this._instanceDic[name];
        if (!view) {
            view = this._instanceDic[name] = this.newView(name);
        }
        return view;
    };
    Navigator.prototype.addView = function (view, addToBottom) {
    };
    Navigator.prototype.onEnter = function (name, last, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            var view, addToBottom;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        this._currentView = view;
                        this._currentName = name;
                        return [4, view.onWillMount(last, action, parameters)];
                    case 1:
                        _a.sent();
                        addToBottom = view.onAddView();
                        this.addView(view, addToBottom);
                        this.emit(Navigator.VIEW_WILL_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        return [4, view.onWillEnter(last, action, parameters)];
                    case 2:
                        _a.sent();
                        this.emit(Navigator.VIEW_DID_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        view.onDidEnter(last, action, parameters);
                        return [2];
                }
            });
        });
    };
    Navigator.prototype.onLeave = function (name, next, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            var view;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        return [4, view.onWillUnMount(name, action, parameters)];
                    case 1:
                        _a.sent();
                        this.emit(Navigator.VIEW_WILL_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        return [4, view.onWillLeave(next, action, parameters)];
                    case 2:
                        _a.sent();
                        this.emit(Navigator.VIEW_DID_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        view.onDidLeave(next, action, parameters);
                        return [2];
                }
            });
        });
    };
    Navigator.prototype.onError = function (error) {
    };
    Navigator.VIEW_WILL_ENTER = 'VIEW_WILL_ENTER';
    Navigator.VIEW_DID_ENTER = 'VIEW_DID_ENTER';
    Navigator.VIEW_WILL_LEAVE = 'VIEW_WILL_LEAVE';
    Navigator.VIEW_DID_LEAVE = 'VIEW_DID_LEAVE';
    return Navigator;
}(scilla.EventEmitter));

var entry_59 = /*#__PURE__*/Object.freeze({
    Navigator: Navigator
});

var VIEW_WILL_ENTER = 'VIEW_WILL_ENTER';
var VIEW_DID_ENTER = 'VIEW_DID_ENTER';
var VIEW_WILL_LEAVE = 'VIEW_WILL_LEAVE';
var VIEW_DID_LEAVE = 'VIEW_DID_LEAVE';
var VirtualNavigator = (function (_super) {
    __extends(VirtualNavigator, _super);
    function VirtualNavigator(container) {
        var _this = _super.call(this) || this;
        _this._container = container;
        _this._classDic = {};
        _this.stack = new StackNavigator(_this);
        return _this;
    }
    VirtualNavigator.prototype.register = function (alias, childName, componentDef) {
        this._classDic[alias] = {
            childName: childName,
            componentDef: componentDef,
        };
    };
    Object.defineProperty(VirtualNavigator.prototype, "currentView", {
        get: function () {
            return this._currentView;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(VirtualNavigator.prototype, "currentName", {
        get: function () {
            return this._currentName;
        },
        enumerable: true,
        configurable: true
    });
    VirtualNavigator.prototype.getViewInstanceByName = function (name) {
        var _a = this._classDic[name], childName = _a.childName, componentDef = _a.componentDef;
        var scene = this._container.getChildrenByName(childName)[0];
        var component = scene.getComponent(componentDef);
        return component;
    };
    VirtualNavigator.prototype.onEnter = function (name, last, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            var view;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        this._currentView = view;
                        this._currentName = name;
                        return [4, view.onWillMount(last, action, parameters)];
                    case 1:
                        _a.sent();
                        this.emit(VIEW_WILL_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        return [4, view.onWillEnter(last, action, parameters)];
                    case 2:
                        _a.sent();
                        this.emit(VIEW_DID_ENTER, { name: name, last: last, action: action, parameters: parameters });
                        view.onDidEnter(last, action, parameters);
                        return [2];
                }
            });
        });
    };
    VirtualNavigator.prototype.onLeave = function (name, next, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            var view;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = this.getViewInstanceByName(name);
                        return [4, view.onWillUnMount(name, action, parameters)];
                    case 1:
                        _a.sent();
                        this.emit(VIEW_WILL_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        return [4, view.onWillLeave(next, action, parameters)];
                    case 2:
                        _a.sent();
                        this.emit(VIEW_DID_LEAVE, { name: name, next: next, action: action, parameters: parameters });
                        view.onDidLeave(next, action, parameters);
                        return [2];
                }
            });
        });
    };
    VirtualNavigator.prototype.onError = function (error) {
    };
    return VirtualNavigator;
}(scilla.EventEmitter));

var entry_62 = /*#__PURE__*/Object.freeze({
    VIEW_WILL_ENTER: VIEW_WILL_ENTER,
    VIEW_DID_ENTER: VIEW_DID_ENTER,
    VIEW_WILL_LEAVE: VIEW_WILL_LEAVE,
    VIEW_DID_LEAVE: VIEW_DID_LEAVE,
    VirtualNavigator: VirtualNavigator
});

function playAnimation(config, context) {
    return __awaiter(this, void 0, void 0, function () {
        var partName, partConfig, part, componentName, component, _a, params, duration, easeName;
        return __generator(this, function (_b) {
            for (partName in config) {
                partConfig = config[partName];
                part = context[partName];
                for (componentName in partConfig) {
                    component = part.getComponentByName(componentName);
                    _a = partConfig[componentName], params = _a.params, duration = _a.duration, easeName = _a.ease;
                    scilla.createTween(context, component)
                        .to(params, duration, scilla.ease[easeName]);
                }
            }
            return [2];
        });
    });
}

var animationConfig = {
    enter: {},
    leave: {},
};
var SceneStart = (function (_super) {
    __extends(SceneStart, _super);
    function SceneStart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SceneStart.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
    };
    SceneStart.prototype.showRuleDialog = function () {
        this.bubbling('showDialog', 'Rule');
    };
    SceneStart.prototype.onDidEnter = function (last, action, parameters) {
    };
    SceneStart.prototype.onDidLeave = function (next, action, parameters) {
    };
    SceneStart.prototype.onWillEnter = function (last, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, playAnimation(animationConfig.enter, this)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    SceneStart.prototype.onWillLeave = function (next, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, playAnimation(animationConfig.leave, this)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    SceneStart.prototype.onWillMount = function (last, action, parameters) {
        return undefined;
    };
    SceneStart.prototype.onWillUnMount = function (next, action, parameters) {
        return undefined;
    };
    return SceneStart;
}(ScillaComponent));

var entry_66 = /*#__PURE__*/Object.freeze({
    'default': SceneStart
});

var animationConfig$1 = {
    enter: {},
    leave: {},
};
var ScenePlay = (function (_super) {
    __extends(ScenePlay, _super);
    function ScenePlay() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._level = 3;
        return _this;
    }
    ScenePlay.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
    };
    ScenePlay.prototype.onDidEnter = function (last, action, parameters) {
    };
    ScenePlay.prototype.onDidLeave = function (next, action, parameters) {
    };
    ScenePlay.prototype.onWillEnter = function (last, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, playAnimation(animationConfig$1.enter, this)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    ScenePlay.prototype.onWillLeave = function (next, action, parameters) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, playAnimation(animationConfig$1.leave, this)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    ScenePlay.prototype.onWillMount = function (last, action, parameters) {
        return undefined;
    };
    ScenePlay.prototype.onWillUnMount = function (next, action, parameters) {
        return undefined;
    };
    ScenePlay.prototype.reset = function () {
        return __awaiter(this, void 0, void 0, function () {
            var id, url, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        id = 1;
                        url = "singles/" + id + ".jpg";
                        _a = this;
                        return [4, scilla.engine.assetsManager.loadImage(url)];
                    case 1:
                        _a._img = _b.sent();
                        this.startLevel();
                        return [2];
                }
            });
        });
    };
    ScenePlay.prototype.nextLevel = function () {
        this._level++;
        this.startLevel();
    };
    ScenePlay.prototype.startLevel = function () {
        this._puzzle.start(this._img, this._level);
    };
    return ScenePlay;
}(ScillaComponent));

var entry_65 = /*#__PURE__*/Object.freeze({
    'default': ScenePlay
});

var SingleSceneNavigator = (function (_super) {
    __extends(SingleSceneNavigator, _super);
    function SingleSceneNavigator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SingleSceneNavigator.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._navigator = new VirtualNavigator(this.entity);
        this._navigator.register('start', 'SceneStart', SceneStart);
        this._navigator.register('play', 'ScenePlay', ScenePlay);
    };
    SingleSceneNavigator.prototype.onAwake = function () {
        _super.prototype.onAwake.call(this);
        this.push('start');
    };
    SingleSceneNavigator.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    SingleSceneNavigator.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    SingleSceneNavigator.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
    };
    SingleSceneNavigator.prototype.push = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.push(name, parameters);
    };
    SingleSceneNavigator.prototype.pop = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.pop(parameters);
    };
    SingleSceneNavigator.prototype.popToBottom = function (parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.popTo(0, null, parameters);
    };
    SingleSceneNavigator.prototype.popAll = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.popAll(name, parameters);
    };
    SingleSceneNavigator.prototype.replace = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.replace(name, parameters);
    };
    SingleSceneNavigator.prototype.jump = function (name, parameters) {
        if (parameters === void 0) { parameters = null; }
        this._navigator.stack.jump(name, parameters);
    };
    return SingleSceneNavigator;
}(ScillaComponent));

var entry_60 = /*#__PURE__*/Object.freeze({
    'default': SingleSceneNavigator
});

const outputs = {};
outputs['components/animation/Zoom'] = entry_0;
outputs['components/animation/Translation'] = entry_1;
outputs['components/renderer/HtmlRenderer'] = entry_2;
outputs['components/ui/ScrollView'] = entry_3;
outputs['components/ui/Button'] = entry_4;
outputs['components/animation/TouchZoom'] = entry_5;
outputs['components/animation/Fade'] = entry_6;
outputs['components/animation/Wave'] = entry_7;
outputs['components/other/RelativeLayout'] = entry_8;
outputs['components/other/FullStageSize'] = entry_9;
outputs['components/other/CameraController'] = entry_10;
outputs['components/renderer/TextureRenderer'] = entry_11;
outputs['components/renderer/RectRenderer'] = entry_12;
outputs['components/renderer/FrameAnimationRenderer'] = entry_13;
outputs['components/renderer/TextRenderer'] = entry_14;
outputs['components/renderer/LineRenderer'] = entry_15;
outputs['components/base/TouchInterrupt'] = entry_16;
outputs['components/base/InteractComponent'] = entry_17;
outputs['components/renderer/GraphicRenderer'] = entry_18;
outputs['components/base/Transform'] = entry_19;
outputs['components/base/ScillaComponent'] = entry_20;
outputs['components/renderer/Renderer'] = entry_21;
outputs['./scripts/Animation'] = entry_22;
outputs['./scripts/MainController'] = entry_23;
outputs['./scripts/api/ApiComponent'] = entry_24;
outputs['./scripts/api/SampleApi'] = entry_25;
outputs['./scripts/api/SamplePollingApi'] = entry_26;
outputs['./scripts/common/BuriedPoint'] = entry_27;
outputs['./scripts/common/CountDown'] = entry_28;
outputs['./scripts/common/DotWaiting'] = entry_29;
outputs['./scripts/common/FloatMissing'] = entry_30;
outputs['./scripts/common/FlySequence'] = entry_31;
outputs['./scripts/common/LabelCarousel'] = entry_32;
outputs['./scripts/common/RunNumber'] = entry_33;
outputs['./scripts/common/Toast'] = entry_34;
outputs['./scripts/common/WaveController'] = entry_35;
outputs['./scripts/dialogs/AlertDialogContent'] = entry_36;
outputs['./scripts/dialogs/PKChallenge'] = entry_37;
outputs['./scripts/dialogs/PKMatching'] = entry_38;
outputs['./scripts/dialogs/PKResult'] = entry_39;
outputs['./scripts/dialogs/RuleDialogContent'] = entry_40;
outputs['./scripts/dialogs/SingleResult'] = entry_41;
outputs['./scripts/dialogs/pkresult/AnimLayer'] = entry_42;
outputs['./scripts/dialogs/pkresult/ResultLayer'] = entry_43;
outputs['./scripts/game/ApiProcess'] = entry_44;
outputs['./scripts/game/BottomButtonController'] = entry_45;
outputs['./scripts/game/CreditsBar'] = entry_46;
outputs['./scripts/game/CustomButton'] = entry_47;
outputs['./scripts/game/CustomTextRenderer'] = entry_48;
outputs['./scripts/game/GameStage'] = entry_49;
outputs['./scripts/game/Hole'] = entry_50;
outputs['./scripts/game/Item'] = entry_51;
outputs['./scripts/game/ItemLayer'] = entry_52;
outputs['./scripts/game/Miner'] = entry_53;
outputs['./scripts/game/NoticeBar'] = entry_54;
outputs['./scripts/game/PKResultAnimSide'] = entry_55;
outputs['./scripts/game/PKResultSide'] = entry_56;
outputs['./scripts/game/TimesCard'] = entry_57;
outputs['./scripts/game/TwoLinesButton'] = entry_58;
outputs['./scripts/navigator/Navigator'] = entry_59;
outputs['./scripts/navigator/SingleSceneNavigator'] = entry_60;
outputs['./scripts/navigator/StackNavigator'] = entry_61;
outputs['./scripts/navigator/VirtualNavigator'] = entry_62;
outputs['./scripts/popup/DialogContent'] = entry_63;
outputs['./scripts/popup/Popup'] = entry_64;
outputs['./scripts/scenes/ScenePlay'] = entry_65;
outputs['./scripts/scenes/SceneStart'] = entry_66;

exports.outputs = outputs;
//# sourceMappingURL=bundle.js.map
