import * as tslib_1 from "tslib";
import { engine } from "scilla";
import { playAnimation } from "../animation-utils";
import ScillaComponent from "components/base/ScillaComponent";
var animationConfig = {
    enter: {},
    leave: {},
};
var ScenePlay = (function (_super) {
    tslib_1.__extends(ScenePlay, _super);
    function ScenePlay() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._level = 3;
        return _this;
    }
    ScenePlay.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
    };
    ScenePlay.prototype.onDidEnter = function (last, action, parameters) {
    };
    ScenePlay.prototype.onDidLeave = function (next, action, parameters) {
    };
    ScenePlay.prototype.onWillEnter = function (last, action, parameters) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, playAnimation(animationConfig.enter, this)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    ScenePlay.prototype.onWillLeave = function (next, action, parameters) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, playAnimation(animationConfig.leave, this)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    ScenePlay.prototype.onWillMount = function (last, action, parameters) {
        return undefined;
    };
    ScenePlay.prototype.onWillUnMount = function (next, action, parameters) {
        return undefined;
    };
    ScenePlay.prototype.reset = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var id, url, _a;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        id = 1;
                        url = "singles/" + id + ".jpg";
                        _a = this;
                        return [4, engine.assetsManager.loadImage(url)];
                    case 1:
                        _a._img = _b.sent();
                        this.startLevel();
                        return [2];
                }
            });
        });
    };
    ScenePlay.prototype.nextLevel = function () {
        this._level++;
        this.startLevel();
    };
    ScenePlay.prototype.startLevel = function () {
        this._puzzle.start(this._img, this._level);
    };
    return ScenePlay;
}(ScillaComponent));
export default ScenePlay;
//# sourceMappingURL=module.js.map