import * as tslib_1 from "tslib";
import DialogContent from "./DialogContent";
import RectRenderer from "components/renderer/RectRenderer";
import TouchInterrupt from "components/base/TouchInterrupt";
import Transform from "components/base/Transform";
import ScillaComponent from "components/base/ScillaComponent";
import { none } from "./PopupEffect";
import { createTween } from "scilla";
var Popup = (function (_super) {
    tslib_1.__extends(Popup, _super);
    function Popup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.blackLayerDuration = 300;
        _this._dialogStack = [];
        return _this;
    }
    Popup.prototype.onCreate = function () {
        _super.prototype.onCreate.call(this);
        this._touchInterrupt = this.getComponent(TouchInterrupt);
        this._touchInterrupt.enabled = false;
        var bgRenderer = this._bgRenderer = this.getComponent(RectRenderer);
        bgRenderer.enabled = false;
    };
    Popup.prototype.onUpdate = function (t) {
        _super.prototype.onUpdate.call(this, t);
    };
    Popup.prototype.onSleep = function () {
        _super.prototype.onSleep.call(this);
    };
    Popup.prototype.onDestroy = function () {
        _super.prototype.onDestroy.call(this);
    };
    Popup.prototype.setBgVisible = function (visible) {
        var _this = this;
        if (visible) {
            this._bgRenderer.enabled = true;
        }
        this._bgRenderer.alpha = visible ? 0 : 1;
        createTween(this, this._bgRenderer, true)
            .to({ alpha: visible ? 1 : 0 }, this.blackLayerDuration)
            .call(function () {
            if (!visible) {
                _this._bgRenderer.enabled = false;
            }
        });
    };
    Popup.prototype.getDialogInStack = function (name) {
        var e_1, _a;
        var result;
        try {
            for (var _b = tslib_1.__values(this._dialogStack), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dialog = _c.value;
                if (dialog.name === name) {
                    result = dialog;
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return result;
    };
    Popup.prototype.bringToTop = function (dialogConfig) {
        var index = this._dialogStack.indexOf(dialogConfig);
        if (index >= 0) {
            this._dialogStack.splice(index, 1);
        }
        this._dialogStack.push(dialogConfig);
    };
    Popup.prototype.delete = function (dialogConfig) {
        var index = this._dialogStack.indexOf(dialogConfig);
        this._dialogStack.splice(index, 1);
    };
    Popup.prototype.showDialog = function (name, data, callback) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var dialogConfig, dialog, parent, content, transform, effect, effectOptions;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dialogConfig = this.getDialogInStack(name);
                        dialog = this.entity.getChildrenByName(name)[0];
                        if (!dialogConfig) {
                            dialogConfig = {
                                name: name, data: data, callback: callback, dialog: dialog
                            };
                            dialog.enabled = true;
                        }
                        this.bringToTop(dialogConfig);
                        parent = dialog.parent;
                        parent.removeChild(dialog);
                        parent.addChildAt(dialog, parent.children.length);
                        this.setBgVisible(true);
                        this._touchInterrupt.enabled = true;
                        content = dialog.getComponent(DialogContent);
                        content && content.setup(data);
                        transform = dialog.getComponent(Transform);
                        effect = content ? content.effectImpl : none;
                        effectOptions = content ? content.showEffectOptions : null;
                        return [4, effect.show(transform, effectOptions)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    Popup.prototype.hideDialog = function (name, action, data) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var dialogConfig, dialog, transform, content, effect, effectOptions;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dialogConfig = this.getDialogInStack(name);
                        if (!dialogConfig) {
                            return [2];
                        }
                        dialog = this.entity.getChildrenByName(name)[0];
                        this.delete(dialogConfig);
                        if (this._dialogStack.length === 0) {
                            this.setBgVisible(false);
                            this._touchInterrupt.enabled = false;
                        }
                        transform = dialog.getComponent(Transform);
                        content = dialog.getComponent(DialogContent);
                        effect = content ? content.effectImpl : none;
                        effectOptions = content ? content.hideEffectOptions : null;
                        return [4, effect.hide(transform, effectOptions)];
                    case 1:
                        _a.sent();
                        dialog.enabled = false;
                        if (dialogConfig.callback) {
                            dialogConfig.callback(action, data);
                            dialogConfig.callback = null;
                        }
                        return [2];
                }
            });
        });
    };
    Popup.prototype.hideAll = function () {
        var e_2, _a;
        try {
            for (var _b = tslib_1.__values(this._dialogStack), _c = _b.next(); !_c.done; _c = _b.next()) {
                var dialog = _c.value;
                this.hideDialog(dialog.name);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return Popup;
}(ScillaComponent));
export default Popup;
//# sourceMappingURL=module.js.map