import * as tslib_1 from "tslib";
import { utils, engine } from "scilla";
export function callApi(uri, params, method, responseType, ignoreSuccessField) {
    if (params === void 0) { params = null; }
    if (method === void 0) { method = 'post'; }
    if (responseType === void 0) { responseType = 'json'; }
    if (ignoreSuccessField === void 0) { ignoreSuccessField = false; }
    var ts = Date.now() + Math.floor(Math.random() * 9999999);
    var url = uri.indexOf('//') === 0 ? uri : "" + engine.customConfig.webServiceUrl + uri + "?_=" + ts;
    params = params || {};
    var options = {
        method: method,
    };
    if (!DEBUG) {
        options.credentials = 'include';
    }
    var temp = typeof params === 'string' ? params : utils.objectStringify(params);
    switch (method.toUpperCase()) {
        case 'GET':
            if (temp && temp.length > 0) {
                url += (url.indexOf('?') < 0 ? '?' : '') + '&' + temp;
            }
            break;
        case 'POST':
            options.body = temp;
            options.headers = {
                'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8',
            };
            break;
    }
    var fetchMethod = responseType == 'jsonp' ? window['fetchJsonp'] : fetch;
    return fetchMethod(url, options)
        .then(function (response) {
        if (response.type === 'opaque') {
            return null;
        }
        return response.text();
    })
        .then(function (response) {
        if (response) {
            var data = void 0;
            switch (responseType) {
                case 'json':
                    try {
                        data = JSON.parse(response);
                    }
                    catch (e) {
                        console.log('decode json failed: ' + url);
                        return Promise.reject({});
                    }
                    if (ignoreSuccessField || data.success) {
                        return {
                            data: data.hasOwnProperty('data') ? data.data : data,
                            origin: data,
                        };
                    }
                    else {
                        return Promise.reject(data.code);
                    }
                case 'html':
                    var html = null;
                    return html;
                case 'txt':
                    return response;
            }
        }
        return Promise.reject();
    });
}
export function polling(successFunc, uri, params, maxTimes, delay, abortFunc, method, responseType) {
    if (maxTimes === void 0) { maxTimes = 10; }
    if (delay === void 0) { delay = 500; }
    if (method === void 0) { method = 'POST'; }
    if (responseType === void 0) { responseType = 'json'; }
    return tslib_1.__awaiter(this, void 0, Promise, function () {
        function func() {
            return callApi(uri, params, method, responseType).then(function (data) {
                if (successFunc(data)) {
                    lastData = data;
                    return Promise.reject('success');
                }
            });
        }
        var lastData, needBreak, i;
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < maxTimes)) return [3, 5];
                    return [4, func().catch(function (e) {
                            if (e === 'success') {
                                needBreak = true;
                            }
                            else {
                                throw e;
                            }
                        })];
                case 2:
                    _a.sent();
                    if (needBreak) {
                        return [3, 5];
                    }
                    if (abortFunc()) {
                        throw new Error('abort');
                    }
                    return [4, utils.waitPromise(delay)];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    i++;
                    return [3, 1];
                case 5:
                    if (!needBreak) {
                        throw new Error('timeout');
                    }
                    return [2, lastData];
            }
        });
    });
}
export function getToken(uri, params, method, responseType) {
    if (method === void 0) { method = 'POST'; }
    if (responseType === void 0) { responseType = 'json'; }
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var _this = this;
        return tslib_1.__generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!window['getDuibaToken']) return [3, 1];
                    window['getDuibaToken'](function (tokenObj) { return tslib_1.__awaiter(_this, void 0, void 0, function () {
                        return tslib_1.__generator(this, function (_a) {
                            switch (_a.label) {
                                case 0:
                                    params.token = tokenObj.token;
                                    return [4, this.send(uri, params, method, responseType)];
                                case 1:
                                    _a.sent();
                                    return [2];
                            }
                        });
                    }); }, function () {
                    });
                    return [3, 3];
                case 1: return [4, this.send(uri, params, method, responseType)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3: return [2];
            }
        });
    });
}
export function createSgin(ticketId, score, gameData, submitToken) {
    return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
}
//# sourceMappingURL=module.js.map